/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

public class SamStreams {
    private static int readBytes(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) > 0; n3 += n4) {
        }
        return n3;
    }

    public static boolean isCRAMFile(InputStream inputStream) throws IOException {
        inputStream.mark(4);
        int n = CramHeader.MAGIC.length;
        byte[] byArray = new byte[n];
        SamStreams.readBytes(inputStream, byArray, 0, n);
        inputStream.reset();
        return Arrays.equals(byArray, CramHeader.MAGIC);
    }

    public static boolean isBAMFile(InputStream inputStream) throws IOException {
        if (!BlockCompressedInputStream.isValidFile(inputStream)) {
            return false;
        }
        inputStream.mark(65536);
        byte[] byArray = new byte[65536];
        SamStreams.readBytes(inputStream, byArray, 0, 65536);
        inputStream.reset();
        byte[] byArray2 = new byte[4];
        int n = SamStreams.readBytes(new BlockCompressedInputStream(new ByteArrayInputStream(byArray)), byArray2, 0, 4);
        return n == BAMFileConstants.BAM_MAGIC.length && Arrays.equals(BAMFileConstants.BAM_MAGIC, byArray2);
    }

    public static boolean sourceLikeBam(SeekableStream seekableStream) {
        String string = seekableStream.getSource();
        if (string == null) {
            return true;
        }
        return (string = string.toLowerCase()).endsWith(".bam") || string.contains(".bam?") || string.contains(".bam&") || string.contains(".bam%26");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGzippedSAMFile(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Cannot test a stream that doesn't support marking.");
        }
        inputStream.mark(8000);
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
            int n = gZIPInputStream.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                inputStream.reset();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not reset stream.");
            }
        }
    }
}

