/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public enum SamIndexes {
    BAI(".bai", "BAI\u0001".getBytes()),
    CRAI(".crai", new byte[]{31, -117});

    public final String fileNameSuffix;
    public final byte[] magic;

    private SamIndexes(String string2, byte[] byArray) {
        this.fileNameSuffix = string2;
        this.magic = byArray;
    }

    public static InputStream openIndexFileAsBaiOrNull(File file, SAMSequenceDictionary sAMSequenceDictionary) throws IOException {
        return SamIndexes.openIndexUrlAsBaiOrNull(file.toURI().toURL(), sAMSequenceDictionary);
    }

    public static InputStream openIndexUrlAsBaiOrNull(URL uRL, SAMSequenceDictionary sAMSequenceDictionary) throws IOException {
        if (uRL.getFile().toLowerCase().endsWith(SamIndexes.BAI.fileNameSuffix.toLowerCase())) {
            return uRL.openStream();
        }
        if (uRL.getFile().toLowerCase().endsWith(SamIndexes.CRAI.fileNameSuffix.toLowerCase())) {
            return CRAIIndex.openCraiFileAsBaiStream(uRL.openStream(), sAMSequenceDictionary);
        }
        return null;
    }

    public static InputStream asBaiStreamOrNull(InputStream inputStream, SAMSequenceDictionary sAMSequenceDictionary) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(SamIndexes.BAI.magic.length);
        if (SamIndexes.doesStreamStartWith(bufferedInputStream, SamIndexes.BAI.magic)) {
            bufferedInputStream.reset();
            return bufferedInputStream;
        }
        bufferedInputStream.reset();
        bufferedInputStream.mark(SamIndexes.CRAI.magic.length);
        if (SamIndexes.doesStreamStartWith(bufferedInputStream, SamIndexes.CRAI.magic)) {
            bufferedInputStream.reset();
            return CRAIIndex.openCraiFileAsBaiStream(bufferedInputStream, sAMSequenceDictionary);
        }
        bufferedInputStream.reset();
        return null;
    }

    public static SeekableStream asBaiSeekableStreamOrNull(SeekableStream seekableStream, SAMSequenceDictionary sAMSequenceDictionary) throws IOException {
        SeekableBufferedStream seekableBufferedStream = new SeekableBufferedStream(seekableStream);
        seekableBufferedStream.seek(0L);
        if (SamIndexes.doesStreamStartWith(seekableBufferedStream, SamIndexes.BAI.magic)) {
            seekableBufferedStream.seek(0L);
            return seekableBufferedStream;
        }
        seekableBufferedStream.seek(0L);
        if (SamIndexes.doesStreamStartWith(seekableBufferedStream, SamIndexes.CRAI.magic)) {
            seekableBufferedStream.seek(0L);
            return CRAIIndex.openCraiFileAsBaiStream(seekableBufferedStream, sAMSequenceDictionary);
        }
        seekableBufferedStream.reset();
        return null;
    }

    private static boolean doesStreamStartWith(InputStream inputStream, byte[] byArray) throws IOException {
        for (byte by : byArray) {
            if (inputStream.read() == (0xFF & by)) continue;
            return false;
        }
        return true;
    }
}

