/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMSequenceRecord;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="References")
public class SAMSequenceDictionary
implements Serializable {
    public static final long serialVersionUID = 1L;
    @XmlElement(name="Reference")
    private List<SAMSequenceRecord> mSequences = new ArrayList<SAMSequenceRecord>();
    private final Map<String, SAMSequenceRecord> mSequenceMap = new HashMap<String, SAMSequenceRecord>();
    private static String DICT_MISMATCH_TEMPLATE = "SAM dictionaries are not the same: %s.";

    public SAMSequenceDictionary() {
    }

    public SAMSequenceDictionary(List<SAMSequenceRecord> list) {
        this();
        this.setSequences(list);
    }

    @XmlTransient
    public List<SAMSequenceRecord> getSequences() {
        return Collections.unmodifiableList(this.mSequences);
    }

    public SAMSequenceRecord getSequence(String string) {
        return this.mSequenceMap.get(string);
    }

    public void setSequences(List<SAMSequenceRecord> list) {
        this.mSequences = list;
        this.mSequenceMap.clear();
        int n = 0;
        for (SAMSequenceRecord sAMSequenceRecord : list) {
            sAMSequenceRecord.setSequenceIndex(n++);
            if (this.mSequenceMap.put(sAMSequenceRecord.getSequenceName(), sAMSequenceRecord) == null) continue;
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sAMSequenceRecord.getSequenceName());
        }
    }

    public void addSequence(SAMSequenceRecord sAMSequenceRecord) {
        if (this.mSequenceMap.containsKey(sAMSequenceRecord.getSequenceName())) {
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sAMSequenceRecord.getSequenceName());
        }
        sAMSequenceRecord.setSequenceIndex(this.mSequences.size());
        this.mSequences.add(sAMSequenceRecord);
        this.mSequenceMap.put(sAMSequenceRecord.getSequenceName(), sAMSequenceRecord);
    }

    public SAMSequenceRecord getSequence(int n) {
        if (n < 0 || n >= this.mSequences.size()) {
            return null;
        }
        return this.mSequences.get(n);
    }

    public int getSequenceIndex(String string) {
        SAMSequenceRecord sAMSequenceRecord = this.mSequenceMap.get(string);
        if (sAMSequenceRecord == null) {
            return -1;
        }
        return sAMSequenceRecord.getSequenceIndex();
    }

    public int size() {
        return this.mSequences.size();
    }

    public long getReferenceLength() {
        long l = 0L;
        for (SAMSequenceRecord sAMSequenceRecord : this.getSequences()) {
            l += (long)sAMSequenceRecord.getSequenceLength();
        }
        return l;
    }

    public boolean isEmpty() {
        return this.mSequences.isEmpty();
    }

    public void assertSameDictionary(SAMSequenceDictionary sAMSequenceDictionary) {
        if (this == sAMSequenceDictionary) {
            return;
        }
        Iterator<SAMSequenceRecord> iterator = sAMSequenceDictionary.mSequences.iterator();
        for (SAMSequenceRecord sAMSequenceRecord : this.mSequences) {
            if (!iterator.hasNext()) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, sAMSequenceRecord + " is present in only one dictionary"));
            }
            SAMSequenceRecord sAMSequenceRecord2 = iterator.next();
            if (!sAMSequenceRecord2.isSameSequence(sAMSequenceRecord)) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, sAMSequenceRecord2 + " was found when " + sAMSequenceRecord + " was expected"));
            }
        }
        if (iterator.hasNext()) {
            throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, iterator.next() + " is present in only one dictionary"));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SAMSequenceDictionary sAMSequenceDictionary = (SAMSequenceDictionary)object;
        return this.mSequences.equals(sAMSequenceDictionary.mSequences);
    }

    public SAMSequenceRecord addSequenceAlias(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("original name cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("alt name cannot be null");
        }
        SAMSequenceRecord sAMSequenceRecord = this.getSequence(string);
        if (sAMSequenceRecord == null) {
            throw new IllegalArgumentException("Sequence " + string + " doesn't exist in dictionary.");
        }
        if (string.equals(string2)) {
            return sAMSequenceRecord;
        }
        SAMSequenceRecord sAMSequenceRecord2 = this.getSequence(string2);
        if (sAMSequenceRecord2 != null) {
            if (sAMSequenceRecord2.equals(sAMSequenceRecord)) {
                return sAMSequenceRecord;
            }
            throw new IllegalArgumentException("Alias " + string2 + " was already set to " + sAMSequenceRecord2.getSequenceName());
        }
        this.mSequenceMap.put(string2, sAMSequenceRecord);
        return sAMSequenceRecord;
    }

    public String md5() {
        if (this.isEmpty()) {
            return "";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            for (SAMSequenceRecord sAMSequenceRecord : this.mSequences) {
                String string;
                if (sAMSequenceRecord.getSequenceIndex() > 0) {
                    messageDigest.update((byte)32);
                }
                if ((string = sAMSequenceRecord.getAttribute("M5")) != null) {
                    messageDigest.update(string.getBytes());
                    continue;
                }
                messageDigest.update(sAMSequenceRecord.getSequenceName().getBytes());
                messageDigest.update(String.valueOf(sAMSequenceRecord.getSequenceLength()).getBytes());
            }
            Object object = new BigInteger(1, messageDigest.digest()).toString(16);
            if (((String)object).length() != 32) {
                object = "00000000000000000000000000000000".substring(0, 32 - ((String)object).length()) + (String)object;
            }
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int hashCode() {
        return this.mSequences.hashCode();
    }

    public String toString() {
        return "SAMSequenceDictionary:( sequences:" + this.size() + " length:" + this.getReferenceLength() + " " + " md5:" + this.md5() + ")";
    }
}

