/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.TagValueAndUnsignedArrayFlag;
import htsjdk.samtools.TextTagCodec;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SAMLineParser {
    private static final int QNAME_COL = 0;
    private static final int FLAG_COL = 1;
    private static final int RNAME_COL = 2;
    private static final int POS_COL = 3;
    private static final int MAPQ_COL = 4;
    private static final int CIGAR_COL = 5;
    private static final int MRNM_COL = 6;
    private static final int MPOS_COL = 7;
    private static final int ISIZE_COL = 8;
    private static final int SEQ_COL = 9;
    private static final int QUAL_COL = 10;
    private static final int NUM_REQUIRED_FIELDS = 11;
    private static final Pattern VALID_BASES = Pattern.compile("^[acmgrsvtwyhkdbnACMGRSVTWYHKDBN.=]+$");
    private final String[] mFields = new String[10000];
    private final SamReader mParentReader;
    private final SAMRecordFactory samRecordFactory;
    private final ValidationStringency validationStringency;
    private final SAMFileHeader mFileHeader;
    private final File mFile;
    private final TextTagCodec tagCodec = new TextTagCodec();
    private int currentLineNumber;
    private String currentLine;

    public SAMLineParser(SAMFileHeader sAMFileHeader) {
        this(new DefaultSAMRecordFactory(), ValidationStringency.DEFAULT_STRINGENCY, sAMFileHeader, null, null);
    }

    public SAMLineParser(SAMFileHeader sAMFileHeader, SamReader samReader, File file) {
        this(new DefaultSAMRecordFactory(), ValidationStringency.DEFAULT_STRINGENCY, sAMFileHeader, samReader, file);
    }

    public SAMLineParser(SAMRecordFactory sAMRecordFactory, ValidationStringency validationStringency, SAMFileHeader sAMFileHeader, SamReader samReader, File file) {
        if (sAMRecordFactory == null) {
            throw new NullPointerException("The SamRecordFactory must be set");
        }
        if (validationStringency == null) {
            throw new NullPointerException("The validationStringency must be set");
        }
        if (sAMFileHeader == null) {
            throw new NullPointerException("The mFileHeader must be set");
        }
        this.samRecordFactory = sAMRecordFactory;
        this.validationStringency = validationStringency;
        this.mFileHeader = sAMFileHeader;
        this.mParentReader = samReader;
        this.mFile = file;
    }

    public SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    private int parseInt(String string, String string2) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.reportFatalErrorParsingLine("Non-numeric value in " + string2 + " column");
        }
        return n;
    }

    private void validateReferenceName(String string, String string2) {
        if (string.equals("=")) {
            if (string2.equals("MRNM")) {
                return;
            }
            this.reportErrorParsingLine("= is not a valid value for " + string2 + " field.");
        }
        if (this.mFileHeader.getSequenceDictionary().size() != 0 && this.mFileHeader.getSequence(string) == null) {
            this.reportErrorParsingLine(string2 + " '" + string + "' not found in any SQ record");
        }
    }

    public SAMRecord parseLine(String string) {
        return this.parseLine(string, -1);
    }

    public SAMRecord parseLine(String string, int n) {
        List<SAMValidationError> list;
        String string2 = string;
        this.currentLineNumber = n;
        this.currentLine = string;
        int n2 = StringUtil.split(string2, this.mFields, '\t');
        if (n2 < 11) {
            throw this.reportFatalErrorParsingLine("Not enough fields");
        }
        if (n2 == this.mFields.length) {
            this.reportErrorParsingLine("Too many fields in SAM text record.");
        }
        for (int i = 0; i < n2; ++i) {
            if (this.mFields[i].length() != 0) continue;
            this.reportErrorParsingLine("Empty field at position " + i + " (zero-based)");
        }
        SAMRecord sAMRecord = this.samRecordFactory.createSAMRecord(this.mFileHeader);
        sAMRecord.setValidationStringency(this.validationStringency);
        if (this.mParentReader != null) {
            sAMRecord.setFileSource(new SAMFileSource(this.mParentReader, null));
        }
        sAMRecord.setHeader(this.mFileHeader);
        sAMRecord.setReadName(this.mFields[0]);
        int n3 = this.parseInt(this.mFields[1], "FLAG");
        sAMRecord.setFlags(n3);
        String string3 = this.mFields[2];
        if (!string3.equals("*")) {
            string3 = SAMSequenceRecord.truncateSequenceName(string3);
            this.validateReferenceName(string3, "RNAME");
            sAMRecord.setReferenceName(string3);
        } else if (!sAMRecord.getReadUnmappedFlag()) {
            this.reportErrorParsingLine("RNAME is not specified but flags indicate mapped");
        }
        int n4 = this.parseInt(this.mFields[3], "POS");
        int n5 = this.parseInt(this.mFields[4], "MAPQ");
        String string4 = this.mFields[5];
        if (!"*".equals(sAMRecord.getReferenceName())) {
            if (n4 == 0) {
                this.reportErrorParsingLine("POS must be non-zero if RNAME is specified");
            }
            if (!sAMRecord.getReadUnmappedFlag() && string4.equals("*")) {
                this.reportErrorParsingLine("CIGAR must not be '*' if RNAME is specified");
            }
        } else {
            if (n4 != 0) {
                this.reportErrorParsingLine("POS must be zero if RNAME is not specified");
            }
            if (n5 != 0) {
                this.reportErrorParsingLine("MAPQ must be zero if RNAME is not specified");
            }
            if (!string4.equals("*")) {
                this.reportErrorParsingLine("CIGAR must be '*' if RNAME is not specified");
            }
        }
        sAMRecord.setAlignmentStart(n4);
        sAMRecord.setMappingQuality(n5);
        sAMRecord.setCigarString(string4);
        String string5 = this.mFields[6];
        if (string5.equals("*")) {
            if (sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag()) {
                this.reportErrorParsingLine("MRNM not specified but flags indicate mate mapped");
            }
        } else {
            if (!sAMRecord.getReadPairedFlag()) {
                this.reportErrorParsingLine("MRNM specified but flags indicate unpaired");
            }
            if (!"=".equals(string5)) {
                string5 = SAMSequenceRecord.truncateSequenceName(string5);
            }
            this.validateReferenceName(string5, "MRNM");
            if (string5.equals("=")) {
                if (sAMRecord.getReferenceName() == null) {
                    this.reportErrorParsingLine("MRNM is '=', but RNAME is not set");
                }
                sAMRecord.setMateReferenceName(sAMRecord.getReferenceName());
            } else {
                sAMRecord.setMateReferenceName(string5);
            }
        }
        int n6 = this.parseInt(this.mFields[7], "MPOS");
        int n7 = this.parseInt(this.mFields[8], "ISIZE");
        if (!sAMRecord.getMateReferenceName().equals("*")) {
            if (n6 == 0) {
                this.reportErrorParsingLine("MPOS must be non-zero if MRNM is specified");
            }
        } else {
            if (n6 != 0) {
                this.reportErrorParsingLine("MPOS must be zero if MRNM is not specified");
            }
            if (n7 != 0) {
                this.reportErrorParsingLine("ISIZE must be zero if MRNM is not specified");
            }
        }
        sAMRecord.setMateAlignmentStart(n6);
        sAMRecord.setInferredInsertSize(n7);
        if (!this.mFields[9].equals("*")) {
            this.validateReadBases(this.mFields[9]);
            sAMRecord.setReadString(this.mFields[9]);
        } else {
            sAMRecord.setReadBases(SAMRecord.NULL_SEQUENCE);
        }
        if (!this.mFields[10].equals("*")) {
            if (sAMRecord.getReadBases() == SAMRecord.NULL_SEQUENCE) {
                this.reportErrorParsingLine("QUAL should not be specified if SEQ is not specified");
            }
            if (sAMRecord.getReadString().length() != this.mFields[10].length()) {
                this.reportErrorParsingLine("length(QUAL) != length(SEQ)");
            }
            sAMRecord.setBaseQualityString(this.mFields[10]);
        } else {
            sAMRecord.setBaseQualities(SAMRecord.NULL_QUALS);
        }
        for (int i = 11; i < n2; ++i) {
            this.parseTag(sAMRecord, this.mFields[i]);
        }
        if (this.validationStringency != ValidationStringency.SILENT && (list = sAMRecord.isValid()) != null) {
            for (SAMValidationError sAMValidationError : list) {
                this.reportErrorParsingLine(sAMValidationError.getMessage());
            }
        }
        return sAMRecord;
    }

    private void validateReadBases(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.isValidReadBase(string.charAt(i))) continue;
            this.reportErrorParsingLine("Invalid character in read bases");
            return;
        }
    }

    private boolean isValidReadBase(char c) {
        switch (c) {
            case '.': 
            case '=': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'G': 
            case 'H': 
            case 'K': 
            case 'M': 
            case 'N': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'V': 
            case 'W': 
            case 'Y': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'g': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': 
            case 'v': 
            case 'w': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    private void parseTag(SAMRecord sAMRecord, String string) {
        Map.Entry<String, Object> entry = null;
        try {
            entry = this.tagCodec.decode(string);
        }
        catch (SAMFormatException sAMFormatException) {
            this.reportErrorParsingLine(sAMFormatException);
        }
        if (entry != null) {
            if (entry.getValue() instanceof TagValueAndUnsignedArrayFlag) {
                TagValueAndUnsignedArrayFlag tagValueAndUnsignedArrayFlag = (TagValueAndUnsignedArrayFlag)entry.getValue();
                if (tagValueAndUnsignedArrayFlag.isUnsignedArray) {
                    sAMRecord.setUnsignedArrayAttribute(entry.getKey(), tagValueAndUnsignedArrayFlag.value);
                } else {
                    sAMRecord.setAttribute(entry.getKey(), tagValueAndUnsignedArrayFlag.value);
                }
            } else {
                sAMRecord.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    private RuntimeException reportFatalErrorParsingLine(String string) {
        return new SAMFormatException(this.makeErrorString(string));
    }

    private void reportErrorParsingLine(String string) {
        String string2 = this.makeErrorString(string);
        if (this.validationStringency == ValidationStringency.STRICT) {
            throw new SAMFormatException(string2);
        }
        if (this.validationStringency == ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error due to lenient parsing:");
            System.err.println(string2);
        }
    }

    private void reportErrorParsingLine(Exception exception) {
        String string = this.makeErrorString(exception.getMessage());
        if (this.validationStringency == ValidationStringency.STRICT) {
            throw new SAMFormatException(string);
        }
        if (this.validationStringency == ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error due to lenient parsing:");
            System.err.println(string);
        }
    }

    private String makeErrorString(String string) {
        String string2 = "";
        if (this.mFile != null) {
            string2 = "File " + this.mFile + "; ";
        }
        return "Error parsing text SAM file. " + string + "; " + string2 + "Line " + (this.currentLineNumber <= 0 ? "unknown" : Integer.valueOf(this.currentLineNumber)) + "\nLine: " + this.currentLine;
    }
}

