/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.BAMIndexWriter;
import htsjdk.samtools.BinaryBAMIndexWriter;
import htsjdk.samtools.BinningIndexBuilder;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.TextualBAMIndexWriter;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.OutputStream;

public class BAMIndexer {
    private final int numReferences;
    private final BAMIndexWriter outputWriter;
    private int currentReference = 0;
    private final BAMIndexBuilder indexBuilder;

    public BAMIndexer(File file, SAMFileHeader sAMFileHeader) {
        this.numReferences = sAMFileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(sAMFileHeader.getSequenceDictionary());
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, file);
    }

    public BAMIndexer(OutputStream outputStream, SAMFileHeader sAMFileHeader) {
        this.numReferences = sAMFileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(sAMFileHeader.getSequenceDictionary());
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, outputStream);
    }

    public void processAlignment(SAMRecord sAMRecord) {
        try {
            int n = sAMRecord.getReferenceIndex();
            if (n != -1 && n != this.currentReference) {
                this.advanceToReference(n);
            }
            this.indexBuilder.processAlignment(sAMRecord);
        }
        catch (Exception exception) {
            throw new SAMException("Exception creating BAM index for record " + sAMRecord, exception);
        }
    }

    public void finish() {
        this.advanceToReference(this.numReferences);
        this.outputWriter.writeNoCoordinateRecordCount(this.indexBuilder.getNoCoordinateRecordCount());
        this.outputWriter.close();
    }

    private void advanceToReference(int n) {
        while (this.currentReference < n) {
            BAMIndexContent bAMIndexContent = this.indexBuilder.processReference(this.currentReference);
            this.outputWriter.writeReference(bAMIndexContent);
            ++this.currentReference;
            if (this.currentReference >= this.numReferences) continue;
            this.indexBuilder.startNewReference();
        }
    }

    public static void createAndWriteIndex(File file, File file2, boolean bl) {
        CachingBAMFileIndex cachingBAMFileIndex = new CachingBAMFileIndex(file, null);
        int n = cachingBAMFileIndex.getNumberOfReferences();
        BAMIndexWriter bAMIndexWriter = bl ? new TextualBAMIndexWriter(n, file2) : new BinaryBAMIndexWriter(n, file2);
        try {
            for (int i = 0; i < n; ++i) {
                bAMIndexWriter.writeReference(cachingBAMFileIndex.getQueryResults(i));
            }
            bAMIndexWriter.writeNoCoordinateRecordCount(cachingBAMFileIndex.getNoCoordinateCount());
            bAMIndexWriter.close();
        }
        catch (Exception exception) {
            throw new SAMException("Exception creating BAM index", exception);
        }
    }

    public static void createIndex(SamReader samReader, File file) {
        BAMIndexer.createIndex(samReader, file, null);
    }

    public static void createIndex(SamReader samReader, File file, Log log) {
        BAMIndexer bAMIndexer = new BAMIndexer(file, samReader.getFileHeader());
        long l = 0L;
        for (SAMRecord sAMRecord : samReader) {
            if (++l % 1000000L == 0L && null != log) {
                log.info(l + " reads processed ...");
            }
            bAMIndexer.processAlignment(sAMRecord);
        }
        bAMIndexer.finish();
    }

    private class BAMIndexBuilder {
        private final SAMSequenceDictionary sequenceDictionary;
        private BinningIndexBuilder binningIndexBuilder;
        private int currentReference = -1;
        private final BAMIndexMetaData indexStats = new BAMIndexMetaData();

        BAMIndexBuilder(SAMSequenceDictionary sAMSequenceDictionary) {
            this.sequenceDictionary = sAMSequenceDictionary;
            if (!sAMSequenceDictionary.isEmpty()) {
                this.startNewReference();
            }
        }

        public void processAlignment(final SAMRecord sAMRecord) {
            this.indexStats.recordMetaData(sAMRecord);
            if (sAMRecord.getAlignmentStart() == 0) {
                return;
            }
            int n = sAMRecord.getReferenceIndex();
            if (n != this.currentReference) {
                throw new SAMException("Unexpected reference " + n + " when constructing index for " + this.currentReference + " for record " + sAMRecord);
            }
            this.binningIndexBuilder.processFeature(new BinningIndexBuilder.FeatureToBeIndexed(){

                @Override
                public int getStart() {
                    return sAMRecord.getAlignmentStart();
                }

                @Override
                public int getEnd() {
                    return sAMRecord.getAlignmentEnd();
                }

                @Override
                public Integer getIndexingBin() {
                    Integer n = sAMRecord.getIndexingBin();
                    return n == null ? sAMRecord.computeIndexingBin() : n.intValue();
                }

                @Override
                public Chunk getChunk() {
                    SAMFileSource sAMFileSource = sAMRecord.getFileSource();
                    if (sAMFileSource == null) {
                        throw new SAMException("No source (virtual file offsets); needed for indexing on BAM Record " + sAMRecord);
                    }
                    return ((BAMFileSpan)sAMFileSource.getFilePointer()).getSingleChunk();
                }
            });
        }

        public BAMIndexContent processReference(int n) {
            if (n != this.currentReference) {
                throw new SAMException("Unexpected reference " + n + " when constructing index for " + this.currentReference);
            }
            BinningIndexContent binningIndexContent = this.binningIndexBuilder.generateIndexContent();
            if (binningIndexContent == null) {
                return null;
            }
            return new BAMIndexContent(binningIndexContent.getReferenceSequence(), binningIndexContent.getBins(), this.indexStats, binningIndexContent.getLinearIndex());
        }

        public long getNoCoordinateRecordCount() {
            return this.indexStats.getNoCoordinateRecordCount();
        }

        void startNewReference() {
            ++this.currentReference;
            this.indexStats.newReference();
            this.binningIndexBuilder = new BinningIndexBuilder(this.currentReference, this.sequenceDictionary.getSequence(this.currentReference).getSequenceLength());
        }
    }
}

