/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util.validation;

import java.io.File;
import java.io.IOException;

public class CatalogFileValidator {
    public static boolean catalogExists(String catalogFilePath) {
        if (catalogFilePath == null) {
            return false;
        }
        File catalogFile = new File(catalogFilePath);
        return CatalogFileValidator.catalogExists(catalogFile);
    }

    public static boolean catalogExists(File catalogFile) {
        if (catalogFile == null) {
            return false;
        }
        if (!catalogFile.exists()) {
            return false;
        }
        return catalogFile.length() > 0L;
    }

    public static boolean hasExpectedSuffix(String catalogFilePath) {
        return catalogFilePath != null && catalogFilePath.length() != 0 && catalogFilePath.endsWith(".tsv.bgz");
    }

    public static boolean hasExpectedSuffix(File catalogFile) {
        try {
            if (catalogFile == null) {
                return false;
            }
            return CatalogFileValidator.hasExpectedSuffix(catalogFile.getCanonicalPath());
        }
        catch (IOException io) {
            return false;
        }
    }
}

