/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.Treat.SplitFile;
import edu.mayo.bior.pipeline.Variant2JSONPipe;
import edu.mayo.bior.pipes.history.MakeFirstLineHeaderPipe;
import edu.mayo.bior.util.Catalog;
import edu.mayo.bior.util.CatalogInfo;
import edu.mayo.bior.util.CatalogUtils;
import edu.mayo.bior.util.DefaultProcessor;
import edu.mayo.bior.util.FieldProcessor;
import edu.mayo.bior.util.LookupProcessor;
import edu.mayo.bior.util.ModInt;
import edu.mayo.bior.util.TextCleaner;
import edu.mayo.bior.util.TextWrapper;
import edu.mayo.pipes.JSON.DrillPipe;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.JSON.tabix.OverlapPipe;
import edu.mayo.pipes.JSON.tabix.SameVariantPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.iterators.Compressor;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BioR {
    private static List<String> errorStrings = new ArrayList<String>();
    private static Map<String, String> gHeadersToDrills = new HashMap<String, String>();
    private static DefaultProcessor gDefaultProcessor = null;
    private static List<String> gOverlapPaths = new ArrayList<String>();
    private static Map<String, String[]> gLookupDrill = new HashMap<String, String[]>();
    private static Map<String, String> gLookupCatalogs = new HashMap<String, String>();
    private static Map<String, Map<String, String>> gLookupIndexes = new HashMap<String, Map<String, String>>();
    private static Map<String, FieldProcessor> gFieldProcessorMap = new HashMap<String, FieldProcessor>();
    private static final String[] kBaseDrill = new String[]{"_landmark", "_minBP", "_refAllele", "_altAlleles"};
    private static final String[] kBaseHeader = new String[]{"bior.chrom", "bior.startPos", "Ref", "Alt"};
    private static final String[] kCosmicDrill = new String[]{"Mutation_ID", "Mutation_AA", "Mutation_CDS", "Mutation_GRCh37_strand"};
    private static final String[] kCosmicHeader = new String[]{"Cosmic.ID", "Cosmic.Amino.Acid.Change", "Cosmic.Change", "Cosmic.Strand"};
    private static final String[] kNCBIDrill = new String[]{"INFO.RS", "INFO.dbSNPBuildID", "INFO.SAO", "INFO.SSR"};
    private static final String[] kNCBIHeader = new String[]{"dbSNP.rsID", "dbSNP.build", "dbSNP.SNP.Allele.Origin", "dbSNP.Suspect.Region"};
    private static final String[] kGenomeDrill = new String[]{"INFO.AFR_AF", "INFO.AMR_AF", "INFO.EAS_AF", "INFO.EUR_AF", "INFO.SAS_AF"};
    private static final String[] kGenomeHeader = new String[]{"kGenomes.AFR.MAF", "kGenomes.AMR.MAF", "kGenomes.EAS.MAF", "kGenomes.EUR.MAF", "kGenomes.SAS.MAF"};
    private static final String[] kHapMapDrill = new String[]{"ASW.otherallele_freq", "CEU.otherallele_freq", "CHB.otherallele_freq", "CHD.otherallele_freq", "GIH.otherallele_freq", "JPT.otherallele_freq", "LWK.otherallele_freq", "MEX.otherallele_freq", "MKK.otherallele_freq", "TSI.otherallele_freq", "YRI.otherallele_freq"};
    private static final String[] kHapMapHeader = new String[]{"HapMap.ASW.MAF", "HapMap.CEU.MAF", "HapMap.CHB.MAF", "HapMap.CHD.MAF", "HapMap.GIH.MAF", "HapMap.JPT.MAF", "HapMap.LWK.MAF", "HapMap.MEX.MAF", "HapMap.MKK.MAF", "HapMap.TSI.MAF", "HapMap.YRI.MAF"};
    private static final String[] kHGNCDrill = new String[]{"name", "symbol", "ensembl_gene_id", "entrez_id", "hgnc_id"};
    private static final String[] kHGNCHeader = new String[]{"HGNC.Approved.Gene.Name", "HGNC.Approved.Gene.Symbol", "HGNC.Ensembl.Gene.ID", "HGNC.Entrez.Gene.ID", "HGNC.ID"};
    private static final String[] kBGIDrill = new String[]{"estimated_minor_allele_freq"};
    private static final String[] kBGIHeader = new String[]{"BGI200.Danish.MAF"};
    private static final String[] kESPDrill = new String[]{"AA._maf", "EA._maf"};
    private static final String[] kESPHeader = new String[]{"ESP6500.AFR.MAF", "ESP6500.EUR.MAF"};
    private static final String[] kMirBaseDrill = new String[]{"ID"};
    private static final String[] kMirBaseHeader = new String[]{"mirBase.ID"};
    private static final String[] kOMIMDrill = new String[]{"name"};
    private static final String[] kOMIMHeader = new String[]{"OMIM.Disease"};
    private static final String[] kUCSCBRDrill = new String[]{"name", "score"};
    private static final String[] kUCSCBRHeader = new String[]{"UCSCBR.Name", "UCSCBR.Score"};
    private static final int kHeaders = 0;
    private static final int kDrills = 1;
    private static final String[][][] kHeaderDrillPairs = new String[][][]{{kBaseHeader, kBaseDrill}, {kCosmicHeader, kCosmicDrill}, {kNCBIHeader, kNCBIDrill}, {kGenomeHeader, kGenomeDrill}, {kHapMapHeader, kHapMapDrill}, {kHGNCHeader, kHGNCDrill}, {kBGIHeader, kBGIDrill}, {kESPHeader, kESPDrill}, {kMirBaseHeader, kMirBaseDrill}, {kOMIMHeader, kOMIMDrill}, {kUCSCBRHeader, kUCSCBRDrill}};
    private static final String[] kDbSnpSuspectLookup = new String[]{"unspecified", "Paralog", "byEST", "Para_EST", "oldAlign", "other"};
    protected static final String[] kDbSnpClinicalLookup = new String[]{"unknown", "untested", "non-pathogenic", "probable-non-pathogenic", "probable-pathogenic", "pathogenic", "drug-response", "histocompatibility", "other"};
    private static final String[] kDbSnpAlleleLookup = new String[]{"unspecified", "Germline", "Somatic", "Both", "not-tested", "tested-inconclusive", "other"};
    private static final int kNCBIRsID = 0;
    private static final int kNCBIBuildID = 1;
    private static final int kNCBIAlleleOrigin = 2;
    private static final int kNCBISuspect = 3;
    private static final int kChrom = 0;
    private static final int kStartPos = 1;
    private static final int kRef = 2;
    private static final int kAlt = 3;
    private static final int kMinFieldSize = 2;
    private static final int kInFile = 0;
    private static final int kBuildID = 1;
    private static final int kCatalogFile = 2;
    private static final int kFieldsFile = 3;
    private static final int kNumParams = 4;
    private static final int kName = 0;
    private static final int kPath = 1;
    private static final int kIsOverlap = 2;
    private static final int kNumCatCols = 3;
    private static final boolean kKeepOld = true;
    private static final boolean kUseNewest = false;
    private static final String[] kFindStrs = new String[]{" ", "_"};
    private static final String[] kReplaceStrs = new String[]{".", "."};
    private static final int kNoHeader = 0;
    private static final String kFileBase = "/data2/bsi/app_data/GAIA/";
    protected static final String kCategoryPathFile = "/data2/bsi/app_data/GAIA/BioR/Categories.txt";
    private static final String kCategoryNameFile = "/data2/bsi/app_data/GAIA/BioR/CategoryNames.txt";

    private static void init() {
        gHeadersToDrills.clear();
        for (String[][] pairs : kHeaderDrillPairs) {
            BioR.addEntries(gHeadersToDrills, pairs[0], pairs[1], false);
        }
        gFieldProcessorMap.clear();
        TextCleaner genomesProcessor = new TextCleaner("[", "]");
        for (String field : kGenomeHeader) {
            gFieldProcessorMap.put(field, genomesProcessor);
        }
        TextCleaner altProcessor = new TextCleaner("[\"", "\",\"", ":", "\"]");
        gFieldProcessorMap.put(kBaseHeader[3], altProcessor);
        gFieldProcessorMap.put(kNCBIHeader[0], new TextWrapper("rs", null));
        gFieldProcessorMap.put(kNCBIHeader[2], new LookupProcessor(kDbSnpAlleleLookup));
        gFieldProcessorMap.put(kNCBIHeader[3], new LookupProcessor(kDbSnpSuspectLookup));
        gDefaultProcessor = new DefaultProcessor();
        gDefaultProcessor.addLocalBlank("");
        gLookupIndexes.clear();
        gLookupCatalogs.clear();
        gLookupDrill.clear();
        gOverlapPaths.clear();
        errorStrings.clear();
    }

    private static void addEntries(Map<String, String> headerMap, String[] headers, String[] drills, boolean keepOld) {
        int len = Math.min(headers.length, drills.length);
        for (int i = 0; i < len; ++i) {
            String header = headers[i];
            String newest = drills[i];
            String old = headerMap.put(header, newest);
            if (old == null) continue;
            if (keepOld) {
                headerMap.put(header, old);
                continue;
            }
            FieldProcessor proc = gFieldProcessorMap.remove(old);
            if (proc == null) continue;
            gFieldProcessorMap.put(newest, proc);
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Must have inFile, build, catalogFile and fieldsFile");
            System.exit(1);
        }
        File inFile = new File(args[0]);
        String build = args[1];
        File catFile = new File(args[2]);
        File fieldsFile = new File(args[3]);
        BioR.testFile(inFile, "inFile");
        BioR.testFile(catFile, "catalogFile");
        BioR.testFile(fieldsFile, "fieldsFile");
        String[][] data = BioR.loadFile(inFile);
        String[][] fields = BioR.loadLines(fieldsFile);
        Catalog[] catalogs = BioR.loadCatalogs(catFile);
        String[][] results = BioR.annotate(data, build, catalogs, fields);
        int numCols = results.length;
        if (numCols == 0) {
            System.err.println("No annotation results");
            System.exit(1);
        }
        int numLines = results[0].length;
        for (int i = 0; i < numLines; ++i) {
            boolean first = true;
            for (int j = 0; j < numCols; ++j) {
                if (first) {
                    first = false;
                } else {
                    System.out.print("\t");
                }
                System.out.print(results[j][i]);
            }
            System.out.println();
        }
    }

    public static String[][] annotate(String[][] data, String build, Catalog[] catalogs, String[][] fields) {
        try {
            BioR.init();
            build = CatalogUtils.getBuild(build);
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList<String[]> drillPaths = new ArrayList<String[]>();
            ArrayList<String[]> drillHeaders = new ArrayList<String[]>();
            String[][] failure = BioR.getDrillAndHeaders(build, catalogs, fields, paths, drillPaths, drillHeaders);
            if (failure != null) {
                return failure;
            }
            Metadata metadata = new Metadata("bior.annotate");
            MakeFirstLineHeaderPipe addHeader = new MakeFirstLineHeaderPipe();
            HistoryInPipe setup = new HistoryInPipe(metadata);
            String[] lookupFiles = Variant2JSONPipe.getLookupFiles(build);
            String lookupFile = lookupFiles[0];
            String lookupIndexFile = lookupFiles[1];
            LookupPipe lookup = new LookupPipe(lookupFile, lookupIndexFile);
            Variant2JSONPipe logic = new Variant2JSONPipe(lookup, null);
            Pipeline preLogic = new Pipeline(new Pipe[]{addHeader, setup});
            Pipeline<History, History> annotate = BioR.makeFindPipes(paths, (Pipe<History, History>)logic, true);
            Pipeline<History, History> postLogic = BioR.makeDrillPipes(drillPaths);
            Pipeline thePipe = new Pipeline(new Pipe[]{preLogic, annotate, postLogic});
            List<String> input = BioR.getAsList(data);
            thePipe.setStarts(input);
            List<History> actual = BioR.getResults(thePipe);
            return BioR.dumpHistory(actual, drillHeaders, kBaseHeader);
        }
        catch (Throwable oops) {
            return BioR.returnFailure("Exception", BioR.stackTraceToStrArray(oops));
        }
    }

    public static CatalogInfo getCatalogInfo(String path) {
        Properties catProperties = CatalogUtils.getCatalogProperties(path);
        if (catProperties == null) {
            return null;
        }
        try {
            Map<String, String> catNames = CatalogUtils.getStringToStringMap(kCategoryNameFile);
            String name = CatalogUtils.getUniqueName(catProperties);
            String humanName = CatalogUtils.getHumanName(catProperties, catNames, name);
            String build = CatalogUtils.getBuild(catProperties);
            String source = CatalogUtils.getSource(catProperties);
            String description = CatalogUtils.getDescription(catProperties);
            String version = CatalogUtils.getVersion(catProperties);
            String biorType = CatalogUtils.getBioRType(path);
            boolean mustOverlap = "bior_overlap".equals(biorType);
            String[][] keywords = CatalogUtils.getCatalogKeywords(path, false);
            if (keywords == null) {
                return null;
            }
            String[] machineNames = keywords[1];
            String[] humanNames = keywords[0];
            return new CatalogInfo(name, humanName, build, source, description, version, path, mustOverlap, machineNames, humanNames);
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return null;
        }
    }

    private static String[][] getDrillAndHeaders(String build, Catalog[] catalogs, String[][] fields, List<String> paths, List<String[]> drillPaths, List<String[]> drillHeaders) throws IOException {
        ArrayList<String> using = new ArrayList<String>();
        Set<String> needed = BioR.getNthRow(fields, 0, 2);
        drillHeaders.add(kBaseHeader);
        for (Catalog catalog : catalogs) {
            String catBuild;
            String name = catalog.getName();
            if (!needed.contains(name)) continue;
            String path = catalog.getPath();
            if (!new File(path).exists()) {
                throw new FileNotFoundException("Catalog could not be found: " + path);
            }
            paths.add(path);
            if (catalog.isOverlap()) {
                gOverlapPaths.add(path);
            }
            if (!build.equalsIgnoreCase(catBuild = BioR.addCatalogEntries(name, path))) {
                return BioR.returnFailure("Builds don't match", BioR.makeBuildError(build, catBuild, catalog));
            }
            using.add(name);
        }
        Map<String, String[]> headers = BioR.getHeaderMap(fields);
        Map<String, String[]> drills = BioR.getDrillMap(fields);
        for (String name : using) {
            drillPaths.add(drills.get(name));
            drillHeaders.add(headers.get(name));
        }
        drillPaths.add(kBaseDrill);
        return null;
    }

    private static String[][] returnFailure(String errorTitle, String[] errorDescription) {
        int numStrs = errorStrings.isEmpty() ? 2 : 3;
        String[][] results = new String[numStrs][];
        results[0] = new String[1];
        results[0][0] = errorTitle;
        results[1] = errorDescription;
        if (numStrs > 2) {
            results[2] = errorStrings.toArray(new String[errorStrings.size()]);
        }
        return results;
    }

    private static String[] makeBuildError(String build, String catBuild, Catalog catalog) {
        ArrayList<String> results = new ArrayList<String>();
        results.add("Catalog");
        results.add(catalog.getName());
        results.add("at location");
        results.add(catalog.getPath());
        results.add("is supposed to be build");
        results.add(build);
        results.add("but is actually build");
        results.add(catBuild);
        return results.toArray(new String[results.size()]);
    }

    private static String[] stackTraceToStrArray(Throwable oops) {
        StackTraceElement[] stack = oops.getStackTrace();
        String[] exception = new String[stack.length];
        int which = 0;
        for (StackTraceElement s : stack) {
            exception[which] = s.toString();
            ++which;
        }
        return exception;
    }

    private static String addCatalogEntries(String name, String path) {
        return BioR.addCatalogEntries(name, path, gHeadersToDrills, true);
    }

    private static String addCatalogEntries(String name, String path, Map<String, String> headerMap, boolean onlyUniqueHuman) {
        String build = CatalogUtils.getCatalogBuild(path);
        if (build == null) {
            return null;
        }
        String[][] keywords = CatalogUtils.getCatalogKeywords(path, onlyUniqueHuman);
        if (keywords == null) {
            return build;
        }
        StringBuffer nameBuilder = new StringBuffer(100);
        String[] headerNames = keywords[0];
        String[] drillNames = keywords[1];
        int nameLen = name.length() + 1;
        int numNames = Math.min(headerNames.length, drillNames.length);
        nameBuilder.append(name);
        nameBuilder.append('.');
        for (int i = 0; i < numNames; ++i) {
            nameBuilder.setLength(nameLen);
            BioR.appendWithChanges(headerNames[i], kFindStrs, kReplaceStrs, nameBuilder);
            headerNames[i] = nameBuilder.toString();
            nameBuilder.setLength(nameLen);
            nameBuilder.append(drillNames[i]);
            drillNames[i] = nameBuilder.toString();
        }
        BioR.addEntries(headerMap, headerNames, drillNames, true);
        return build;
    }

    private static void appendWithChanges(String theStr, String[] find, String[] replace, StringBuffer theBuffer) {
        ModInt findLen = new ModInt();
        ModInt whichFind = new ModInt();
        int last = 0;
        int pos = BioR.getNextMatch(theStr, last, find, findLen, whichFind);
        int len = theStr.length();
        while (pos >= 0) {
            theBuffer.append(theStr.substring(last, pos));
            theBuffer.append(replace[whichFind.value]);
            last = pos + findLen.value;
            pos = BioR.getNextMatch(theStr, last, find, findLen, whichFind);
        }
        if (last < len) {
            theBuffer.append(theStr.substring(last, len));
        }
    }

    private static int getNextMatch(String theStr, int start, String[] find, ModInt findLen, ModInt whichFind) {
        int found = -1;
        int which = 0;
        for (String findStr : find) {
            int pos = theStr.indexOf(findStr, start);
            if (pos >= 0 && (found < 0 || pos < found)) {
                found = pos;
                findLen.value = findStr.length();
                whichFind.value = which;
            }
            ++which;
        }
        return found;
    }

    private static Map<String, String[]> getHeaderMap(String[][] fields) {
        HashMap<String, String[]> results = new HashMap<String, String[]>();
        if (fields == null) {
            return results;
        }
        for (String[] catalog : fields) {
            int len;
            if (catalog == null || (len = catalog.length) < 2) continue;
            String key = catalog[0];
            String[] value = new String[--len];
            StringBuilder copier = new StringBuilder(key);
            copier.append(".");
            int baseLen = copier.length();
            for (int i = 0; i < len; ++i) {
                copier.delete(baseLen, copier.length());
                copier.append(catalog[i + 1]);
                value[i] = copier.toString();
            }
            results.put(key, value);
        }
        return results;
    }

    private static Map<String, String[]> getDrillMap(String[][] fields) {
        HashMap<String, String[]> results = new HashMap<String, String[]>();
        if (fields == null) {
            return results;
        }
        for (String[] catalog : fields) {
            int len;
            if (catalog == null || (len = catalog.length) < 2) continue;
            String key = catalog[0];
            String[] value = new String[--len];
            StringBuilder tester = new StringBuilder(key);
            tester.append(".");
            int baseLen = tester.length();
            for (int i = 0; i < len; ++i) {
                String test = catalog[i + 1];
                tester.delete(baseLen, tester.length());
                tester.append(test);
                String drill = gHeadersToDrills.get(tester.toString());
                if (drill == null) {
                    drill = test;
                }
                value[i] = BioR.isEmpty(drill) ? "." : drill;
            }
            results.put(key, value);
        }
        return results;
    }

    private static Set<String> getNthRow(String[][] fields, int which, int minLen) {
        HashSet<String> results = new HashSet<String>();
        if (fields == null) {
            return results;
        }
        minLen = Math.max(minLen, which + 1);
        for (String[] row : fields) {
            String cell;
            if (row.length < minLen || BioR.isEmpty(cell = row[which])) continue;
            results.add(cell);
        }
        return results;
    }

    private static List<String> getAsList(String[][] data) {
        int numRows = BioR.getMinNumRows(data);
        ArrayList<String> results = new ArrayList<String>(numRows);
        StringBuilder hold = new StringBuilder(200);
        for (int i = 0; i < numRows; ++i) {
            boolean first = true;
            StringBuilder theRow = new StringBuilder(200);
            for (String[] row : data) {
                String cell = row[i];
                if (BioR.isEmpty(cell)) {
                    if (first) {
                        first = false;
                    } else {
                        hold.append("\t");
                    }
                    hold.append(".");
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    int holdLen = hold.length();
                    if (holdLen > 0) {
                        theRow.append((CharSequence)hold);
                        hold.delete(0, holdLen);
                    }
                    theRow.append("\t");
                }
                theRow.append(cell);
            }
            results.add(theRow.toString());
            hold.delete(0, hold.length());
        }
        return results;
    }

    private static int getMinNumRows(String[][] data) {
        if (data.length == 0) {
            return 0;
        }
        int len = data[0].length;
        for (String[] anArray : data) {
            len = Math.min(len, anArray.length);
        }
        return len;
    }

    public static void dump(String[][] results) {
        BioR.dump(results, "\t", System.out);
    }

    public static void dump(String[][] results, String delimiter, PrintStream out) {
        if (out == null) {
            out = System.err;
        }
        if (results == null) {
            out.println("null");
            return;
        }
        int numCols = results.length;
        if (results.length == 0) {
            out.println("empty");
            return;
        }
        if (delimiter == null) {
            delimiter = "\t";
        }
        int numRows = results[0].length;
        for (int i = 0; i < numRows; ++i) {
            boolean first = true;
            for (int j = 0; j < numCols; ++j) {
                String col = results[j][i];
                if (first) {
                    first = false;
                } else {
                    out.print(delimiter);
                }
                out.print(col);
            }
            out.println();
        }
    }

    private static String[][] dumpHistory(List<History> theHistory, List<String[]> addedHeaders, String[] lastToFirst) {
        ArrayList<String[]> arrays = new ArrayList<String[]>();
        FieldProcessor[] processors = null;
        int numResults = theHistory.size();
        if (numResults == 0) {
            return new String[0][];
        }
        int numAddedCols = BioR.addHeader(theHistory.get(0), addedHeaders, arrays, numResults);
        int numLast = lastToFirst == null ? 0 : lastToFirst.length;
        int numCols = arrays.size();
        int firstCol = numCols - numAddedCols;
        int which = 1;
        String[][] results = (String[][])arrays.toArray((T[])new String[numCols][]);
        processors = BioR.getProcessors(firstCol, numCols, addedHeaders, lastToFirst);
        numCols -= numLast;
        numLast += numCols;
        for (History history : theHistory) {
            int i;
            int pos = 0;
            for (i = 0; i < firstCol; ++i) {
                results[pos][which] = processors[i].process((String)history.get(i));
                ++pos;
            }
            for (i = numCols; i < numLast; ++i) {
                results[pos][which] = processors[i].process((String)history.get(i));
                ++pos;
            }
            for (i = firstCol; i < numCols; ++i) {
                results[pos][which] = processors[i].process((String)history.get(i));
                ++pos;
            }
            ++which;
        }
        return results;
    }

    private static FieldProcessor[] getProcessors(int firstCol, int numCols, List<String[]> addedHeaders, String[] lastToFirst) {
        int i;
        FieldProcessor[] processors = new FieldProcessor[numCols];
        for (i = 0; i < firstCol; ++i) {
            processors[i] = gDefaultProcessor;
        }
        for (String[] headers : addedHeaders) {
            if (headers == lastToFirst) continue;
            for (String header : headers) {
                FieldProcessor processor = gFieldProcessorMap.get(header);
                if (processor == null) {
                    processor = gDefaultProcessor;
                }
                processors[i] = processor;
                ++i;
            }
        }
        if (lastToFirst != null) {
            for (String header : lastToFirst) {
                FieldProcessor processor = gFieldProcessorMap.get(header);
                if (processor == null) {
                    processor = gDefaultProcessor;
                }
                processors[i] = processor;
                ++i;
            }
        }
        return processors;
    }

    private static int addHeader(History history, List<String[]> addedHeaders, List<String[]> results, int numResults) {
        List headers = history.getMetaData().getOriginalHeader();
        String headerLine = null;
        int size = headers.size();
        ++numResults;
        if (size > 0) {
            headerLine = (String)headers.get(size - 1);
            for (String theHeader : SplitFile.mySplit(headerLine, "\t", -1)) {
                String[] column = new String[numResults];
                column[0] = theHeader;
                results.add(column);
            }
        }
        int numAddedCols = 0;
        for (String[] theHeaders : addedHeaders) {
            numAddedCols += theHeaders.length;
            for (String theHeader : theHeaders) {
                String[] column = new String[numResults];
                column[0] = theHeader;
                results.add(column);
            }
        }
        return numAddedCols;
    }

    private static Pipeline<History, History> makeFindPipes(List<String> paths, Pipe<History, History> start, boolean reverseList) throws IOException {
        Pipeline annotate = new Pipeline();
        if (start != null) {
            annotate.addPipe(start);
        }
        if (paths == null) {
            return annotate;
        }
        if (reverseList) {
            int numPaths = paths.size();
            ArrayList<String> hold = new ArrayList<String>(numPaths);
            for (int i = numPaths - 1; i >= 0; --i) {
                hold.add(paths.get(i));
            }
            paths = hold;
        }
        int historyPosition = -1;
        for (String path : paths) {
            if (gOverlapPaths.contains(path)) {
                annotate.addPipe((Pipe)new OverlapPipe(path, historyPosition));
            } else {
                annotate.addPipe((Pipe)new SameVariantPipe(path, false, historyPosition));
            }
            --historyPosition;
        }
        return annotate;
    }

    private static Pipeline<History, History> makeDrillPipes(List<String[]> paths) throws IOException {
        Pipeline driller = new Pipeline();
        if (paths != null) {
            int drillColumn = -1;
            for (String[] drillSet : paths) {
                if (drillSet == null) {
                    --drillColumn;
                    continue;
                }
                driller.addPipe((Pipe)new DrillPipe(false, drillSet, drillColumn));
                drillColumn -= drillSet.length;
            }
        }
        return driller;
    }

    private static void testFile(File inFile, String title) {
        if (!inFile.exists()) {
            System.err.println(title + " doesn't exist: " + inFile.getAbsolutePath());
            System.exit(1);
        }
    }

    public static String[][] loadFile(File inFile) {
        return BioR.loadFile(inFile, "\t", 0L);
    }

    public static String[][] loadFile(File inFile, long skipLines) {
        return BioR.loadFile(inFile, "\t", skipLines);
    }

    public static String[][] loadFile(File inFile, String delimiter) {
        return BioR.loadFile(inFile, delimiter, 0L);
    }

    public static String[][] loadFile(File inFile, String delimiter, long skipLines) {
        try {
            ArrayList columns = new ArrayList();
            Compressor comp = new Compressor(inFile, null);
            BufferedReader dataReader = comp.getReader();
            String line = dataReader.readLine();
            while (line != null && skipLines > 0L) {
                --skipLines;
                line = dataReader.readLine();
            }
            if (line == null) {
                return new String[0][];
            }
            String[] cols = SplitFile.mySplit(line, delimiter, -1);
            int numCols = cols.length;
            for (String column : cols) {
                ArrayList<String> theColumn = new ArrayList<String>();
                theColumn.add(column);
                columns.add(theColumn);
            }
            while ((line = dataReader.readLine()) != null) {
                cols = SplitFile.mySplit(line, delimiter, -1);
                int have = cols.length;
                for (int i = 0; i < numCols; ++i) {
                    String column = i < have ? cols[i] : null;
                    List theColumn = (List)columns.get(i);
                    theColumn.add(column);
                }
            }
            String[][] results = new String[numCols][];
            int numLines = ((List)columns.get(0)).size();
            for (int i = 0; i < numCols; ++i) {
                results[i] = ((List)columns.get(i)).toArray(new String[numLines]);
            }
            return results;
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return null;
        }
    }

    public static Catalog[] loadCatalogs(File catFile) {
        return BioR.loadCatalogs(catFile, null);
    }

    public static Catalog[] loadCatalogs(File catFile, String baseDir) {
        try {
            String line;
            ArrayList<Catalog> results = new ArrayList<Catalog>();
            Compressor comp = new Compressor(catFile, null);
            BufferedReader dataReader = comp.getReader();
            while ((line = dataReader.readLine()) != null) {
                String[] cols;
                if (line.startsWith("#") || (cols = SplitFile.mySplit(line, "\t", -1)).length < 3) continue;
                String name = cols[0];
                String path = cols[1];
                boolean overlap = Boolean.parseBoolean(cols[2]);
                if (baseDir != null) {
                    path = baseDir + path;
                }
                results.add(new Catalog(name, path, overlap));
            }
            return results.toArray(new Catalog[results.size()]);
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return null;
        }
    }

    public static String[][] loadLines(File theFile) {
        return BioR.loadLines(theFile, "\t");
    }

    public static String[][] loadLines(File theFile, String delimiter) {
        try {
            String line;
            ArrayList<String[]> results = new ArrayList<String[]>();
            Compressor comp = new Compressor(theFile, null);
            BufferedReader dataReader = comp.getReader();
            while ((line = dataReader.readLine()) != null) {
                String[] cols = SplitFile.mySplit(line, delimiter, -1);
                results.add(cols);
            }
            return (String[][])results.toArray((T[])new String[results.size()][]);
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return null;
        }
    }

    public static <T> List<History> getResults(Pipe<T, History> pipe) {
        ArrayList<History> results = new ArrayList<History>();
        if (pipe != null) {
            while (pipe.hasNext()) {
                Object obj = pipe.next();
                if (obj instanceof History) {
                    results.add((History)obj);
                    continue;
                }
                results.add(new History(obj.toString()));
            }
        }
        return results;
    }

    public static final boolean isEmpty(String test) {
        return test == null || test.isEmpty();
    }

    public static final void report(String reportStr) {
        if (BioR.isEmpty(reportStr)) {
            return;
        }
        errorStrings.add(reportStr);
    }
}

