/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.FormatUtils;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import java.util.Arrays;
import java.util.List;

public class ThousandGenomesFormatter
implements Formatter {
    private static final String[] JSON_DRILL_PATHS = new String[]{"INFO.ASN_AF", "INFO.AMR_AF", "INFO.AFR_AF", "INFO.EUR_AF"};
    private static final JsonPath PATH_ASN = JsonPath.compile((String)JSON_DRILL_PATHS[0], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_AMR = JsonPath.compile((String)JSON_DRILL_PATHS[1], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_AFR = JsonPath.compile((String)JSON_DRILL_PATHS[2], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_EUR = JsonPath.compile((String)JSON_DRILL_PATHS[3], (Predicate[])new Predicate[0]);

    @Override
    public JsonColumn getJSONColumn() {
        return JsonColumn.THOUSAND_GENOMES;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("1000Genomes.ASN_AF", "1000Genomes.AMR_AF", "1000Genomes.AFR_AF", "1000Genomes.EUR_AF");
    }

    @Override
    public List<String> format(String json) {
        return Arrays.asList(FormatUtils.drill(PATH_ASN, json), FormatUtils.drill(PATH_AMR, json), FormatUtils.drill(PATH_AFR, json), FormatUtils.drill(PATH_EUR, json));
    }

    @Override
    public List<String> getJsonDrillPaths() {
        return Arrays.asList(JSON_DRILL_PATHS);
    }
}

