/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.tinkerpop.pipes.PipeFunction;
import edu.mayo.bior.pipeline.Treat.Cleaner;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import java.util.List;

public class TreatPipe
implements PipeFunction<History, History> {
    private Cleaner theCleaner;
    private static final int kGeneName = 0;
    private static final int kNCBICols = 1;
    private static final int kdbSNPBuild = 0;
    private static final int kdbSNPID = 1;
    private static final int kdbSNPCols = 2;
    private static final int kBGIMajorAllele = 0;
    private static final int kBGIMinorAllele = 1;
    private static final int kBGIMajorFreq = 2;
    private static final int kBGIMinorFreq = 3;
    private static final int kBGICols = 4;
    private static final int kESPCeuCounts = 0;
    private static final int kESPAfrCounts = 1;
    private static final int kESPTotalCounts = 2;
    private static final int kESPMAF = 3;
    private static final int kESPRefAllele = 4;
    private static final int kESPAltAllele = 5;
    private static final int kESPCols = 6;
    private static final int kHapMapRefAllele = 0;
    private static final int kHapMapAltAllele = 1;
    private static final int kHapMapCeuRefFreq = 2;
    private static final int kHapMapCeuAltFreq = 3;
    protected static final int kHapMapCols = 4;
    private static final String kBlank = ".";
    private static boolean header = true;

    public TreatPipe(Cleaner theCleaner) {
        this.theCleaner = theCleaner;
    }

    public History compute(History history) {
        if (this.theCleaner != null) {
            return this.theCleaner.doClean(history);
        }
        int numCols = history.size();
        int firstCol = numCols - 16;
        if (header) {
            HistoryMetaData metaData = history.getMetaData();
            List columns = metaData.getColumns();
            for (int i = numCols - 1; i >= firstCol; --i) {
                columns.remove(i);
            }
            header = false;
        }
        int startCol = firstCol;
        for (int i = 0; i < startCol; ++i) {
            System.out.print((String)history.get(i));
            System.out.print('\t');
        }
        String geneName = (String)history.get(startCol + 0);
        int dbSNPBuild = TreatPipe.parseInt((String)history.get(++startCol + 0));
        String bgiMajAllele = (String)history.get((startCol += 2) + 0);
        String bgiMinAllele = (String)history.get(startCol + 1);
        double bgiMajFreq = TreatPipe.parseDouble((String)history.get(startCol + 2));
        double bgiMinFreq = TreatPipe.parseDouble((String)history.get(startCol + 3));
        String espMafs = (String)history.get((startCol += 4) + 3);
        String hapRefAllele = (String)history.get((startCol += 6) + 0);
        String hapAltAllele = (String)history.get(startCol + 1);
        double hapRefFreq = TreatPipe.parseDouble((String)history.get(startCol + 2));
        double hapAltFreq = TreatPipe.parseDouble((String)history.get(startCol + 3));
        for (int i = numCols - 1; i >= firstCol; --i) {
            history.remove(i);
        }
        TreatPipe.printString(geneName, history);
        TreatPipe.printInt(dbSNPBuild, history);
        TreatPipe.printBGI(bgiMajAllele, bgiMinAllele, bgiMajFreq, bgiMinFreq, history);
        TreatPipe.printESPMAFs(espMafs, history);
        TreatPipe.printHapMap(hapRefAllele, hapAltAllele, hapRefFreq, hapAltFreq, history);
        return history;
    }

    private static void printString(String theStr, History history) {
        if (!theStr.equals(kBlank)) {
            System.out.print(theStr);
        }
        System.out.print('\t');
    }

    private static void printInt(int theInt, History history) {
        if (theInt > 0) {
            System.out.print(theInt);
        }
        System.out.print('\t');
    }

    private static void printBGI(String bgiMajAllele, String bgiMinAllele, double bgiMajFreq, double bgiMinFreq, History history) {
        if (!bgiMajAllele.equals(kBlank) && !bgiMinAllele.equals(kBlank)) {
            System.out.print(bgiMajAllele);
            System.out.print('\t');
            System.out.print(bgiMinAllele);
            System.out.print('\t');
            if (Double.isNaN(bgiMajFreq)) {
                System.out.print(0.0);
            } else {
                System.out.print(bgiMajFreq);
            }
            System.out.print('\t');
            if (Double.isNaN(bgiMinFreq)) {
                System.out.print(0.0);
            } else {
                System.out.print(bgiMinFreq);
            }
            System.out.print('\t');
        } else {
            System.out.print("\t\t\t\t");
        }
    }

    private static void printHapMap(String hapRefAllele, String hapAltAllele, double hapRefFreq, double hapAltFreq, History history) {
        if (!hapRefAllele.equals(kBlank) && !hapAltAllele.equals(kBlank)) {
            System.out.print(hapRefAllele);
            System.out.print('\t');
            System.out.print(hapAltAllele);
            System.out.print('\t');
            if (Double.isNaN(hapRefFreq)) {
                System.out.print(0.0);
            } else {
                System.out.print(hapRefFreq);
            }
            System.out.print('\t');
            if (Double.isNaN(hapAltFreq)) {
                System.out.print(0.0);
            } else {
                System.out.print(hapAltFreq);
            }
            System.out.print('\t');
        } else {
            System.out.print("\t\t\t\t");
        }
    }

    private static void printESPMAFs(String espMafs, History history) {
        int end;
        int len = espMafs.length();
        if (espMafs.equals(kBlank) || len < 4) {
            System.out.print("\t\t");
            return;
        }
        int pos = (espMafs = espMafs.substring(2, len - 2)).indexOf(34);
        if (pos < 0) {
            System.out.print("\t\t");
            return;
        }
        System.out.print(espMafs.substring(0, pos));
        System.out.print('\t');
        pos = espMafs.indexOf(34, pos + 1) + 1;
        if (pos > 0 && (end = espMafs.indexOf(34, pos + 1)) > 0) {
            System.out.print(espMafs.substring(pos, end));
        }
        System.out.print('\t');
    }

    private static int parseInt(String theInt) {
        int result = 0;
        if (!theInt.equals(kBlank)) {
            try {
                result = Integer.parseInt(theInt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static double parseDouble(String theDouble) {
        double result = Double.NaN;
        if (!theDouble.equals(kBlank)) {
            try {
                result = Double.parseDouble(theDouble);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

