/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.MarkdownUtils;
import edu.mayo.bior.catalog.markdown.transformer.MarkdownTransformer;
import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogDiffStatistics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class CatalogTop5ColumnUpdateImpl
implements MarkdownTransformer {
    static final String TEMPLATE_KEYWORD = "COMPARISON_STATISTICS_TOP5_COL_UPDATE_TABLE";
    private CatalogDiffStatistics stats;

    CatalogTop5ColumnUpdateImpl(CatalogDiffStatistics stats) {
        this.stats = stats;
    }

    @Override
    public String transform(String markdown) throws TransformException {
        if (this.stats == null) {
            return markdown.replace(TEMPLATE_KEYWORD, "Information is not available");
        }
        return markdown.replace(TEMPLATE_KEYWORD, MarkdownUtils.chompTrailingNewlines(this.buildTable()));
    }

    private String buildTable() {
        int TOP_LIMIT = 5;
        long UPDATED_ROWS = this.stats.getSummaryStats().getCatalogEntriesChanged() - this.stats.getSummaryStats().getCatalogEntriesRemoved() - this.stats.getSummaryStats().getCatalogEntriesAdded();
        List<DiscreteColumnChange> discreteColumnChanges = this.getDiscreteColumnChanges();
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        pWtr.println("Rank | Updated Column | Update Type | # Updated Rows | % Updated Rows");
        pWtr.println("--- | --- | --- | --- | ---");
        for (int rowIdx = 0; rowIdx < 5; ++rowIdx) {
            int rank = rowIdx + 1;
            if (rowIdx < discreteColumnChanges.size()) {
                DiscreteColumnChange discreteColumnChange = discreteColumnChanges.get(rowIdx);
                pWtr.println(String.format("%d | %s | %s | %d | %.1f%%", rank, MarkdownUtils.escapeChrs(discreteColumnChange.getName()), MarkdownUtils.escapeChrs(this.getDisplayString(discreteColumnChange.getChangeType())), discreteColumnChange.getRowCount(), Float.valueOf((float)discreteColumnChange.getRowCount().longValue() / (float)UPDATED_ROWS * 100.0f)));
                continue;
            }
            pWtr.println(String.format("%d | | | ", rank));
        }
        IOUtils.closeQuietly((Writer)pWtr);
        IOUtils.closeQuietly((Writer)sWtr);
        return sWtr.toString();
    }

    private String getDisplayString(ChangeType changeType) {
        switch (changeType) {
            case ADD: {
                return "Column Added";
            }
            case REMOVE: {
                return "Column Removed";
            }
            case VALUE_CHANGE: {
                return "Column Value Updated";
            }
            case DATATYPE_CHANGE: {
                return "Column Datatype Changed";
            }
        }
        throw new RuntimeException(String.format("Unsupported change type %s", changeType.name()));
    }

    private List<DiscreteColumnChange> getDiscreteColumnChanges() {
        ArrayList<DiscreteColumnChange> list = new ArrayList<DiscreteColumnChange>();
        for (CatalogDiffStatistics.ColumnStats columnStats : this.stats.getColumnStats()) {
            long UPDATED_ROWS_W_COLS_ADDED = columnStats.getAdded() - this.stats.getSummaryStats().getCatalogEntriesAdded();
            long UPDATED_ROWS_W_COLS_REMOVED = columnStats.getRemoved() - this.stats.getSummaryStats().getCatalogEntriesRemoved();
            if (UPDATED_ROWS_W_COLS_ADDED > 0L) {
                list.add(new DiscreteColumnChange(columnStats.getName(), UPDATED_ROWS_W_COLS_ADDED, ChangeType.ADD));
            }
            if (UPDATED_ROWS_W_COLS_REMOVED > 0L) {
                list.add(new DiscreteColumnChange(columnStats.getName(), UPDATED_ROWS_W_COLS_REMOVED, ChangeType.REMOVE));
            }
            if (columnStats.getValueChanged() > 0L) {
                list.add(new DiscreteColumnChange(columnStats.getName(), columnStats.getValueChanged(), ChangeType.VALUE_CHANGE));
            }
            if (columnStats.getDatatypeChanged() <= 0L) continue;
            list.add(new DiscreteColumnChange(columnStats.getName(), columnStats.getDatatypeChanged(), ChangeType.DATATYPE_CHANGE));
        }
        Collections.sort(list, Collections.reverseOrder(new SortByRowCount()));
        return list;
    }

    class SortByRowCount
    implements Comparator<DiscreteColumnChange> {
        SortByRowCount() {
        }

        @Override
        public int compare(DiscreteColumnChange o1, DiscreteColumnChange o2) {
            return o1.getRowCount().compareTo(o2.getRowCount());
        }
    }

    private class DiscreteColumnChange {
        private String name;
        private Long rowCount;
        private ChangeType changeType;

        DiscreteColumnChange(String name, Long rowCount, ChangeType changeType) {
            this.name = name;
            this.rowCount = rowCount;
            this.changeType = changeType;
        }

        String getName() {
            return this.name;
        }

        Long getRowCount() {
            return this.rowCount;
        }

        ChangeType getChangeType() {
            return this.changeType;
        }
    }

    static enum ChangeType {
        ADD,
        REMOVE,
        VALUE_CHANGE,
        DATATYPE_CHANGE;

    }
}

