/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.list;

import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.list.CatalogInfo;
import edu.mayo.pipes.util.BiorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CatalogList {
    List<CatalogInfo> infoList = new ArrayList<CatalogInfo>();

    public CatalogList() throws CatalogFormatException {
        BiorProperties biorProperties;
        try {
            biorProperties = new BiorProperties();
        }
        catch (IOException e) {
            String msg = "Problem getting a BioR Properties object to read the catalog list file path. Msg: " + e.getMessage();
            throw new CatalogFormatException(msg);
        }
        this.init(biorProperties.get(BiorProperties.Key.catalogListFile));
    }

    public CatalogList(BiorProperties biorProperties) throws CatalogFormatException {
        this.init(biorProperties.get(BiorProperties.Key.catalogListFile));
    }

    public CatalogList(String catalogListPath) throws CatalogFormatException {
        this.init(catalogListPath);
    }

    private void init(String catalogListPath) throws CatalogFormatException {
        File catalogListFile = new File(catalogListPath);
        if (!catalogListFile.exists()) {
            String msg = String.format("'%s' from Bior Properties does not exist", catalogListPath);
            throw new CatalogFormatException(msg);
        }
        if (!catalogListFile.isFile()) {
            String msg = String.format("'%s' from Bior Properties is not a file", catalogListPath);
            throw new CatalogFormatException(msg);
        }
        if (!catalogListFile.canRead()) {
            String msg = String.format("'%s' from Bior Properties is not readable", catalogListPath);
            throw new CatalogFormatException(msg);
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(catalogListFile));
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#") || StringUtils.isBlank((String)line)) continue;
                CatalogInfo info = new CatalogInfo(line);
                this.infoList.add(info);
            }
        }
        catch (IOException e) {
            String msg = String.format("Problem reading Catalog List File from '%s'. Msg: %s", catalogListPath, e.getMessage());
            throw new CatalogFormatException(msg);
        }
    }

    public int size() {
        return this.infoList.size();
    }

    public Iterator<CatalogInfo> catalogInfoIterator() {
        return this.infoList.iterator();
    }
}

