/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog;

import edu.mayo.bior.catalog.CatalogFormatException;

public class CatalogTabixEntry {
    public static final String UNKNOWN = "UNKNOWN";
    private boolean is1FieldEntry = false;
    private boolean is4FieldEntry = false;
    private String mChr = null;
    private Long mMinPosition = null;
    private Long mMaxPosition = null;
    private String mjsonString = null;
    private String mTabixLine = null;

    public CatalogTabixEntry(String catalogLine) throws CatalogFormatException {
        if (catalogLine == null) {
            throw new CatalogFormatException("Null line given to CatalogTabixEntry constructor");
        }
        this.setLine(catalogLine);
        String[] fields = catalogLine.split("\t");
        if (fields.length == 4) {
            this.is4FieldEntry = true;
            this.setJsonString(fields[3]);
            if (!this.looksLikeJson(this.getJsonString())) {
                throw new CatalogFormatException(String.format("A simple check of the 4th field (%s) from '%s' doesn't look like JSON", this.getJsonString(), catalogLine));
            }
            this.setChromosome(fields[0]);
            this.mMinPosition = this.returnLongPosition(fields[1], 2, "min position");
            this.mMaxPosition = this.returnLongPosition(fields[2], 3, "max position");
        } else if (fields.length == 1) {
            this.is1FieldEntry = true;
            this.setJsonString(fields[0]);
            if (!this.looksLikeJson(this.getJsonString())) {
                throw new CatalogFormatException(String.format("A simple check of the 1st field (%s) from '%s' doesn't look like JSON", this.getJsonString(), catalogLine));
            }
        } else {
            throw new CatalogFormatException(String.format("'%s' must be 4 tab separated fields or 1 field. It has %d fields", catalogLine, fields.length));
        }
    }

    public boolean is1Field() {
        return this.is1FieldEntry;
    }

    public boolean is4Field() {
        return this.is4FieldEntry;
    }

    public String getChromosome() {
        return this.mChr;
    }

    private void setChromosome(String chr) {
        this.mChr = chr;
    }

    public Long getMinPosition() {
        return this.mMinPosition;
    }

    public Long getMaxPosition() {
        return this.mMaxPosition;
    }

    public String getJsonString() {
        return this.mjsonString;
    }

    private void setJsonString(String jsonString) {
        this.mjsonString = jsonString;
    }

    public String getLine() {
        return this.mTabixLine;
    }

    private void setLine(String catalogTabixLine) {
        this.mTabixLine = catalogTabixLine;
    }

    private Long returnLongPosition(String stringPosition, int fieldNumber, String fieldDescription) throws CatalogFormatException {
        try {
            return new Long(stringPosition);
        }
        catch (NumberFormatException e) {
            throw new CatalogFormatException(String.format("%s (%s) from field %d of '%s' is not an integer", fieldDescription, stringPosition, fieldNumber, this.getLine()));
        }
    }

    public boolean isPositional() {
        return this.isChromosomePositional() && this.isMinBPPositional() && this.isMaxBPPositional();
    }

    public boolean isValidNonPositional() {
        return this.isUnknownPosition() || this.isPositionalInfoNull();
    }

    public boolean isPositionalInfoNull() {
        return this.getChromosome() == null && this.getMinPosition() == null && this.getMaxPosition() == null;
    }

    public boolean isUnknownPosition() {
        if (this.getChromosome() == null || this.getMinPosition() == null || this.getMaxPosition() == null) {
            return false;
        }
        return this.getChromosome().equals(UNKNOWN) && this.getMinPosition() == 0L && this.getMaxPosition() == 1L;
    }

    public boolean isChromosomePositional() {
        if (this.getChromosome() == null) {
            return false;
        }
        return !this.getChromosome().toUpperCase().equals(UNKNOWN) && !this.getChromosome().toUpperCase().equals(".");
    }

    public boolean isMinBPPositional() {
        if (this.getMinPosition() == null) {
            return false;
        }
        return this.getMinPosition() > 0L;
    }

    public boolean isMaxBPPositional() {
        if (this.getMaxPosition() == null) {
            return false;
        }
        return this.getMaxPosition() > 0L;
    }

    private boolean looksLikeJson(String possibleJson) {
        return possibleJson.startsWith("{") && possibleJson.endsWith("}");
    }
}

