/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepExecuteException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.catalog.verification.CatalogVerifier;
import edu.mayo.bior.catalog.verification.VerifierExecutionException;
import edu.mayo.bior.catalog.verification.VerifierInputException;
import java.io.File;

public class VerifyStep
implements BuildCatalogStepInterface {
    private BuildInfo mBuildInfo;
    private StepLogger mStepLogger;
    private String mCatalogFilePath = null;

    public VerifyStep(BuildInfo buildInfo, StepLogger stepLogger) {
        this.mBuildInfo = buildInfo;
        this.mStepLogger = stepLogger;
    }

    @Override
    public void execute() throws BuildCatalogStepInputException, BuildCatalogStepExecuteException {
        this.checkInput();
        this.mStepLogger.log("Starting verify catalog step :\n");
        this.mStepLogger.log("------------------------------------\n");
        int returnStatus = -1;
        try {
            CatalogVerifier catalogVerifier = new CatalogVerifier();
            returnStatus = catalogVerifier.verify(this.mCatalogFilePath, CatalogVerifier.VAL_TYPE.STRICT, null);
        }
        catch (VerifierInputException inpute) {
            this.mStepLogger.log("Exception raised while acquiring catalog input. Exception: " + inpute.getMessage());
            throw new BuildCatalogStepExecuteException("Exception running catalog validation for catalog: " + this.mCatalogFilePath + "Exception raised: " + inpute.getMessage());
        }
        catch (VerifierExecutionException exece) {
            this.mStepLogger.log("Exception raised while verifying catalog. Exception: " + exece.getMessage());
            throw new BuildCatalogStepExecuteException("Exception running catalog validation for catalog: " + this.mCatalogFilePath + "Exception raised: " + exece.getMessage());
        }
        this.mStepLogger.log("Verify step completed. Exit Status: " + returnStatus + "\n");
        this.mStepLogger.log("------------------------------------\n");
    }

    private void checkInput() throws BuildCatalogStepInputException {
        String outputCatalogPath = null;
        outputCatalogPath = this.mBuildInfo.getTargetDirectory();
        this.mCatalogFilePath = outputCatalogPath + "/" + this.mBuildInfo.getCatalogPrefix() + ".tsv.bgz";
        File catalogFile = new File(this.mCatalogFilePath);
        if (!(catalogFile == null || catalogFile.canRead() && catalogFile.isFile())) {
            throw new BuildCatalogStepInputException("VerifyStep.checkInput(): Catalog file doesn't exist or is not readable: " + this.mCatalogFilePath);
        }
    }
}

