/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import com.jayway.jsonpath.InvalidPathException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TempDirectory {
    private static final String SEP = File.separator;
    public static final List<String> TEMP_DIR_PRIORITY_LIST = Arrays.asList("/local2/tmp", "/local1/tmp", System.getProperty("java.io.tmpdir"), "/tmp");

    public static String findBaseTempDir(String subdir) throws BuildCatalogStepInputException {
        for (String tempPath : TEMP_DIR_PRIORITY_LIST) {
            String tempSubPath = TempDirectory.createTempSubdir(tempPath, subdir);
            if (tempSubPath == null) continue;
            return tempSubPath;
        }
        throw new InvalidPathException("Couldn't find anywhere to make a temporary directory");
    }

    private static String createTempSubdir(String path, String subdir) {
        File baseTempDir = new File(path);
        if (baseTempDir.exists()) {
            String userName = System.getProperty("user.name");
            String testPath = baseTempDir + (StringUtils.isBlank((String)userName) ? "" : SEP + userName) + (StringUtils.isBlank((String)subdir) ? "" : SEP + subdir);
            File testDir = new File(testPath);
            if (testDir.exists() && testDir.canRead() && testDir.canWrite()) {
                return testPath;
            }
            if (testDir.mkdirs()) {
                return testPath;
            }
        }
        return null;
    }
}

