/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepExecuteException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.BuildInfoKey;
import edu.mayo.bior.buildcatalog.MergeColumnsTsv;
import edu.mayo.bior.buildcatalog.MergeDataSourceProperties;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.pipeline.exception.CatalogMetadataInputException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class MergeMetadataStep
implements BuildCatalogStepInterface {
    private BuildInfo mBuildInfo;
    private StepLogger mStepLogger;
    private File mCatalogDir;
    private File mPreviousCatalogFile;

    public MergeMetadataStep(BuildInfo buildInfo, StepLogger logger) throws IOException {
        this.mBuildInfo = buildInfo;
        this.mStepLogger = logger;
        this.mCatalogDir = new File(buildInfo.getTargetDirectory());
        this.mPreviousCatalogFile = null;
        if (buildInfo.getPreviousCatalogPath() != null && buildInfo.getPreviousCatalogPath().trim().length() > 0) {
            this.mPreviousCatalogFile = new File(buildInfo.getPreviousCatalogPath());
            this.checkPreviousCatalogValue(this.mPreviousCatalogFile);
        }
    }

    @Override
    public void execute() throws BuildCatalogStepExecuteException {
        try {
            this.mergeDataSourceProperties();
            this.mergeColumnsTsv();
            File currentCatalog = new File(this.mCatalogDir, this.mBuildInfo.getCatalogPrefix() + ".tsv.bgz");
            File defaultCtgBlacklist = new File(this.mCatalogDir.getCanonicalPath() + "/" + "build", this.mBuildInfo.getCatalogPrefix() + ".columns.tsv.blacklist.default");
            this.mergeBlacklist(this.getBlacklistFromCatalog(currentCatalog), this.getBlacklistFromCatalog(this.mPreviousCatalogFile), defaultCtgBlacklist, false);
            File defaultCtgBlacklistBiorWeb = new File(this.mCatalogDir.getCanonicalPath() + "/" + "build", this.mBuildInfo.getCatalogPrefix() + ".columns.tsv.blacklist.biorweb.default");
            this.mergeBlacklist(this.getBlacklistBiorwebFromCatalog(currentCatalog), this.getBlacklistBiorwebFromCatalog(this.mPreviousCatalogFile), defaultCtgBlacklistBiorWeb, true);
        }
        catch (Exception e) {
            throw new BuildCatalogStepExecuteException(e);
        }
    }

    private void mergeDataSourceProperties() throws Exception {
        MergeDataSourceProperties mergeProps = new MergeDataSourceProperties(this.mBuildInfo, this.mStepLogger);
        mergeProps.mergeDatasourceProperties();
    }

    private void mergeColumnsTsv() throws IOException, CatalogMetadataInputException {
        MergeColumnsTsv mergeCols = new MergeColumnsTsv(this.mCatalogDir, this.mBuildInfo.getCatalogPrefix(), this.getColumnsTsvFromCatalog(this.mPreviousCatalogFile), this.mStepLogger);
        mergeCols.mergeColumnsTsv();
    }

    protected File getColumnsTsvFromCatalog(File catalogFile) {
        if (catalogFile == null) {
            return null;
        }
        return new File(catalogFile.getParentFile(), catalogFile.getName().replace(".tsv.bgz", ".columns.tsv"));
    }

    protected File getBlacklistFromCatalog(File catalogFile) {
        if (catalogFile == null) {
            return null;
        }
        return new File(catalogFile.getParentFile(), catalogFile.getName().replace(".tsv.bgz", ".columns.tsv.blacklist"));
    }

    protected File getBlacklistBiorwebFromCatalog(File catalogFile) {
        if (catalogFile == null) {
            return null;
        }
        return new File(catalogFile.getParentFile(), catalogFile.getName().replace(".tsv.bgz", ".columns.tsv.blacklist.biorweb"));
    }

    private void mergeBlacklist(File currentFile, File previousCtgFile, File defaultFile, boolean isBiorWebBlacklist) throws IOException {
        String previousStr;
        String name = isBiorWebBlacklist ? "blacklist.biorweb" : "blacklist";
        String currentStr = this.isExists(currentFile) ? FileUtils.readFileToString((File)currentFile) : "";
        String defaultStr = this.isExists(defaultFile) ? FileUtils.readFileToString((File)defaultFile) : "";
        String string = previousStr = this.isExists(previousCtgFile) ? FileUtils.readFileToString((File)previousCtgFile) : "";
        if (currentStr.length() > 0) {
            if (currentStr.equals(defaultStr) && previousStr.length() > 0 && !currentStr.equals(previousStr)) {
                this.mStepLogger.logAndSummary("Copying previous catalog " + name + " file");
                FileUtils.copyFile((File)previousCtgFile, (File)currentFile);
            } else {
                this.mStepLogger.logAndSummary("Current " + name + " file has been previously modified by user.  No changes made.");
            }
        } else if (previousStr.length() > 0) {
            this.mStepLogger.logAndSummary("Copying previous catalog " + name + " file");
            FileUtils.copyFile((File)previousCtgFile, (File)currentFile);
        } else {
            this.mStepLogger.logAndSummary("Copying default catalog " + name + " file.");
            FileUtils.copyFile((File)defaultFile, (File)currentFile);
        }
    }

    private boolean isExists(File file) {
        return file != null && file.exists();
    }

    private void checkPreviousCatalogValue(File previousCatalogFile) throws IOException {
        boolean isAtLeastOnePropFileReadable;
        String prevCatalogFilePath = this.mBuildInfo.getPreviousCatalogPath();
        if (!previousCatalogFile.canRead()) {
            throw new IOException(BuildInfoKey.PREVIOUS_CATALOG_PATH.name() + " property value is not a valid readable catalog file: " + prevCatalogFilePath);
        }
        File dataSrcProps = MergeDataSourceProperties.getDataSourcePropertiesFromCatalog(previousCatalogFile);
        File colsTsv = this.getColumnsTsvFromCatalog(previousCatalogFile);
        File colsTsvBlacklist = this.getBlacklistFromCatalog(previousCatalogFile);
        File colsTsvBlacklistBiorweb = this.getBlacklistBiorwebFromCatalog(previousCatalogFile);
        boolean bl = isAtLeastOnePropFileReadable = this.isExistsAndReadable(dataSrcProps) || this.isExistsAndReadable(colsTsv) || this.isExistsAndReadable(colsTsvBlacklist) || this.isExistsAndReadable(colsTsvBlacklistBiorweb);
        if (!isAtLeastOnePropFileReadable) {
            throw new IOException("The catalog specified by " + BuildInfoKey.PREVIOUS_CATALOG_PATH.name() + " must have at least one properties file accompanying it (datasource.properties, columns.tsv, columns.tsv.blacklist, columns.tsv.blacklist.biorweb).  Ensure the files exists and are readable, or remove the " + BuildInfoKey.PREVIOUS_CATALOG_PATH.name() + " value from the build information file.");
        }
    }

    private boolean isExistsAndReadable(File f) {
        if (f == null) {
            return false;
        }
        return f.exists() && f.canRead();
    }
}

