/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepExecuteException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.catalog.Catalog;
import edu.mayo.bior.catalog.index.IndexDatabaseCreator;
import edu.mayo.bior.util.validation.CatalogFileValidator;
import edu.mayo.pipes.JSON.lookup.lookupUtils.IndexUtils;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class IndexesStep
implements BuildCatalogStepInterface {
    private BuildInfo mBuildInfo = null;
    private StepLogger mStepLogger = null;
    private List<String> mH2IndexList = null;
    private String mCatalogDirectoryPath = null;
    private String mCatalogFilePath = null;
    private String mColumnInfoFilePath = null;
    private HashMap<String, ColumnMetaData> mColumnInfoMap = null;

    public IndexesStep(BuildInfo buildInfo, StepLogger logger) {
        this.mBuildInfo = buildInfo;
        this.mStepLogger = logger;
    }

    @Override
    public void execute() throws BuildCatalogStepInputException, BuildCatalogStepExecuteException {
        this.checkInput();
        if (this.mH2IndexList == null || this.mH2IndexList.size() <= 0) {
            return;
        }
        String indexDbPathOut = null;
        for (String columnNameToIndex : this.mH2IndexList) {
            try {
                indexDbPathOut = IndexUtils.getH2DbIndexPath((String)this.mCatalogFilePath, (String)columnNameToIndex);
                IndexUtils.createParentDirectories((String)indexDbPathOut);
            }
            catch (IOException io) {
                throw new BuildCatalogStepExecuteException("Could not generate index name or create index subdirectory successfully for requested index column name: " + columnNameToIndex);
            }
            try {
                IndexDatabaseCreator indexer = new IndexDatabaseCreator();
                indexer.buildIndexH2(this.mCatalogFilePath, -1, columnNameToIndex, indexDbPathOut, false);
                this.removeTraceFile(indexDbPathOut);
            }
            catch (Exception e) {
                throw new BuildCatalogStepExecuteException("Could not generate index successfully for requested index column name: " + columnNameToIndex);
            }
        }
    }

    private void removeTraceFile(String indexDbPathOut) {
        File traceFile;
        if (indexDbPathOut.endsWith("idx.h2.db") && (traceFile = new File(indexDbPathOut.replace(".idx.h2.db", ".idx.trace.db"))).exists()) {
            traceFile.delete();
        }
    }

    public String getLog() throws Exception {
        return null;
    }

    private void init(BuildInfo buildInfo) throws BuildCatalogStepInputException {
        this.mH2IndexList = buildInfo.getIndexes();
        this.mCatalogDirectoryPath = buildInfo.getTargetDirectory();
        this.mCatalogFilePath = this.mCatalogDirectoryPath + "/" + buildInfo.getCatalogPrefix() + ".tsv.bgz";
        String catalogFilePrefix = Catalog.getCatalogPrefix(new File(this.mCatalogFilePath).getName());
        if (catalogFilePrefix == null) {
            throw new BuildCatalogStepInputException("IndexesStep.checkInput(): catalog file not valid suffix [" + this.mCatalogFilePath + "]. Please check catalog file name.");
        }
        this.mColumnInfoFilePath = this.mCatalogDirectoryPath + "/" + catalogFilePrefix + ".columns.tsv";
        File columnsTsvFile = new File(this.mColumnInfoFilePath);
        if (columnsTsvFile != null && columnsTsvFile.canRead()) {
            try {
                ColumnMetaDataOperations colMetaOps = new ColumnMetaDataOperations(columnsTsvFile);
                this.mColumnInfoMap = colMetaOps.load();
            }
            catch (IOException io) {
                throw new BuildCatalogStepInputException("IndexesStep.checkInput(): Exception while reading in catalog columns.tsv file [" + this.mColumnInfoFilePath + "]. Please check columns.tsv file.");
            }
        } else {
            throw new BuildCatalogStepInputException("IndexesStep.checkInput(): Catalog columns.tsv file is not a valid file [" + this.mColumnInfoFilePath + "]. Please check bior_build_catalog, create-property-files step results.");
        }
    }

    private void checkInput() throws BuildCatalogStepInputException {
        this.init(this.mBuildInfo);
        if (this.mH2IndexList == null || this.mH2IndexList.size() <= 0) {
            return;
        }
        File catalogFile = new File(this.mCatalogFilePath);
        if (!CatalogFileValidator.catalogExists(catalogFile)) {
            throw new BuildCatalogStepInputException("IndexesStep.checkInput(): Catalog file is not a valid file. Please check bior_build_catalog, create-catalog step results.");
        }
        if (this.mColumnInfoMap == null || this.mColumnInfoMap.size() <= 0) {
            throw new BuildCatalogStepInputException("IndexesStep.checkInput(): Catalog columns.tsv file [" + this.mColumnInfoFilePath + "] was not read into HashMap correctly. Please check columns.tsv for expected five-column format.");
        }
        for (String columnNameToIndex : this.mH2IndexList) {
            ColumnMetaData colInfo = this.mColumnInfoMap.get(columnNameToIndex);
            if (colInfo != null) continue;
            throw new BuildCatalogStepInputException("IndexesStep.checkInput(): Catalog column to be indexed [" + columnNameToIndex + "] is not found in the catalog's columns.tsv file [" + this.mColumnInfoFilePath + "]. Please check columns.tsv for expected five-column format.");
        }
    }
}

