/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.BuildStepKey;
import edu.mayo.bior.buildcatalog.CreatePropFilesStep;
import edu.mayo.bior.buildcatalog.CreateStep;
import edu.mayo.bior.buildcatalog.IndexesStep;
import edu.mayo.bior.buildcatalog.MakeJsonStep;
import edu.mayo.bior.buildcatalog.MergeMetadataStep;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.buildcatalog.VerifyStep;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class BuildCatalog {
    public static final String BUILD_SUBDIR = "build";
    public static final String STEP_SEPARATOR_LINE = "-------------------------------------";

    public void build(String canonicalPath, BuildStepKey startStep) throws Exception {
        BuildStepKey lastStep = BuildStepKey.values()[BuildStepKey.values().length - 1];
        this.build(canonicalPath, startStep, lastStep);
    }

    public void build(String buildInfoPath, BuildStepKey startStep, BuildStepKey endStep) throws Exception {
        BuildInfo buildInfo = new BuildInfo(buildInfoPath);
        this.printBuildInfoVariables(buildInfo);
        File targetDir = new File(buildInfo.getTargetDirectory());
        if (startStep.equals((Object)BuildStepKey.AUTO)) {
            startStep = this.determineAutoResumeStep(targetDir);
        }
        this.deleteAllSuccessFilesOnAndAfterStep(startStep, targetDir);
        List<BuildStepKey> stepsToExecute = this.getStepsToExecute(startStep, endStep);
        for (BuildStepKey stepKey : stepsToExecute) {
            String stepDisplayName = stepKey.getDisplayName();
            StepLogger logger = new StepLogger(stepDisplayName, targetDir);
            BuildCatalogStepInterface buildStep = this.createStepForKey(stepKey, buildInfo, logger);
            try {
                logger.logAndSummary(String.format("Step %s STARTED", stepDisplayName));
                buildStep.execute();
                this.markStepSuccessful(stepDisplayName, targetDir);
                logger.logAndSummary(String.format("Step %s SUCCEEDED", stepDisplayName));
                logger.summary(STEP_SEPARATOR_LINE);
            }
            catch (Exception e) {
                logger.log(ExceptionUtils.getStackTrace((Throwable)e));
                System.err.println("Unexpected error executing step " + stepDisplayName + ".\n" + e.getMessage());
                throw e;
            }
            finally {
                logger.closeLogWriters();
            }
        }
    }

    private List<BuildStepKey> getStepsToExecute(BuildStepKey startStep, BuildStepKey endStep) {
        boolean isAdd = false;
        ArrayList<BuildStepKey> steps = new ArrayList<BuildStepKey>();
        for (BuildStepKey step : BuildStepKey.values()) {
            if (step.equals((Object)startStep)) {
                isAdd = true;
            }
            if (isAdd) {
                steps.add(step);
            }
            if (step.equals((Object)endStep)) break;
        }
        return steps;
    }

    private void printBuildInfoVariables(BuildInfo buildInfo) {
        Map<String, String> keyValPairs = buildInfo.getMap();
        keyValPairs.put("BIOR_LITE_HOME", System.getenv("BIOR_LITE_HOME"));
        keyValPairs.put("JAVA_HOME", System.getenv("JAVA_HOME"));
        keyValPairs.put("PATH", System.getenv("PATH"));
        try {
            keyValPairs.put("HOSTNAME", InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            System.err.println("Could not determine the hostname");
        }
        int longestKeyLen = this.getLongestKeyLength(new ArrayList<String>(keyValPairs.keySet()));
        System.out.println();
        System.out.println("-------------------------------------------------------------------------------------");
        System.out.println("Variables from build_info.txt (as well as BIOR_LITE_HOME, JAVA_HOME, and PATH)");
        System.out.println("-------------------------------------------------------------------------------------");
        for (String key : keyValPairs.keySet()) {
            System.out.println(StringUtils.rightPad((String)key, (int)(longestKeyLen + 2)) + keyValPairs.get(key));
        }
        System.out.println("-------------------------------------------------------------------------------------");
        System.out.println();
    }

    private int getLongestKeyLength(ArrayList<String> keys) {
        int longestLen = 0;
        for (String key : keys) {
            if (key.length() <= longestLen) continue;
            longestLen = key.length();
        }
        return longestLen;
    }

    private void deleteAllSuccessFilesOnAndAfterStep(BuildStepKey stepToStartFrom, File targetDir) {
        for (BuildStepKey stepKey : BuildStepKey.values()) {
            if (!stepKey.isExecuteStep(stepToStartFrom)) continue;
            this.getStepSuccessfulFile(stepKey.getDisplayName(), targetDir).delete();
        }
    }

    private void markStepSuccessful(String stepDisplayName, File targetDir) throws IOException {
        File successFile = this.getStepSuccessfulFile(stepDisplayName, targetDir);
        successFile.createNewFile();
    }

    private File getStepSuccessfulFile(String stepDisplayName, File targetDir) {
        File dir = new File(targetDir, "build/progress");
        return new File(dir, stepDisplayName + ".successful");
    }

    private BuildCatalogStepInterface createStepForKey(BuildStepKey step, BuildInfo buildInfo, StepLogger logger) throws BuildCatalogStepInputException, IOException {
        if (step.equals((Object)BuildStepKey.MAKE_JSON)) {
            return new MakeJsonStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.MAKE_CATALOG)) {
            return new CreateStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.MAKE_PROP_FILES)) {
            return new CreatePropFilesStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.MERGE_PROP_FILES)) {
            return new MergeMetadataStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.MAKE_INDEXES)) {
            return new IndexesStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.VERIFY)) {
            return new VerifyStep(buildInfo, logger);
        }
        throw new BuildCatalogStepInputException("Step not valid: " + step.toString());
    }

    private BuildStepKey determineAutoResumeStep(File targetDir) throws IOException {
        BuildStepKey[] steps = BuildStepKey.values();
        for (int i = 1; i < steps.length; ++i) {
            File successFile = this.getStepSuccessfulFile(steps[i].getDisplayName(), targetDir);
            if (successFile.exists()) continue;
            return steps[i];
        }
        return BuildStepKey.MAKE_JSON;
    }
}

