/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import java.util.ArrayList;

public class BiCubicInterpolation {
    private int nPoints = 0;
    private int mPoints = 0;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[][] y = null;
    private double[][] dydx1 = null;
    private double[][] dydx2 = null;
    private double[][] d2ydx1dx2 = null;
    private boolean derivCalculated = false;
    private BiCubicSpline bcs = null;
    private double incrX1 = 0.0;
    private double incrX2 = 0.0;
    private double xx1 = Double.NaN;
    private double xx2 = Double.NaN;
    private ArrayList<Object> coeff = new ArrayList();
    private double[][] weights = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, -1.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {9.0, -9.0, 9.0, -9.0, 6.0, 3.0, -3.0, -6.0, 6.0, -6.0, -3.0, 3.0, 4.0, 2.0, 1.0, 2.0}, {-6.0, 6.0, -6.0, 6.0, -4.0, -2.0, 2.0, 4.0, -3.0, 3.0, 3.0, -3.0, -2.0, -1.0, -1.0, -2.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-6.0, 6.0, -6.0, 6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, 2.0, -2.0, -2.0, -2.0, -1.0, -1.0}, {4.0, -4.0, 4.0, -4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, -2.0, 2.0, 1.0, 1.0, 1.0, 1.0}};
    private int[] x1indices = null;
    private int[] x2indices = null;
    private double[] xMin = new double[2];
    private double[] xMax = new double[2];
    private double interpolatedValue = Double.NaN;
    private double interpolatedDydx1 = Double.NaN;
    private double interpolatedDydx2 = Double.NaN;
    private double interpolatedD2ydx1dx2 = Double.NaN;
    private boolean numerDiffFlag = true;
    private static double delta = 0.001;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = false;

    public BiCubicInterpolation(double[] x1, double[] x2, double[][] y, int numerDiffOption) {
        if (numerDiffOption == 0) {
            this.numerDiffFlag = false;
        } else if (numerDiffOption == 1) {
            this.numerDiffFlag = true;
        } else {
            throw new IllegalArgumentException("The numerical differencing option, " + numerDiffOption + ", must be 0 or 1");
        }
        this.initialize(Conv.copy(x1), Conv.copy(x2), Conv.copy(y));
        this.calcDeriv();
        this.gridCoefficients();
    }

    public BiCubicInterpolation(double[] x1, double[] x2, double[][] y) {
        this.numerDiffFlag = true;
        this.initialize(Conv.copy(x1), Conv.copy(x2), Conv.copy(y));
        this.calcDeriv();
        this.gridCoefficients();
    }

    public BiCubicInterpolation(double[] x1, double[] x2, double[][] y, double[][] dydx1, double[][] dydx2, double[][] d2ydx1dx2) {
        this.initialize(Conv.copy(x1), Conv.copy(x2), Conv.copy(y), Conv.copy(dydx1), Conv.copy(dydx2), Conv.copy(d2ydx1dx2));
        this.gridCoefficients();
    }

    private void initialize(double[] x1, double[] x2, double[][] y) {
        this.initialize(x1, x2, y, null, null, null, false);
    }

    private void initialize(double[] x1, double[] x2, double[][] y, double[][] dydx1, double[][] dydx2, double[][] d2ydx1dx2) {
        this.initialize(x1, x2, y, dydx1, dydx2, d2ydx1dx2, true);
    }

    private void initialize(double[] x1, double[] x2, double[][] y, double[][] dydx1, double[][] dydx2, double[][] d2ydx1dx2, boolean flag) {
        int k;
        int j;
        int i;
        int j2;
        int i2;
        int nPoints = x1.length;
        int mPoints = x2.length;
        if (nPoints != y.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + nPoints + " " + y.length);
        }
        if (mPoints != y[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + mPoints + " " + y[0].length);
        }
        if (nPoints < 2 || mPoints < 2) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 2 X 2");
        }
        ArrayMaths am = new ArrayMaths(x1);
        am = am.sort();
        this.x1indices = am.originalIndices();
        x1 = am.array();
        double[][] hold = new double[nPoints][mPoints];
        double[][] hold1 = null;
        double[][] hold2 = null;
        double[][] hold12 = null;
        for (i2 = 0; i2 < nPoints; ++i2) {
            for (j2 = 0; j2 < mPoints; ++j2) {
                hold[i2][j2] = y[this.x1indices[i2]][j2];
            }
        }
        for (i2 = 0; i2 < nPoints; ++i2) {
            for (j2 = 0; j2 < mPoints; ++j2) {
                y[i2][j2] = hold[i2][j2];
            }
        }
        if (flag) {
            hold1 = new double[nPoints][mPoints];
            hold2 = new double[nPoints][mPoints];
            hold12 = new double[nPoints][mPoints];
            for (i2 = 0; i2 < nPoints; ++i2) {
                for (j2 = 0; j2 < mPoints; ++j2) {
                    hold1[i2][j2] = dydx1[this.x1indices[i2]][j2];
                    hold2[i2][j2] = dydx2[this.x1indices[i2]][j2];
                    hold12[i2][j2] = d2ydx1dx2[this.x1indices[i2]][j2];
                }
            }
            for (i2 = 0; i2 < nPoints; ++i2) {
                for (j2 = 0; j2 < mPoints; ++j2) {
                    dydx1[i2][j2] = hold1[i2][j2];
                    dydx2[i2][j2] = hold2[i2][j2];
                    d2ydx1dx2[i2][j2] = hold12[i2][j2];
                }
            }
        }
        am = new ArrayMaths(x2);
        am = am.sort();
        this.x2indices = am.originalIndices();
        double[] xh = am.array();
        for (i = 0; i < mPoints; ++i) {
            x2[i] = xh[mPoints - 1 - i];
        }
        for (i = 0; i < mPoints; ++i) {
            for (j = 0; j < nPoints; ++j) {
                hold[j][i] = y[j][this.x2indices[i]];
            }
        }
        for (i = 0; i < nPoints; ++i) {
            for (j = 0; j < mPoints; ++j) {
                y[i][j] = hold[i][mPoints - 1 - j];
            }
        }
        if (flag) {
            for (i = 0; i < mPoints; ++i) {
                for (j = 0; j < nPoints; ++j) {
                    hold1[j][i] = dydx1[j][this.x2indices[i]];
                    hold2[j][i] = dydx2[j][this.x2indices[i]];
                    hold12[j][i] = d2ydx1dx2[j][this.x2indices[i]];
                }
            }
            for (i = 0; i < nPoints; ++i) {
                for (j = 0; j < mPoints; ++j) {
                    dydx1[i][j] = hold1[i][mPoints - 1 - j];
                    dydx2[i][j] = hold2[i][mPoints - 1 - j];
                    d2ydx1dx2[i][j] = hold12[i][mPoints - 1 - j];
                }
            }
        }
        for (i = 1; i < nPoints; ++i) {
            if (x1[i] != x1[i - 1]) continue;
            System.out.println("x1[" + this.x1indices[i] + "] and x1[" + this.x1indices[i + 1] + "] are identical, " + x1[i]);
            System.out.println("The y values have been averaged and one point has been deleted");
            for (j = i; j < nPoints - 1; ++j) {
                x1[j] = x1[j + 1];
                this.x1indices[j] = this.x1indices[j + 1];
            }
            for (j = 0; j < mPoints; ++j) {
                y[i - 1][j] = (y[i - 1][j] + y[i][j]) / 2.0;
                for (k = i; k < nPoints - 1; ++k) {
                    y[k][j] = y[k + 1][j];
                }
                if (!flag) continue;
                dydx1[i - 1][j] = (dydx1[i - 1][j] + dydx1[i][j]) / 2.0;
                dydx2[i - 1][j] = (dydx2[i - 1][j] + dydx2[i][j]) / 2.0;
                d2ydx1dx2[i - 1][j] = (d2ydx1dx2[i - 1][j] + d2ydx1dx2[i][j]) / 2.0;
                for (k = i; k < nPoints - 1; ++k) {
                    dydx1[k][j] = dydx1[k + 1][j];
                    dydx2[k][j] = dydx2[k + 1][j];
                    d2ydx1dx2[k][j] = d2ydx1dx2[k + 1][j];
                }
            }
            --nPoints;
        }
        for (i = 1; i < mPoints; ++i) {
            if (x2[i] != x2[i - 1]) continue;
            System.out.println("x2[" + this.x2indices[i] + "] and x2[" + this.x2indices[i] + "] are identical, " + x2[i]);
            System.out.println("The y values have been averaged and one point has been deleted");
            for (j = i; j < mPoints - 1; ++j) {
                x2[j] = x2[j + 1];
                this.x2indices[j] = this.x2indices[j + 1];
            }
            for (j = 0; j < nPoints; ++j) {
                y[j][i - 1] = (y[j][i - 1] + y[j][i]) / 2.0;
                for (k = i; k < mPoints - 1; ++k) {
                    y[j][k] = y[j][k + 1];
                }
                if (!flag) continue;
                dydx1[j][i - 1] = (dydx1[j][i - 1] + dydx1[j][i]) / 2.0;
                dydx2[j][i - 1] = (dydx2[j][i - 1] + dydx2[j][i]) / 2.0;
                d2ydx1dx2[j][i - 1] = (d2ydx1dx2[j][i - 1] + d2ydx1dx2[j][i]) / 2.0;
                for (k = i; k < nPoints - 1; ++k) {
                    dydx1[j][k] = dydx1[j][k + 1];
                    dydx2[j][k] = dydx2[j][k + 1];
                    d2ydx1dx2[j][k] = d2ydx1dx2[j][k + 1];
                }
            }
            --mPoints;
        }
        this.nPoints = nPoints;
        this.mPoints = mPoints;
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        this.dydx1 = new double[this.nPoints][this.mPoints];
        this.dydx2 = new double[this.nPoints][this.mPoints];
        this.d2ydx1dx2 = new double[this.nPoints][this.mPoints];
        for (i = 0; i < this.nPoints; ++i) {
            this.x1[i] = x1[i];
        }
        for (j2 = 0; j2 < this.mPoints; ++j2) {
            this.x2[j2] = x2[j2];
        }
        for (i = 0; i < this.nPoints; ++i) {
            for (j = 0; j < this.mPoints; ++j) {
                this.y[i][j] = y[i][j];
            }
            if (!flag) continue;
            for (j = 0; j < this.mPoints; ++j) {
                this.dydx1[i][j] = dydx1[i][j];
                this.dydx2[i][j] = dydx2[i][j];
                this.d2ydx1dx2[i][j] = d2ydx1dx2[i][j];
            }
        }
        if (flag) {
            this.derivCalculated = true;
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        if (!flag && this.numerDiffFlag) {
            double minSep;
            double range1 = this.xMax[0] - this.xMin[0];
            double range2 = this.xMax[1] - this.xMin[1];
            double averageSeparation1 = range1 / (double)this.nPoints;
            double averageSeparation2 = range2 / (double)this.mPoints;
            double minimumSeparation1 = minSep = this.x1[1] - this.x1[0];
            for (int i3 = 2; i3 < this.nPoints; ++i3) {
                minSep = this.x1[i3] - this.x1[i3 - 1];
                if (!(minSep < minimumSeparation1)) continue;
                minimumSeparation1 = minSep;
            }
            double minimumSeparation2 = minSep = this.x2[1] - this.x2[0];
            for (int i4 = 2; i4 < this.mPoints; ++i4) {
                minSep = this.x2[i4] - this.x2[i4 - 1];
                if (!(minSep < minimumSeparation2)) continue;
                minimumSeparation2 = minSep;
            }
            this.incrX1 = range1 * delta;
            double defaultIncr = minimumSeparation1;
            if (minimumSeparation1 < averageSeparation1 / 10.0) {
                defaultIncr = averageSeparation1 / 10.0;
            }
            if (this.incrX1 > averageSeparation1) {
                this.incrX1 = defaultIncr;
            }
            this.incrX2 = range2 * delta;
            defaultIncr = minimumSeparation2;
            if (minimumSeparation2 < averageSeparation2 / 10.0) {
                defaultIncr = averageSeparation2 / 10.0;
            }
            if (this.incrX2 > averageSeparation2) {
                this.incrX2 = defaultIncr;
            }
        }
    }

    private void calcDeriv() {
        if (this.numerDiffFlag) {
            int i;
            this.bcs = new BiCubicSpline(this.x1, this.x2, this.y);
            double yjp1k = 0.0;
            double yjm1k = 0.0;
            double[] x1jp1 = new double[this.nPoints];
            double[] x1jm1 = new double[this.nPoints];
            double[] x2jp1 = new double[this.mPoints];
            double[] x2jm1 = new double[this.mPoints];
            for (i = 0; i < this.nPoints; ++i) {
                x1jp1[i] = this.x1[i] + this.incrX1;
                if (x1jp1[i] > this.x1[this.nPoints - 1]) {
                    x1jp1[i] = this.x1[this.nPoints - 1];
                }
                x1jm1[i] = this.x1[i] - this.incrX1;
                if (!(x1jm1[i] < this.x1[0])) continue;
                x1jm1[i] = this.x1[0];
            }
            for (i = 0; i < this.mPoints; ++i) {
                x2jp1[i] = this.x2[i] + this.incrX2;
                if (x2jp1[i] > this.x2[0]) {
                    x2jp1[i] = this.x2[0];
                }
                x2jm1[i] = this.x2[i] - this.incrX2;
                if (!(x2jm1[i] < this.x2[this.mPoints - 1])) continue;
                x2jm1[i] = this.x2[this.mPoints - 1];
            }
            for (i = 0; i < this.nPoints; ++i) {
                for (int j = 0; j < this.mPoints; ++j) {
                    this.dydx1[i][j] = (this.bcs.interpolate(x1jp1[i], this.x2[j]) - this.bcs.interpolate(x1jm1[i], this.x2[j])) / (x1jp1[i] - x1jm1[i]);
                    this.dydx2[i][j] = (this.bcs.interpolate(this.x1[i], x2jp1[j]) - this.bcs.interpolate(this.x1[i], x2jm1[j])) / (x2jp1[j] - x2jm1[j]);
                    this.d2ydx1dx2[i][j] = (this.bcs.interpolate(x1jp1[i], x2jp1[j]) - this.bcs.interpolate(x1jp1[i], x2jm1[j]) - this.bcs.interpolate(x1jm1[i], x2jp1[j]) + this.bcs.interpolate(x1jm1[i], x2jm1[j])) / ((x1jp1[i] - x1jm1[i]) * (x2jp1[j] - x2jm1[j]));
                }
            }
        } else {
            int iip = 0;
            int iim = 0;
            int jjp = 0;
            int jjm = 0;
            for (int i = 0; i < this.nPoints; ++i) {
                iip = i + 1;
                if (iip >= this.nPoints) {
                    iip = this.nPoints - 1;
                }
                if ((iim = i - 1) < 0) {
                    iim = 0;
                }
                for (int j = 0; j < this.mPoints; ++j) {
                    jjp = j + 1;
                    if (jjp >= this.mPoints) {
                        jjp = this.mPoints - 1;
                    }
                    if ((jjm = j - 1) < 0) {
                        jjm = 0;
                    }
                    this.dydx1[i][j] = (this.y[iip][j] - this.y[iim][j]) / (this.x1[iip] - this.x1[iim]);
                    this.dydx2[i][j] = (this.y[i][jjp] - this.y[i][jjm]) / (this.x2[jjp] - this.x2[jjm]);
                    this.d2ydx1dx2[i][j] = (this.y[iip][jjp] - this.y[iip][jjm] - this.y[iim][jjp] + this.y[iim][jjm]) / ((this.x1[iip] - this.x1[iim]) * (this.x2[jjp] - this.x2[jjm]));
                }
            }
        }
        this.derivCalculated = true;
    }

    private void gridCoefficients() {
        double[] yt = new double[4];
        double[] dydx1t = new double[4];
        double[] dydx2t = new double[4];
        double[] d2ydx1dx2t = new double[4];
        double[] ct = new double[16];
        double[] xt = new double[16];
        double d1 = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.nPoints - 1; ++i) {
            d1 = this.x1[i + 1] - this.x1[i];
            for (int j = 0; j < this.mPoints - 1; ++j) {
                double[][] cc = new double[4][4];
                d2 = this.x2[j] - this.x2[j + 1];
                this.coeff.add(new Double(d1));
                this.coeff.add(new Double(this.x1[i]));
                this.coeff.add(new Double(d2));
                this.coeff.add(new Double(this.x2[j + 1]));
                yt[0] = this.y[i][j + 1];
                dydx1t[0] = this.dydx1[i][j + 1];
                dydx2t[0] = this.dydx2[i][j + 1];
                d2ydx1dx2t[0] = this.d2ydx1dx2[i][j + 1];
                yt[1] = this.y[i + 1][j + 1];
                dydx1t[1] = this.dydx1[i + 1][j + 1];
                dydx2t[1] = this.dydx2[i + 1][j + 1];
                d2ydx1dx2t[1] = this.d2ydx1dx2[i + 1][j + 1];
                yt[2] = this.y[i + 1][j];
                dydx1t[2] = this.dydx1[i + 1][j];
                dydx2t[2] = this.dydx2[i + 1][j];
                d2ydx1dx2t[2] = this.d2ydx1dx2[i + 1][j];
                yt[3] = this.y[i][j];
                dydx1t[3] = this.dydx1[i][j];
                dydx2t[3] = this.dydx2[i][j];
                d2ydx1dx2t[3] = this.d2ydx1dx2[i][j];
                for (int k = 0; k < 4; ++k) {
                    xt[k] = yt[k];
                    xt[k + 4] = dydx1t[k] * d1;
                    xt[k + 8] = dydx2t[k] * d2;
                    xt[k + 12] = d2ydx1dx2t[k] * d1 * d2;
                }
                double xh = 0.0;
                for (int k = 0; k < 16; ++k) {
                    for (int kk = 0; kk < 16; ++kk) {
                        xh += this.weights[k][kk] * xt[kk];
                    }
                    ct[k] = xh;
                    xh = 0.0;
                }
                int counter = 0;
                for (int k = 0; k < 4; ++k) {
                    for (int kk = 0; kk < 4; ++kk) {
                        cc[k][kk] = ct[counter++];
                    }
                }
                this.coeff.add(cc);
            }
        }
    }

    public double interpolate(double xx1, double xx2) {
        int j;
        int i;
        if (xx1 < this.x1[0]) {
            if (xx1 >= this.x1[0] - potentialRoundingError) {
                xx1 = this.x1[0];
            } else {
                throw new IllegalArgumentException(xx1 + " is outside the limits, " + this.x1[0] + " - " + this.x1[this.nPoints - 1]);
            }
        }
        if (xx2 < this.x2[this.mPoints - 1]) {
            if (xx2 > this.x2[this.mPoints - 1] - potentialRoundingError) {
                xx2 = this.x2[this.mPoints - 1];
            } else {
                throw new IllegalArgumentException(xx2 + " is outside the limits, " + this.x2[this.mPoints - 1] + " - " + this.x2[0]);
            }
        }
        if (xx1 > this.x1[this.nPoints - 1]) {
            if (xx1 <= this.x1[this.nPoints - 1] + potentialRoundingError) {
                xx1 = this.x1[this.nPoints - 1];
            } else {
                throw new IllegalArgumentException(xx1 + " is outside the limits, " + this.x1[0] + " - " + this.x1[this.nPoints - 1]);
            }
        }
        if (xx2 > this.x2[0]) {
            if (xx2 <= this.x2[0] + potentialRoundingError) {
                xx2 = this.x2[0];
            } else {
                throw new IllegalArgumentException(xx2 + " is outside the limits, " + this.x2[this.nPoints - 1] + " - " + this.x2[0]);
            }
        }
        this.xx1 = xx1;
        this.xx2 = xx2;
        int grid1 = 0;
        int grid2 = 0;
        int counter = 1;
        boolean test = true;
        while (test) {
            if (xx1 < this.x1[counter]) {
                grid1 = counter - 1;
                test = false;
                continue;
            }
            if (++counter < this.nPoints) continue;
            grid1 = this.nPoints - 2;
            test = false;
        }
        counter = 0;
        test = true;
        while (test) {
            if (xx2 >= this.x2[counter + 1] && xx2 <= this.x2[counter]) {
                grid2 = counter;
                test = false;
                continue;
            }
            ++counter;
        }
        int gridn = grid1 * (this.mPoints - 1) + grid2;
        double distance1 = (Double)this.coeff.get(5 * gridn);
        double x1lower = (Double)this.coeff.get(5 * gridn + 1);
        double distance2 = (Double)this.coeff.get(5 * gridn + 2);
        double x2lower = (Double)this.coeff.get(5 * gridn + 3);
        double[][] gCoeff = (double[][])this.coeff.get(5 * gridn + 4);
        double x1Normalised = (xx1 - x1lower) / distance1;
        double x2Normalised = (xx2 - x2lower) / distance2;
        this.interpolatedValue = 0.0;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                this.interpolatedValue += gCoeff[i][j] * Math.pow(x1Normalised, i) * Math.pow(x2Normalised, j);
            }
        }
        this.interpolatedDydx1 = 0.0;
        for (i = 1; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                this.interpolatedDydx1 += (double)i * gCoeff[i][j] * Math.pow(x1Normalised, i - 1) * Math.pow(x2Normalised, j);
            }
        }
        this.interpolatedDydx2 = 0.0;
        for (i = 0; i < 4; ++i) {
            for (j = 1; j < 4; ++j) {
                this.interpolatedDydx2 += (double)j * gCoeff[i][j] * Math.pow(x1Normalised, i) * Math.pow(x2Normalised, j - 1);
            }
        }
        this.interpolatedD2ydx1dx2 = 0.0;
        for (i = 1; i < 4; ++i) {
            for (j = 1; j < 4; ++j) {
                this.interpolatedD2ydx1dx2 += (double)(i * j) * gCoeff[i][j] * Math.pow(x1Normalised, i - 1) * Math.pow(x2Normalised, j - 1);
            }
        }
        return this.interpolatedValue;
    }

    public double[] getInterpolatedValues() {
        double[] ret = new double[]{this.interpolatedValue, this.interpolatedDydx1, this.interpolatedDydx2, this.interpolatedD2ydx1dx2, this.xx1, this.xx2};
        return ret;
    }

    public double[][] getGridDydx1() {
        double[][] ret = new double[this.nPoints][this.mPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                ret[this.x1indices[i]][this.x2indices[j]] = this.dydx1[i][j];
            }
        }
        return ret;
    }

    public double[][] getGridDydx2() {
        double[][] ret = new double[this.nPoints][this.mPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                ret[this.x1indices[i]][this.x2indices[j]] = this.dydx2[i][j];
            }
        }
        return ret;
    }

    public double[][] getGridD2ydx1dx2() {
        double[][] ret = new double[this.nPoints][this.mPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                ret[this.x1indices[i]][this.x2indices[j]] = this.d2ydx1dx2[i][j];
            }
        }
        return ret;
    }

    public static void resetDelta(double delta) {
        BiCubicInterpolation.delta = delta;
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        potentialRoundingError = 0.0;
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        BiCubicInterpolation.potentialRoundingError = potentialRoundingError;
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1]};
        return limits;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int i = 0; i < 2; ++i) {
            System.out.println("The limits to the x array " + i + " are " + this.xMin[i] + " and " + this.xMax[i]);
        }
        System.out.println(" ");
    }
}

