/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import java.util.ArrayList;
import java.util.List;

public class ColumnMetaData
implements Comparable<ColumnMetaData> {
    private String columnName = "";
    private Type type = Type.String;
    private String typeStrOriginal;
    private String count = "";
    private String description = "";
    private String humanReadableName = "";
    private String originalRowInFile = "";
    private List<String> headerRows = new ArrayList<String>();

    public ColumnMetaData(String colName) {
        this.columnName = colName;
    }

    public ColumnMetaData() {
    }

    public ColumnMetaData(String colName, String typeStr, String count, String desc) {
        this(colName, ColumnMetaData.stringToType(typeStr), count, desc, colName);
        this.typeStrOriginal = typeStr;
    }

    public ColumnMetaData(String colName, String typeStr, String count, String desc, String humanReadableName) {
        this(colName, ColumnMetaData.stringToType(typeStr), count, desc, humanReadableName);
        this.typeStrOriginal = typeStr;
    }

    public ColumnMetaData(String colName, Type type, String count, String desc) {
        this(colName, type, count, desc, colName);
    }

    public ColumnMetaData(String colName, Type dataType, String count, String desc, String humanReadableName) {
        this.columnName = colName;
        this.type = dataType;
        this.typeStrOriginal = this.type == null ? null : this.type.name();
        this.count = count;
        this.description = desc;
        this.humanReadableName = humanReadableName;
    }

    protected static Type stringToType(String typeStr) {
        try {
            Type type = Type.valueOf(typeStr);
            return type;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String toString() {
        String typeStr = this.typeStrOriginal;
        if (this.type != null) {
            typeStr = this.type.toString();
        }
        String descStr = this.description == null || this.description.trim().length() == 0 ? "." : this.description;
        return this.columnName + "\t" + typeStr + "\t" + this.count + "\t" + descStr + "\t" + this.humanReadableName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeStrOriginal() {
        return this.typeStrOriginal;
    }

    public void setType(Type type) {
        this.type = type;
        this.typeStrOriginal = type == null ? null : type.name();
    }

    public String getCount() {
        return this.count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    public void setHumanReadableName(String humanReadableName) {
        this.humanReadableName = humanReadableName;
    }

    public String getOriginalRowInFile() {
        return this.originalRowInFile;
    }

    public void setOriginalRowInFile(String originalRow) {
        this.originalRowInFile = originalRow;
    }

    @Override
    public int compareTo(ColumnMetaData other) {
        return this.columnName.compareToIgnoreCase(other.columnName);
    }

    public List<String> getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(List<String> headerRows) {
        this.headerRows = headerRows;
    }

    public static enum Type {
        JSON,
        String,
        Float,
        Integer,
        Boolean;

    }

    public static enum Headers {
        ColumnName,
        Type,
        Count,
        Description,
        HumanReadableName;

    }
}

