/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.Factories;

import edu.mayo.pipes.iterators.Compressor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;

public class InputStreamBufferedReaderFactory {
    public static BufferedReader constructBufferedReader(InputStream stream, String zipSuffix, boolean reporting) throws UnsupportedEncodingException, IOException {
        Compressor compressor = new Compressor(null, null);
        if (zipSuffix.contains(".gz")) {
            if (reporting) {
                System.out.println("InputStreamBufferedReaderFactory is creating a .gz BufferedReader");
            }
            GZIPInputStream gzin = new GZIPInputStream(stream);
            InputStreamReader decoder = new InputStreamReader((InputStream)gzin, "UTF-8");
            BufferedReader br = new BufferedReader(decoder);
            return br;
        }
        if (zipSuffix.contains(".zip")) {
            if (reporting) {
                System.out.println("InputStreamBufferedReaderFactory is creating a .zip BufferedReader");
            }
            return compressor.makeZipReader(stream);
        }
        if (zipSuffix.contains(".bz")) {
            if (reporting) {
                System.out.println("InputStreamBufferedReaderFactory is creating a .bz BufferedReader");
            }
            return compressor.makeBZipReader(stream);
        }
        if (reporting) {
            System.out.println("InputStreamBufferedReaderFactory is creating a BufferedReader with no compression");
        }
        return InputStreamBufferedReaderFactory.noCompressionBufferedReader(stream);
    }

    private static BufferedReader noCompressionBufferedReader(InputStream stream) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(stream, "UTF-8"));
    }
}

