/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.GAStoppingCriteria;
import org.biojavax.ga.Organism;
import org.biojavax.ga.Population;
import org.biojavax.ga.functions.CrossOverFunction;
import org.biojavax.ga.functions.MutationFunction;
import org.biojavax.ga.functions.SelectionFunction;
import org.biojavax.ga.impl.AbstractGeneticAlgorithm;

public final class SimpleGeneticAlgorithm
extends AbstractGeneticAlgorithm {
    private int generation = 0;
    private LinkedList crossResults = new LinkedList();

    public SimpleGeneticAlgorithm() {
    }

    public SimpleGeneticAlgorithm(Population pop, MutationFunction mutFunc, CrossOverFunction xFunc, SelectionFunction selFunc) {
        try {
            this.setPopulation(pop);
            this.setCrossOverFunction(xFunc);
            this.setMutationFunction(mutFunc);
            this.setSelectionFunction(selFunc);
        }
        catch (ChangeVetoException ex) {
            // empty catch block
        }
    }

    public int getGeneration() {
        return this.generation;
    }

    public List getCrossResults() {
        return this.crossResults;
    }

    public synchronized void run(GAStoppingCriteria stoppingCriteria) throws ChangeVetoException, IllegalAlphabetException, IllegalSymbolException {
        while (!stoppingCriteria.stop(this)) {
            this.getSelectionFunction().select(this.getPopulation(), this);
            Set partners = this.getPopulation().getOrganisms();
            Iterator it = partners.iterator();
            while (it.hasNext()) {
                Organism a = (Organism)it.next();
                if (!it.hasNext()) break;
                Organism b = (Organism)it.next();
                try {
                    for (int i = 0; i < a.getChromosomes().length && i < b.getChromosomes().length; ++i) {
                        this.crossResults.addLast(this.getCrossOverFunction().performCrossOver(a.getChromosomes()[i], b.getChromosomes()[i]));
                        while (this.crossResults.size() > 100) {
                            this.crossResults.removeFirst();
                        }
                    }
                }
                catch (ChangeVetoException ex) {
                    throw new BioError("Unmodifiable chromosome", ex);
                }
            }
            it = this.getPopulation().organisms();
            while (it.hasNext()) {
                Organism o = (Organism)it.next();
                for (int i = 0; i < o.getChromosomes().length; ++i) {
                    this.getMutationFunction().mutate(o.getChromosomes()[i]);
                }
                o.setFitness(this.getFitnessFunction().fitness(o, this.population, this));
            }
            ++this.generation;
        }
    }
}

