/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db.ncbi;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.db.FetchURL;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.db.AbstractRichSequenceDB;
import org.biojavax.bio.db.HashRichSequenceDB;
import org.biojavax.bio.db.RichSequenceDB;
import org.biojavax.bio.db.RichSequenceDBLite;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;
import org.biojavax.bio.seq.io.RichSequenceBuilderFactory;

public class GenbankRichSequenceDB
extends AbstractRichSequenceDB
implements RichSequenceDBLite {
    protected static final String urlBatchSequences = "http://www.ncbi.nlm.nih.gov:80/entrez/eutils/efetch.fcgi";
    private String email = "anonymous@biojava.org";
    private String tool = "biojavax";
    private RichSequenceBuilderFactory factory;
    private Namespace namespace;

    public GenbankRichSequenceDB() {
        this.setFactory(RichSequenceBuilderFactory.THRESHOLD);
        this.setNamespace(RichObjectFactory.getDefaultNamespace());
    }

    protected URL getAddress(String id) throws MalformedURLException {
        FetchURL seqURL = new FetchURL("Genbank", "text");
        String baseurl = seqURL.getbaseURL();
        String db = seqURL.getDB();
        String type = seqURL.getRetrievalType();
        String mode = seqURL.getRetrievalMode();
        String url = baseurl + db + "&id=" + id + "&rettype=" + type + "&retmode=" + mode + "&tool=" + this.getTool() + "&email=" + this.getEmail();
        return new URL(url);
    }

    protected String makeBatchRequest(URL url, Set list) {
        StringBuffer params = new StringBuffer();
        params.append("db=nucleotide&rettype=gb&id=");
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String idSequence = (String)i.next();
            params.append(idSequence);
            if (!i.hasNext()) continue;
            params.append(",");
        }
        params.append("&email=" + this.getEmail() + "&tool=" + this.getTool());
        StringBuffer header = new StringBuffer();
        header.append("POST ");
        header.append(url.getPath());
        header.append(" HTTP/1.0\r\nConnection: close\r\nAccept: text/html, text/plain\r\nHost: ");
        header.append(url.getHost());
        header.append("\r\nUser-Agent: Biojava/GenbankSequenceDB\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: ");
        header.append(params.length());
        header.append("\r\n\r\n");
        StringBuffer request = new StringBuffer();
        request.append(header);
        request.append(params);
        return request.toString();
    }

    public RichSequence getRichSequence(String id) throws BioException, IllegalIDException {
        try {
            URL queryURL = this.getAddress(id);
            SymbolTokenization rParser = DNATools.getDNA().getTokenization("token");
            RichSequenceBuilderFactory seqFactory = this.getFactory();
            Namespace ns = this.getNamespace();
            DataInputStream in = new DataInputStream(queryURL.openStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            RichSequenceIterator seqI = RichSequence.IOTools.readGenbank(reader, rParser, seqFactory, ns);
            return seqI.nextRichSequence();
        }
        catch (MalformedURLException e) {
            throw new BioException("Failed to create Genbank URL", e);
        }
        catch (BioException e) {
            throw new BioException("Failed to read Genbank sequence", e);
        }
        catch (IOException e) {
            throw new BioException("IO failure whilst reading from Genbank", e);
        }
    }

    public RichSequence getRichSequence(String id, Namespace nsp) throws BioException, IllegalIDException {
        try {
            URL queryURL = this.getAddress(id);
            SymbolTokenization rParser = DNATools.getDNA().getTokenization("token");
            RichSequenceBuilderFactory seqFactory = this.getFactory();
            DataInputStream in = new DataInputStream(queryURL.openStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            RichSequenceIterator seqI = RichSequence.IOTools.readGenbank(reader, rParser, seqFactory, nsp);
            return seqI.nextRichSequence();
        }
        catch (MalformedURLException e) {
            throw new BioException("Failed to create Genbank URL", e);
        }
        catch (BioException e) {
            throw new BioException("Failed to read Genbank sequence", e);
        }
        catch (IOException e) {
            throw new BioException("IO failure whilst reading from Genbank", e);
        }
    }

    public RichSequenceDB getRichSequences(Set list) throws BioException, IllegalIDException {
        return this.getRichSequences(list, null);
    }

    public RichSequenceDB getRichSequences(Set list, RichSequenceDB database) throws BioException, IllegalIDException {
        try {
            if (database == null) {
                database = new HashRichSequenceDB();
            }
            URL url = new URL(urlBatchSequences);
            int port = url.getPort();
            String hostname = url.getHost();
            Socket s = new Socket(hostname, port);
            InputStream sin = s.getInputStream();
            BufferedReader fromServer = new BufferedReader(new InputStreamReader(sin));
            OutputStream sout = s.getOutputStream();
            PrintWriter toServer = new PrintWriter(new OutputStreamWriter(sout));
            toServer.print(this.makeBatchRequest(url, list));
            toServer.flush();
            boolean finEntete = false;
            String l = null;
            while ((l = fromServer.readLine()) != null && !finEntete) {
                if (!l.equals("")) continue;
                finEntete = true;
            }
            SymbolTokenization rParser = DNATools.getDNA().getTokenization("token");
            RichSequenceBuilderFactory seqFactory = this.getFactory();
            Namespace ns = this.getNamespace();
            RichSequenceIterator seqI = RichSequence.IOTools.readGenbank(fromServer, rParser, seqFactory, ns);
            while (seqI.hasNext()) {
                try {
                    database.addSequence(seqI.nextRichSequence());
                }
                catch (ChangeVetoException ce) {
                    throw new BioException("Unexpectedly couldn't add to the supplied RichSequenceDB", ce);
                }
            }
            return database;
        }
        catch (MalformedURLException e) {
            throw new BioException("Failed to create Genbank URL", e);
        }
        catch (BioException e) {
            throw new BioException("Failed to read Genbank sequence", e);
        }
        catch (IOException e) {
            throw new BioException("IO failure whilst reading from Genbank", e);
        }
    }

    public String getName() {
        return "Genbank";
    }

    public Set ids() {
        throw new RuntimeException("Complete set of Genbank ids is unavailable.");
    }

    public RichSequenceBuilderFactory getFactory() {
        return this.factory;
    }

    public void setFactory(RichSequenceBuilderFactory factory) {
        this.factory = factory;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public void setTool(String tool) {
        this.tool = tool;
    }

    public String getTool() {
        return this.tool;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }
}

