/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.distributed;

import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.AbstractSequenceDB;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.distributed.DistDataSource;
import org.biojava.bio.seq.distributed.DistributedSequence;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class DistributedSequenceDB
extends AbstractSequenceDB
implements SequenceDB {
    public static final ChangeType DATASOURCE = new ChangeType("Data sources have changes in a Distributed Sequence DB", "org.biojava.bio.seq.distributed.DistributedSequenceDB", "DATASOURCE", ChangeType.UNKNOWN);
    public static final ChangeType DATASOURCE_SELECTION = new ChangeType("The set of available data sources has changes in a Distributed Sequence DB", "org.biojava.bio.seq.distributed.DistributedSequenceDB", "DATASOURCE_SELECTION", DATASOURCE);
    private Set datasources = new HashSet();
    private transient ChangeSupport changeSupport;

    protected boolean hasChangeSupport() {
        return this.changeSupport != null;
    }

    protected ChangeSupport getChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        return this.changeSupport;
    }

    public Set getDataSources() {
        return new HashSet(this.datasources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSource(DistDataSource dds) throws ChangeVetoException {
        if (this.datasources.contains(dds)) {
            return;
        }
        if (this.hasChangeSupport()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport();
            synchronized (changeSupport) {
                ChangeEvent cev = new ChangeEvent(this, DATASOURCE_SELECTION, dds, null);
                cs.firePreChangeEvent(cev);
                this._addDataSource(dds);
                cs.firePostChangeEvent(cev);
            }
        } else {
            this._addDataSource(dds);
        }
    }

    private void _addDataSource(DistDataSource dds) {
        this.datasources.add(dds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSource(DistDataSource dds) throws ChangeVetoException {
        if (!this.datasources.contains(dds)) {
            throw new ChangeVetoException("That datasource isn't currently installed");
        }
        if (this.hasChangeSupport()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport();
            synchronized (changeSupport) {
                ChangeEvent cev = new ChangeEvent(this, DATASOURCE_SELECTION, null, dds);
                cs.firePreChangeEvent(cev);
                this._removeDataSource(dds);
                cs.firePostChangeEvent(cev);
            }
        } else {
            this._removeDataSource(dds);
        }
    }

    private void _removeDataSource(DistDataSource dds) {
        this.datasources.remove(dds);
    }

    public String getName() {
        return "<unknown meta-das>";
    }

    public void addSequence(Sequence seq) throws ChangeVetoException {
        throw new ChangeVetoException("Can't add sequences to meta-das");
    }

    public void removeSequence(String id) throws ChangeVetoException {
        throw new ChangeVetoException("Can't add sequences to meta-das");
    }

    public Sequence getSequence(String id) throws IllegalIDException, BioException {
        HashSet<DistDataSource> featureSources = new HashSet<DistDataSource>();
        DistDataSource seqSource = null;
        for (DistDataSource dds : this.datasources) {
            if (dds.hasSequence(id) && seqSource == null) {
                seqSource = dds;
            }
            if (!dds.hasFeatures(id)) continue;
            featureSources.add(dds);
        }
        if (seqSource == null) {
            throw new IllegalIDException("No sequence source for ID: " + id);
        }
        return new DistributedSequence(id, this, seqSource, featureSources);
    }

    public Set ids() {
        HashSet ids = new HashSet();
        for (DistDataSource dds : this.datasources) {
            try {
                ids.addAll(dds.ids(true));
            }
            catch (BioException ex) {}
        }
        return ids;
    }
}

