/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli.util;

import edu.mayo.sage.Usage;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SageUtil {
    private static Logger sLogger = Logger.getLogger(SageUtil.class);

    public static void setupSage(Properties globalProperties) {
        Usage.setProperties((Properties)globalProperties);
        sLogger.info((Object)"Sage settings from Global.properties:");
        for (Object key : globalProperties.keySet()) {
            if (!((String)key).startsWith("SAGE")) continue;
            sLogger.info((Object)("    " + key + " = " + globalProperties.getProperty((String)key)));
        }
    }

    public static Map<String, Object> toSageMap(CommandLine line) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        block4: for (Option opt : line.getOptions()) {
            String key = "OPT_" + opt.getOpt();
            switch (opt.getArgs()) {
                case -1: 
                case 0: {
                    m.put(key, "true");
                    continue block4;
                }
                case 1: {
                    m.put(key, line.getOptionValue(opt.getOpt()));
                    continue block4;
                }
                default: {
                    StringBuilder sb = new StringBuilder();
                    for (String value : line.getOptionValues(opt.getOpt())) {
                        sb.append(value);
                        sb.append('|');
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    m.put(key, sb.toString());
                }
            }
        }
        String[] args = line.getArgs();
        for (int i = 1; i <= args.length; ++i) {
            String key = "ARG_" + i;
            m.put(key, args[i - 1]);
        }
        return m;
    }
}

