/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.CommandLine;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.Assert;
import junit.framework.TestCase;

public class IntegrationTest
extends TestCase {
    public final int BUFFER_SIZE = 0x100000;
    public static final int MAX_LINES_DIFF = 10;
    boolean verbose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String command(CommandLine command, String[] args) {
        PrintStream oldOut = System.out;
        String standardOutput = "";
        ByteArrayOutputStream output = new ByteArrayOutputStream(0x100000);
        try {
            System.setOut(new PrintStream(output));
            command.parseArgs(args);
            command.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            standardOutput = output.toString();
            System.setOut(oldOut);
        }
        return standardOutput;
    }

    public void command(CommandLine command, String[] args, String expectedOutputFile) {
        System.err.println("Executing command '" + this.showCommand(command, args) + "'");
        String actualOutput = this.command(command, args);
        System.err.println("Reading results file '" + expectedOutputFile + "'");
        String expectedOutput = Gpr.readFile(expectedOutputFile);
        int expectedOutputCountLines = expectedOutput.split("\n").length;
        int actualOutputCountLines = actualOutput.split("\n").length;
        System.err.println("Comparing outputs\t\tExpected size: " + expectedOutput.length() + " (" + expectedOutputCountLines + " lines)\t\tActual size: " + actualOutput.length() + " (" + actualOutputCountLines + " lines)");
        int maxSize = Math.max(expectedOutput.length(), actualOutput.length());
        if (maxSize < 0x100000) {
            Assert.assertEquals((String)expectedOutput, (String)actualOutput);
        } else if (!expectedOutput.equals(actualOutput)) {
            String msg = "Outputs differ!\n\tFile    : '" + expectedOutputFile + "'\n\tCommand : '" + this.showCommand(command, args) + "'";
            System.err.println(msg);
            System.err.println(this.showDiff(expectedOutput, actualOutput));
            throw new RuntimeException(msg);
        }
    }

    public String showCommand(CommandLine command, String[] args) {
        StringBuilder cmd = new StringBuilder();
        cmd.append(command.getClass().getSimpleName() + " ");
        for (String arg : args) {
            cmd.append(arg + " ");
        }
        return cmd.toString();
    }

    public String showDiff(String s1, String s2) {
        StringBuilder diff = new StringBuilder();
        String[] lines1 = s1.split("\n");
        String[] lines2 = s2.split("\n");
        diff.append("Number of lines: " + lines1.length + " vs " + lines2.length + "\n");
        int min = Math.min(lines1.length, lines2.length);
        int countLinesDiff = 0;
        for (int i = 0; i < min; ++i) {
            if (!lines1[i].equals(lines2[i])) {
                ++countLinesDiff;
                diff.append(String.format("%10d\t|%s|\n", i + 1, lines1[i]));
                diff.append(String.format("          \t|%s|\n", lines2[i]));
                diff.append(String.format("          \t|%s|\n\n", this.showDiffLine(lines1[i], lines2[i])));
            }
            if (countLinesDiff > 10) break;
        }
        return diff.toString();
    }

    public String showDiffLine(String l1, String l2) {
        int max = Math.max(l1.length(), l2.length());
        char[] d = new char[max];
        for (int i = 0; i < max; ++i) {
            d[i] = i >= l1.length() || i >= l2.length() ? 124 : (l1.charAt(i) != l2.charAt(i) ? 124 : (l1.charAt(i) == '\t' ? 9 : 32));
        }
        return new String(d);
    }
}

