/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.biojava.bio.BioError;
import org.biojava.bio.program.ssaha.DataStore;
import org.biojava.bio.program.ssaha.SearchListener;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.PackingFactory;
import org.biojava.bio.symbol.SymbolList;

class MappedDataStore
implements DataStore {
    private final Packing packing;
    private final int wordLength;
    private final IntBuffer hashTable;
    private final MappedByteBuffer hitTable;
    private final IntBuffer nameArray;
    private final MappedByteBuffer nameTable;

    MappedDataStore(File dataStoreFile) throws IOException {
        FileChannel channel = new FileInputStream(dataStoreFile).getChannel();
        MappedByteBuffer rootBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, 24L);
        rootBuffer.position(0);
        int hashTablePos = rootBuffer.getInt();
        int hitTablePos = rootBuffer.getInt();
        int nameArrayPos = rootBuffer.getInt();
        int nameTablePos = rootBuffer.getInt();
        this.wordLength = rootBuffer.getInt();
        int packingStreamLength = rootBuffer.getInt();
        rootBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, 24 + packingStreamLength);
        rootBuffer.position(24);
        byte[] packingBuffer = new byte[packingStreamLength];
        rootBuffer.get(packingBuffer);
        ByteArrayInputStream packingStream = new ByteArrayInputStream(packingBuffer);
        ObjectInputStream packingSerializer = new ObjectInputStream(packingStream);
        try {
            this.packing = (Packing)packingSerializer.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new Error("Can't restore packing", cnfe);
        }
        MappedByteBuffer hashTable_MB = channel.map(FileChannel.MapMode.READ_ONLY, hashTablePos, 4L);
        hashTable_MB.position(0);
        int hashTableSize = hashTable_MB.getInt();
        this.hashTable = channel.map(FileChannel.MapMode.READ_ONLY, hashTablePos + 4, hashTableSize - 4).asIntBuffer();
        MappedByteBuffer hitTable_MB = channel.map(FileChannel.MapMode.READ_ONLY, hitTablePos, 4L);
        hitTable_MB.position(0);
        int hitTableSize = hitTable_MB.getInt();
        this.hitTable = channel.map(FileChannel.MapMode.READ_ONLY, hitTablePos + 4, hitTableSize - 4);
        MappedByteBuffer nameArray_MB = channel.map(FileChannel.MapMode.READ_ONLY, nameArrayPos, 4L);
        nameArray_MB.position(0);
        int nameArraySize = nameArray_MB.getInt();
        this.nameArray = channel.map(FileChannel.MapMode.READ_ONLY, nameArrayPos + 4, nameArraySize - 4).asIntBuffer();
        MappedByteBuffer nameTable_MB = channel.map(FileChannel.MapMode.READ_ONLY, nameTablePos, 4L);
        nameTable_MB.position(0);
        int nameTableSize = nameTable_MB.getInt();
        this.nameTable = channel.map(FileChannel.MapMode.READ_ONLY, nameTablePos + 4, nameTableSize - 4);
    }

    public FiniteAlphabet getAlphabet() {
        return this.packing.getAlphabet();
    }

    public void search(String seqID, SymbolList symList, SearchListener listener) {
        try {
            int word = PackingFactory.primeWord(symList, this.wordLength, this.packing);
            listener.startSearch(seqID);
            this.fireHits(word, 1, listener);
            for (int j = this.wordLength + 1; j <= symList.length(); ++j) {
                word = PackingFactory.nextWord(symList, word, j, this.wordLength, this.packing);
                this.fireHits(word, j - this.wordLength + 1, listener);
            }
            listener.endSearch(seqID);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Assertion Failure: Symbol dissapeared");
        }
    }

    public String seqNameForID(int id) {
        int offset = this.nameArray.get(id);
        this.nameTable.position(offset);
        int length = this.nameTable.getInt();
        StringBuffer sbuff = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            sbuff.append(this.nameTable.getChar());
        }
        return sbuff.toString();
    }

    private void fireHits(int word, int offset, SearchListener listener) {
        int hitOffset = this.hashTable.get(word);
        if (hitOffset != -1) {
            try {
                this.hitTable.position(hitOffset);
            }
            catch (IllegalArgumentException e) {
                System.out.println("word:\t" + word);
                System.out.println("offset:\t" + offset);
                System.out.println("hitOffset\t" + hitOffset);
                throw e;
            }
            int hits = this.hitTable.getInt();
            for (int i = 0; i < hits; ++i) {
                listener.hit(this.hitTable.getInt(), offset, this.hitTable.getInt(), this.wordLength);
            }
        }
    }
}

