/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.inject;

import com.google.gson.JsonObject;
import edu.mayo.Optimized;
import edu.mayo.pipes.JSON.inject.BaseInjector;
import edu.mayo.pipes.JSON.inject.ColumnAware;
import edu.mayo.pipes.JSON.inject.Injector;
import edu.mayo.pipes.JSON.modify.JsonTypeExtended;
import edu.mayo.pipes.history.History;
import org.apache.commons.lang.StringUtils;

public class ColumnArrayInjector
extends BaseInjector
implements Injector,
ColumnAware {
    private int mCol;
    private String mKey;
    private JsonTypeExtended mType;
    private String mDelimiterRegex;
    private boolean isDelimiterRegex = true;
    private boolean isStripWhitespace = false;

    public ColumnArrayInjector(int column, JsonTypeExtended type, String delimiterRegex) {
        this(column, null, type, delimiterRegex);
    }

    public ColumnArrayInjector(int column, String key, JsonTypeExtended type, String delimiterRegex, boolean stripWhitespace) {
        this.init(column, key, type, delimiterRegex);
        this.isStripWhitespace = stripWhitespace;
    }

    public ColumnArrayInjector(int column, String key, JsonTypeExtended type, String delimiterRegex, boolean stripWhitespace, boolean isDelimiterRegex) {
        this.init(column, key, type, delimiterRegex);
        this.isStripWhitespace = stripWhitespace;
        this.isDelimiterRegex = isDelimiterRegex;
    }

    public ColumnArrayInjector(int column, String key, JsonTypeExtended type, String delimiterRegex) {
        this.init(column, key, type, delimiterRegex);
    }

    private void init(int column, String key, JsonTypeExtended type, String delimiterRegex) {
        if (column == 0) {
            throw new IllegalArgumentException("Zero is not a valid column - columns begin with 1.");
        }
        this.mCol = column;
        this.mKey = key;
        this.mType = type;
        this.mDelimiterRegex = delimiterRegex;
    }

    @Override
    public void inject(JsonObject object, History history) {
        String key = this.mKey == null ? history.getMetaData().getColumns().get(this.mCol - 1).getColumnName() : this.mKey;
        String value = "";
        Object[] values = new String[]{};
        try {
            value = (String)history.get(this.mCol - 1);
            values = this.isNull(value) ? new String[]{} : (this.isDelimiterRegex ? value.split(this.mDelimiterRegex) : Optimized.split(value, this.mDelimiterRegex));
            if (this.isStripWhitespace) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = ((String)values[i]).trim();
                }
            }
            super.injectAsArray(object, key, (String[])values, this.mType);
        }
        catch (Exception e) {
            String errorMsg = "Error on column array injector for key [" + key + "] and values [" + StringUtils.join((Object[])values, (String)", ") + "].  " + e.getClass().getName() + ": " + e.getMessage();
            throw new RuntimeException(errorMsg);
        }
    }

    @Override
    public int getColumn() {
        return this.mCol;
    }
}

