/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.inject;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import edu.mayo.pipes.JSON.inject.Injector;
import edu.mayo.pipes.JSON.modify.JsonTypeExtended;
import edu.mayo.pipes.bioinformatics.VCF2VariantPipe;

public abstract class BaseInjector
implements Injector {
    private VCF2VariantPipe vcfToTjsonPipe = new VCF2VariantPipe();

    protected void injectAsPrimitive(JsonObject object, String key, String value, JsonTypeExtended type) {
        switch (type) {
            case BOOLEAN: {
                try {
                    Boolean bool = BaseInjector.toBoolean(value);
                    if (bool == null) break;
                    object.addProperty(key, bool);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Value could not be converted to a Boolean: " + value + ".  Key: " + key);
                }
            }
            case INTEGER: {
                object.addProperty(key, this.getAsInteger(key, value));
            }
            case FLOAT: {
                object.addProperty(key, this.getAsNumber(value));
                break;
            }
            case STRING: {
                object.addProperty(key, value);
                return;
            }
        }
    }

    public static Boolean toBoolean(String value) {
        if (null == value || ".".equals(value) || "null".equals(value)) {
            return null;
        }
        if ("true".equalsIgnoreCase(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "0".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    protected void injectAsArray(JsonObject object, String key, String[] values, JsonTypeExtended type) {
        JsonArray array = new JsonArray();
        block6: for (String value : values) {
            switch (type) {
                case BOOLEAN: {
                    array.add((JsonElement)(this.isNull(value) ? JsonNull.INSTANCE : new JsonPrimitive(new Boolean(value))));
                    continue block6;
                }
                case INTEGER: {
                    array.add((JsonElement)(this.isNull(value) ? JsonNull.INSTANCE : new JsonPrimitive(this.getAsInteger(key, value))));
                    continue block6;
                }
                case FLOAT: {
                    array.add((JsonElement)(this.isNull(value) ? JsonNull.INSTANCE : new JsonPrimitive(this.getAsNumber(value))));
                    continue block6;
                }
                case STRING: {
                    array.add((JsonElement)new JsonPrimitive(this.isNull(value) ? "" : value));
                }
            }
        }
        object.add(key, (JsonElement)array);
    }

    private Number getAsNumber(String s) {
        try {
            return new Integer(s);
        }
        catch (Exception e) {
            return this.vcfToTjsonPipe.parseDouble(s);
        }
    }

    private Number getAsInteger(String key, String val) {
        try {
            return new Integer(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value could not be converted to an Integer: " + val + ".  Key: " + key);
        }
    }

    protected boolean isNull(String value) {
        if (value == null) {
            return true;
        }
        return (value = value.trim()).length() == 0 || value.equals(".") || value.equalsIgnoreCase("null") || value.equalsIgnoreCase("\\N");
    }
}

