/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import edu.mayo.bior.pipeline.InfoMetaObject;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import edu.mayo.pipes.util.metadata.AddMetadataLines;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class VcfInfoColumnBuilder {
    private CharacterEncodingMethod characterEncodingMethod = CharacterEncodingMethod.URL_BASIC;
    private Map<Character, String> characterEncodingMap = new HashMap<Character, String>();
    private static final Logger sLogger = Logger.getLogger(VcfInfoColumnBuilder.class);
    private List<History> mHistoryLinesToUseForInfoGathering = new ArrayList<History>();
    protected Map<String, LinkedHashMap<String, String>> mBiorHeaderMap = null;
    private Map<String, String> mBiorCatalogPathToColumnsTsvContentsMap = new HashMap<String, String>();
    private TreeSet<Integer> mZeroBasedColumnsToAdd = new TreeSet(Collections.reverseOrder());
    private List<String> mOriginalColumnHeader;
    private List<ColumnMetaData> mOriginalColumnMetaData;
    private Comparator<InfoMetaObject> mInfoMetaObjCompareById;
    private Map<String, InfoMetaObject> mInfoMetaMap = new HashMap<String, InfoMetaObject>();

    public VcfInfoColumnBuilder() {
        this.setCharacterEncodingMethod(CharacterEncodingMethod.URL_BASIC);
    }

    public CharacterEncodingMethod getCharacterEncodingMethod() {
        return this.characterEncodingMethod;
    }

    public void setCharacterEncodingMethod(CharacterEncodingMethod charEncodingMethod) {
        this.characterEncodingMethod = charEncodingMethod;
        this.characterEncodingMap = new HashMap<Character, String>();
        if (this.characterEncodingMethod.equals((Object)CharacterEncodingMethod.URL_BASIC) || this.characterEncodingMethod.equals((Object)CharacterEncodingMethod.URL_EXTENDED)) {
            this.characterEncodingMap.put(Character.valueOf(','), "%2C");
            this.characterEncodingMap.put(Character.valueOf('='), "%3D");
            this.characterEncodingMap.put(Character.valueOf(';'), "%3B");
        }
        if (this.characterEncodingMethod.equals((Object)CharacterEncodingMethod.URL_EXTENDED)) {
            this.characterEncodingMap.put(Character.valueOf(':'), "%3A");
            this.characterEncodingMap.put(Character.valueOf('%'), "%25");
            this.characterEncodingMap.put(Character.valueOf('\t'), "%09");
            this.characterEncodingMap.put(Character.valueOf('\r'), "%0D");
            this.characterEncodingMap.put(Character.valueOf('\n'), "%0A");
        }
    }

    public List<String> createInfoMetadata(List<History> lineQueue, TreeSet<Integer> mColumnsToAddToInfo) {
        this.mHistoryLinesToUseForInfoGathering = lineQueue;
        this.mZeroBasedColumnsToAdd = mColumnsToAddToInfo;
        HistoryMetaData meta = lineQueue.get(0).getMetaData();
        this.mBiorHeaderMap = this.getBiorHeaderIdMap(meta);
        this.mOriginalColumnHeader = Arrays.asList(meta.getColumnHeaderRow(lineQueue.get(0), "\t").split("\t", -1));
        this.mOriginalColumnMetaData = Collections.unmodifiableList(new ArrayList(meta.getColumns()));
        List<InfoMetaObject> infoMetasFromBiorHeaders = this.getInfoMetaFromBiorHeaders(mColumnsToAddToInfo);
        List<InfoMetaObject> infoMetasFromQueue = this.getInfoMetaObjectsFromQueuedLines(lineQueue, mColumnsToAddToInfo);
        List<InfoMetaObject> infoMetasFromColumnHeadersGeneric = this.getInfoMetaObjectsFromColumnHeadersGeneric(mColumnsToAddToInfo);
        List<InfoMetaObject> infoMetasTemp = this.mergeInfoMetas(infoMetasFromBiorHeaders, infoMetasFromQueue);
        List<InfoMetaObject> infoMetas = this.mergeInfoMetas(infoMetasTemp, infoMetasFromColumnHeadersGeneric);
        for (InfoMetaObject infoMeta : infoMetas) {
            this.mInfoMetaMap.put(infoMeta.getId(), infoMeta);
        }
        return this.infoMetasToStrings(infoMetas);
    }

    private List<InfoMetaObject> getInfoMetaObjectsFromColumnHeadersGeneric(TreeSet<Integer> columnsToAddToInfo) {
        ArrayList<InfoMetaObject> infoMetaObjects = new ArrayList<InfoMetaObject>();
        History line = this.mHistoryLinesToUseForInfoGathering.get(0);
        for (int colToAdd : columnsToAddToInfo) {
            String desc;
            ColumnMetaData colMeta = (ColumnMetaData)line.getMetaData().getColumns().get(colToAdd);
            if (this.isBiorHeaderTypeJson(colMeta.getColumnName()) || this.isAnyJsonInColumn(colToAdd)) continue;
            String count = colMeta.getCount();
            if (count == null || count.trim().length() == 0) {
                count = ".";
            }
            if ((desc = colMeta.getDescription()) == null || desc.trim().length() == 0) {
                desc = "";
            }
            infoMetaObjects.add(new InfoMetaObject("", new ArrayList<String>(), colMeta.getColumnName(), this.getTypeFromColumnMetaData(line, colToAdd), count, desc));
        }
        return infoMetaObjects;
    }

    private boolean isAnyJsonInColumn(int colZeroBased) {
        for (History line : this.mHistoryLinesToUseForInfoGathering) {
            if (!this.isJsonObject((String)line.get(colZeroBased))) continue;
            return true;
        }
        return false;
    }

    private List<InfoMetaObject> mergeInfoMetas(List<InfoMetaObject> infoMetasPrimary, List<InfoMetaObject> infoMetasSecondary) {
        ArrayList<InfoMetaObject> infoMetas = new ArrayList<InfoMetaObject>();
        for (InfoMetaObject infoMetaPrimary : infoMetasPrimary) {
            infoMetas.add(infoMetaPrimary);
        }
        for (InfoMetaObject infoMetaSecondary : infoMetasSecondary) {
            boolean isInPrimaryList = false;
            for (InfoMetaObject infoMetaPrimary : infoMetasPrimary) {
                if (!infoMetaPrimary.getId().equals(infoMetaSecondary.getId())) continue;
                isInPrimaryList = true;
            }
            if (isInPrimaryList) continue;
            infoMetas.add(infoMetaSecondary);
        }
        return infoMetas;
    }

    private List<String> infoMetasToStrings(List<InfoMetaObject> infoMetas) {
        this.mInfoMetaObjCompareById = this.getInfoMetaObjectComparator();
        Collections.sort(infoMetas, this.mInfoMetaObjCompareById);
        ArrayList<String> infoMetadataHeaders = new ArrayList<String>();
        for (InfoMetaObject infoMetaObj : infoMetas) {
            this.updateInfoMetaObjFromColumnsTsvInBiorHeaderLine(infoMetaObj, this.mBiorHeaderMap);
            infoMetadataHeaders.add(infoMetaObj.toString());
        }
        return infoMetadataHeaders;
    }

    private List<InfoMetaObject> getInfoMetaFromBiorHeaders(TreeSet<Integer> columnsToAddToInfo) {
        ArrayList<InfoMetaObject> metaFromBiorHeaders = new ArrayList<InfoMetaObject>();
        for (Integer colIdx : columnsToAddToInfo) {
            String colHeaderStr = this.mOriginalColumnHeader.get(colIdx);
            if (!this.mBiorHeaderMap.containsKey(colHeaderStr) || this.isBiorHeaderTypeJson(colHeaderStr)) continue;
            InfoMetaObject infoMetaObj = this.getInfoMetaFromBiorHeaderLine(colHeaderStr);
            this.updateInfoMetaObjFromColumnsTsvInBiorHeaderLine(infoMetaObj, this.mBiorHeaderMap);
            metaFromBiorHeaders.add(infoMetaObj);
        }
        return metaFromBiorHeaders;
    }

    private InfoMetaObject getInfoMetaFromBiorHeaderLine(String colHeaderStr) {
        String description;
        Map biorMetaFields = this.mBiorHeaderMap.get(colHeaderStr);
        InfoMetaObject.KeyValType type = this.columnsTsvTypeToKeyValType((String)biorMetaFields.get(AddMetadataLines.BiorMetaControlledVocabulary.DATATYPE.toString()));
        String numOccurrences = (String)biorMetaFields.get(AddMetadataLines.BiorMetaControlledVocabulary.NUMBER.toString());
        if (numOccurrences == null || numOccurrences.trim().length() == 0) {
            numOccurrences = ".";
        }
        if ((description = (String)biorMetaFields.get(AddMetadataLines.BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString())) == null || description.trim().length() == 0) {
            description = "";
        }
        return new InfoMetaObject(null, new ArrayList<String>(), colHeaderStr, type, numOccurrences, description);
    }

    private boolean isBiorHeaderTypeJson(String key) {
        Map biorMetaLineFieldMap = this.mBiorHeaderMap.get(key);
        if (biorMetaLineFieldMap == null) {
            return false;
        }
        String type = (String)biorMetaLineFieldMap.get(AddMetadataLines.BiorMetaControlledVocabulary.DATATYPE.toString());
        return "JSON".equalsIgnoreCase(type);
    }

    private List<InfoMetaObject> getInfoMetaObjectsFromQueuedLines(List<History> lineQueue, TreeSet<Integer> columnsToAddToInfo) {
        ArrayList<InfoMetaObject> infoMetaObjList = new ArrayList<InfoMetaObject>();
        HashSet<String> idSet = new HashSet<String>();
        for (History history : lineQueue) {
            if (this.isBlankLine(history)) continue;
            for (Integer colIdxToAdd : columnsToAddToInfo) {
                List<InfoMetaObject> newObjsToAdd = this.getColumnAsInfoMetaObjects(history, colIdxToAdd);
                for (InfoMetaObject obj : newObjsToAdd) {
                    if (idSet.contains(obj.getId())) continue;
                    infoMetaObjList.add(obj);
                    idSet.add(obj.getId());
                }
            }
        }
        return infoMetaObjList;
    }

    private boolean isBlankLine(History history) {
        return history == null || history.size() == 0 || history.size() == 1 && ((String)history.get(0)).length() == 0;
    }

    public List<String> createInfoMetadataFromInfoInTargetJsonCol(List<History> lineQueue, int jsonColumnToBuildVcfStructure) {
        ArrayList<InfoMetaObject> infoMetaObjs = new ArrayList<InfoMetaObject>();
        for (History line : lineQueue) {
            JsonObject jsonObj;
            JsonElement infoElem;
            String jsonCol;
            if (this.isBlankLine(line) || !this.isJsonObject(jsonCol = (String)line.get(jsonColumnToBuildVcfStructure)) || (infoElem = (jsonObj = this.stringToJsonObject(jsonCol)).get("INFO")) == null) continue;
            if (infoElem.isJsonObject()) {
                infoMetaObjs.addAll(this.jsonElementToInfoMetaObjects("", "", infoElem));
                continue;
            }
            if (!infoElem.isJsonPrimitive()) continue;
            infoMetaObjs.addAll(this.flatInfoToInfoMetaObjects(infoElem.getAsString()));
        }
        ArrayList<String> infoMetaObjStrs = new ArrayList<String>();
        HashSet<String> infoKeys = new HashSet<String>();
        for (InfoMetaObject infoMetaObj : infoMetaObjs) {
            if (infoKeys.contains(infoMetaObj.getId())) continue;
            infoMetaObjStrs.add(infoMetaObj.toString());
            infoKeys.add(infoMetaObj.getId());
        }
        return infoMetaObjStrs;
    }

    private List<InfoMetaObject> flatInfoToInfoMetaObjects(String infoFlat) {
        String[] keyVals;
        ArrayList<InfoMetaObject> infoMetaObjs = new ArrayList<InfoMetaObject>();
        for (String keyVal : keyVals = infoFlat.split(";")) {
            if (keyVal.length() == 0 || keyVal.equals(".")) continue;
            String[] keyOrVal = keyVal.split("=");
            String key = keyOrVal[0];
            String[] vals = (keyOrVal.length == 1 ? "" : keyOrVal[1]).split(",");
            InfoMetaObject.KeyValType type = this.getType(vals[0]);
            String count = InfoMetaObject.KeyValType.Flag.equals((Object)type) ? "0" : ".";
            infoMetaObjs.add(new InfoMetaObject(key, Arrays.asList(vals), "", type, count, ""));
        }
        return infoMetaObjs;
    }

    protected void updateInfoMetaObjFromColumnsTsvInBiorHeaderLine(InfoMetaObject infoMetaObj, Map<String, LinkedHashMap<String, String>> biorHeaderMap) {
        LinkedHashMap<String, String> biorMetaMapForKey = biorHeaderMap.get(infoMetaObj.parentColumnName);
        if (biorMetaMapForKey == null) {
            return;
        }
        String catalogPath = biorMetaMapForKey.get(AddMetadataLines.BiorMetaControlledVocabulary.PATH.toString());
        this.addColumnsTsvToMap(catalogPath);
        String columnsTsvContents = this.mBiorCatalogPathToColumnsTsvContentsMap.get(catalogPath);
        if (columnsTsvContents == null) {
            return;
        }
        this.updateInfoMetaObjFromColumnsTsvContents(infoMetaObj, biorMetaMapForKey, columnsTsvContents);
    }

    private void updateInfoMetaObjFromColumnsTsvContents(InfoMetaObject infoMetaObj, LinkedHashMap<String, String> biorMetaMapForKey, String columnsTsvContents) {
        String[] rows = columnsTsvContents.split("\n");
        String dataKey = infoMetaObj.jsonKey;
        if (biorMetaMapForKey.containsKey(AddMetadataLines.BiorMetaControlledVocabulary.FIELD.toString())) {
            dataKey = biorMetaMapForKey.get(AddMetadataLines.BiorMetaControlledVocabulary.FIELD.toString());
        }
        if (dataKey == null || dataKey.length() == 0) {
            dataKey = infoMetaObj.parentColumnName;
        }
        for (String row : rows) {
            String keyInColumnsCsv;
            String[] cols = row.split("\t");
            if (cols.length <= 0 || (keyInColumnsCsv = cols[0].trim()).startsWith("#") || !keyInColumnsCsv.equalsIgnoreCase(dataKey)) continue;
            infoMetaObj.type = this.columnsTsvTypeToKeyValType(cols[1].trim());
            infoMetaObj.numOccurrences = cols[2].trim();
            infoMetaObj.description = cols[3].trim();
        }
    }

    private void addColumnsTsvToMap(String catalogPath) {
        if (catalogPath == null) {
            return;
        }
        if (this.mBiorCatalogPathToColumnsTsvContentsMap.get(catalogPath) == null) {
            File columnsTsvFile = new File(catalogPath.replace(".tsv.bgz", "").replace(".tsv.gz", "") + ".columns.tsv");
            if (!columnsTsvFile.exists()) {
                return;
            }
            try {
                String columnsTsvContents = FileUtils.readFileToString((File)columnsTsvFile);
                this.mBiorCatalogPathToColumnsTsvContentsMap.put(catalogPath, columnsTsvContents);
            }
            catch (Exception e) {
                sLogger.warn((Object)("Could not read from columns.tsv file: " + columnsTsvFile.toString() + "  for catalog: " + catalogPath));
                return;
            }
        }
    }

    private InfoMetaObject.KeyValType columnsTsvTypeToKeyValType(String columnsTsvType) {
        if (columnsTsvType == null || columnsTsvType.trim().length() == 0) {
            return InfoMetaObject.KeyValType.String;
        }
        if (columnsTsvType.equalsIgnoreCase("Integer")) {
            return InfoMetaObject.KeyValType.Integer;
        }
        if (columnsTsvType.equalsIgnoreCase("Float")) {
            return InfoMetaObject.KeyValType.Float;
        }
        if (columnsTsvType.equalsIgnoreCase("Boolean")) {
            return InfoMetaObject.KeyValType.Flag;
        }
        return InfoMetaObject.KeyValType.String;
    }

    public String createInfoData(History history, TreeSet<Integer> mColumnsToAddToInfo) {
        ArrayList<InfoMetaObject> infoMetaObjs = new ArrayList<InfoMetaObject>();
        for (int colIdxToAdd : mColumnsToAddToInfo) {
            infoMetaObjs.addAll(this.getColumnAsInfoMetaObjects(history, colIdxToAdd));
        }
        Collections.sort(infoMetaObjs, this.mInfoMetaObjCompareById);
        String newInfoMetaObjs = this.getInfoMetaObjsAsString(infoMetaObjs);
        return newInfoMetaObjs;
    }

    private Comparator<InfoMetaObject> getInfoMetaObjectComparator() {
        return new Comparator<InfoMetaObject>(){

            @Override
            public int compare(InfoMetaObject info1, InfoMetaObject info2) {
                return info1.getId().compareToIgnoreCase(info2.getId());
            }
        };
    }

    public void addInfoLineToHeader(History history, String infoMetaLine) {
        List metaHeaders = history.getMetaData().getOriginalHeader();
        int rowToInsertBefore = this.getIdxToInsertInfo(metaHeaders, infoMetaLine);
        metaHeaders.add(rowToInsertBefore, infoMetaLine);
    }

    private int getIdxToInsertInfo(List<String> metaHeaders, String infoMetaLine) {
        boolean isAnInfoLineFound = false;
        for (int i = metaHeaders.size() - 1; i >= 0; --i) {
            String meta = metaHeaders.get(i);
            boolean isInfoRow = meta.startsWith("##INFO");
            if (isInfoRow) {
                if (infoMetaLine.compareToIgnoreCase(meta) > 0) {
                    return i + 1;
                }
                isAnInfoLineFound = true;
                continue;
            }
            if (!isAnInfoLineFound) continue;
            return i + 1;
        }
        if (isAnInfoLineFound || metaHeaders.size() == 0) {
            return 0;
        }
        return metaHeaders.size() - 1;
    }

    protected Map<String, LinkedHashMap<String, String>> getBiorHeaderIdMap(HistoryMetaData historyMetaData) {
        HashMap<String, LinkedHashMap<String, String>> biorHeaderMap = new HashMap<String, LinkedHashMap<String, String>>();
        AddMetadataLines amdl = new AddMetadataLines();
        List headerLines = historyMetaData.getOriginalHeader();
        for (String headerLine : headerLines) {
            LinkedHashMap keyVal = amdl.parseHeaderLine(headerLine);
            String id = (String)keyVal.get(AddMetadataLines.BiorMetaControlledVocabulary.ID.toString());
            biorHeaderMap.put(id, keyVal);
        }
        return biorHeaderMap;
    }

    protected String getInfoMetaObjsAsString(List<InfoMetaObject> infoMetaObjs) {
        StringBuilder keyValsStr = new StringBuilder();
        for (int i = 0; i < infoMetaObjs.size(); ++i) {
            InfoMetaObject infoMetaObj = infoMetaObjs.get(i);
            if (infoMetaObj.type.equals((Object)InfoMetaObject.KeyValType.Flag)) {
                if (!"true".equalsIgnoreCase(infoMetaObj.val.get(0))) continue;
                keyValsStr.append(infoMetaObj.getId()).append(";");
                continue;
            }
            if (infoMetaObj.val.size() <= 0) continue;
            keyValsStr.append(infoMetaObj.getId()).append("=");
            for (int j = 0; j < infoMetaObj.val.size(); ++j) {
                if (j > 0) {
                    keyValsStr.append(",");
                }
                keyValsStr.append(infoMetaObj.val.get(j));
            }
            keyValsStr.append(";");
        }
        if (keyValsStr.length() > 0 && keyValsStr.charAt(keyValsStr.length() - 1) == ';') {
            keyValsStr.deleteCharAt(keyValsStr.length() - 1);
        }
        return keyValsStr.toString();
    }

    protected List<InfoMetaObject> getColumnAsInfoMetaObjects(History history, Integer columnNumZeroBasedNonNeg) {
        String colData = (String)history.get(columnNumZeroBasedNonNeg.intValue());
        ArrayList<InfoMetaObject> infoObjList = new ArrayList<InfoMetaObject>();
        String columnHeaderName = this.getOriginalColumnMetaData(history).get(columnNumZeroBasedNonNeg).getColumnName();
        if (colData != null && colData.length() != 0 && !colData.equals(".")) {
            if (this.isJsonObject(colData)) {
                infoObjList.addAll(this.jsonObjectToInfoMetaObjects("", columnHeaderName, this.stringToJsonObject(colData)));
            } else if (this.isJsonArray(colData)) {
                infoObjList.add(this.jsonArrayToInfoMetaObject("", columnHeaderName, this.stringToJsonArray(colData)));
            } else {
                infoObjList.add(this.stringToInfoMetaObject(history, columnNumZeroBasedNonNeg));
            }
        }
        return infoObjList;
    }

    private JsonObject stringToJsonObject(String s) {
        JsonElement infoElem = new JsonParser().parse(s);
        JsonObject jsonObj = infoElem.getAsJsonObject();
        return jsonObj;
    }

    private JsonArray stringToJsonArray(String s) {
        JsonElement infoElem = new JsonParser().parse(s);
        JsonArray jsonArray = infoElem.getAsJsonArray();
        return jsonArray;
    }

    protected boolean isJsonObject(String colData) {
        boolean isJsonObj = false;
        if (colData.startsWith("{") && colData.endsWith("}")) {
            try {
                this.stringToJsonObject(colData);
                isJsonObj = true;
            }
            catch (Exception e) {
                isJsonObj = false;
            }
        }
        return isJsonObj;
    }

    protected boolean isJsonArray(String colData) {
        boolean isJsonArray = false;
        if (colData.startsWith("[") && colData.endsWith("]")) {
            try {
                this.stringToJsonArray(colData);
                isJsonArray = true;
            }
            catch (Exception e) {
                isJsonArray = false;
            }
        }
        return isJsonArray;
    }

    private List<InfoMetaObject> jsonObjectToInfoMetaObjects(String keyParent, String columnHeaderName, JsonObject jsonObj) {
        Set entrySet = jsonObj.entrySet();
        Map.Entry[] entries = entrySet.toArray(new Map.Entry[0]);
        ArrayList<InfoMetaObject> infoObjList = new ArrayList<InfoMetaObject>();
        for (int i = 0; i < entries.length; ++i) {
            JsonElement elem = (JsonElement)entries[i].getValue();
            String parentPrefix = keyParent == null || keyParent.length() == 0 ? "" : keyParent + ".";
            String key = parentPrefix + (String)entries[i].getKey();
            infoObjList.addAll(this.jsonElementToInfoMetaObjects(key, columnHeaderName, elem));
        }
        return infoObjList;
    }

    public String jsonObjectToInfoDataString(String parentKey, JsonObject jsonObj) {
        StringBuilder info = new StringBuilder();
        String prefix = parentKey == null || parentKey.length() == 0 ? "" : parentKey + ".";
        for (Map.Entry keyVal : jsonObj.entrySet()) {
            String key = prefix + (String)keyVal.getKey();
            String separator = info.length() > 0 ? ";" : "";
            JsonElement val = (JsonElement)keyVal.getValue();
            if (val.isJsonObject()) {
                info.append(separator + this.jsonObjectToInfoDataString(key, val.getAsJsonObject()));
                continue;
            }
            if (val.isJsonArray()) {
                info.append(separator + key + "=");
                for (int i = 0; i < val.getAsJsonArray().size(); ++i) {
                    if (i > 0) {
                        info.append(",");
                    }
                    info.append(val.getAsJsonArray().get(i));
                }
                continue;
            }
            if (!val.isJsonPrimitive()) continue;
            if (val.getAsJsonPrimitive().isBoolean()) {
                if (!val.getAsJsonPrimitive().getAsBoolean()) continue;
                info.append(separator + key);
                continue;
            }
            String valNoQuotes = this.removeQuotes(val.toString());
            if (valNoQuotes.equals(".")) continue;
            info.append(separator + key + "=" + valNoQuotes);
        }
        return info.toString();
    }

    private List<InfoMetaObject> jsonElementToInfoMetaObjects(String key, String columnHeaderName, JsonElement elem) {
        if (elem.isJsonObject()) {
            return this.jsonObjectToInfoMetaObjects(key, columnHeaderName, (JsonObject)elem);
        }
        if (elem.isJsonArray()) {
            return Arrays.asList(this.jsonArrayToInfoMetaObject(key, columnHeaderName, (JsonArray)elem));
        }
        InfoMetaObject infoMeta = this.jsonPrimitiveToInfoMetaObject(key, columnHeaderName, (JsonPrimitive)elem);
        return infoMeta == null ? new ArrayList<InfoMetaObject>() : Arrays.asList(infoMeta);
    }

    private InfoMetaObject jsonArrayToInfoMetaObject(String jsonKey, String columnHeaderName, JsonArray jsonArray) {
        String id = InfoMetaObject.getId(jsonKey, columnHeaderName);
        InfoMetaObject infoMetaObj = this.mInfoMetaMap.get(id);
        if (infoMetaObj == null) {
            infoMetaObj = new InfoMetaObject();
            infoMetaObj.jsonKey = jsonKey;
            infoMetaObj.parentColumnName = columnHeaderName;
            infoMetaObj.type = this.getTypeArray(jsonArray);
            infoMetaObj.numOccurrences = ".";
            this.mInfoMetaMap.put(id, infoMetaObj);
        }
        infoMetaObj.val = new ArrayList<String>();
        for (int j = 0; j < jsonArray.size(); ++j) {
            String val = this.replaceBadCharsAndMetaDelimsInValue("", jsonArray.get(j).toString());
            infoMetaObj.val.add(val);
        }
        return infoMetaObj;
    }

    protected InfoMetaObject.KeyValType getTypeArray(JsonArray jsonArray) {
        ArrayList<InfoMetaObject.KeyValType> typeList = new ArrayList<InfoMetaObject.KeyValType>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            typeList.add(this.getType(jsonArray.get(i)));
        }
        return this.pickMostGeneralType(typeList);
    }

    protected InfoMetaObject.KeyValType getType(JsonElement jsonElem) {
        if (!jsonElem.isJsonPrimitive()) {
            return InfoMetaObject.KeyValType.String;
        }
        JsonPrimitive prim = (JsonPrimitive)jsonElem;
        if (prim.isBoolean()) {
            return InfoMetaObject.KeyValType.Flag;
        }
        if (prim.isNumber()) {
            String primNoQuotes = prim.toString().replaceAll("\"", "");
            if (this.isInteger(primNoQuotes) || primNoQuotes.endsWith(".0") && this.isInteger(primNoQuotes.replace(".0", ""))) {
                return InfoMetaObject.KeyValType.Integer;
            }
            if (this.isDouble(primNoQuotes)) {
                return InfoMetaObject.KeyValType.Float;
            }
        }
        return InfoMetaObject.KeyValType.String;
    }

    protected InfoMetaObject.KeyValType getType(String val) {
        if (val == null || val.trim().length() == 0) {
            return InfoMetaObject.KeyValType.Flag;
        }
        if (this.isInteger(val)) {
            return InfoMetaObject.KeyValType.Integer;
        }
        if (this.isDouble(val)) {
            return InfoMetaObject.KeyValType.Float;
        }
        return InfoMetaObject.KeyValType.String;
    }

    private InfoMetaObject.KeyValType pickMostGeneralType(List<InfoMetaObject.KeyValType> typeList) {
        if (typeList.contains((Object)InfoMetaObject.KeyValType.String)) {
            return InfoMetaObject.KeyValType.String;
        }
        if (typeList.contains((Object)InfoMetaObject.KeyValType.Float)) {
            return InfoMetaObject.KeyValType.Float;
        }
        if (typeList.contains((Object)InfoMetaObject.KeyValType.Integer)) {
            return InfoMetaObject.KeyValType.Integer;
        }
        if (typeList.contains((Object)InfoMetaObject.KeyValType.Flag)) {
            return InfoMetaObject.KeyValType.Flag;
        }
        return InfoMetaObject.KeyValType.String;
    }

    private InfoMetaObject jsonPrimitiveToInfoMetaObject(String parentJsonKey, String columnHeaderName, JsonPrimitive jsonPrimitive) {
        String id = InfoMetaObject.getId(parentJsonKey, columnHeaderName);
        InfoMetaObject infoMetaObj = this.mInfoMetaMap.get(id);
        if (infoMetaObj == null) {
            infoMetaObj = new InfoMetaObject();
            infoMetaObj.jsonKey = parentJsonKey;
            infoMetaObj.parentColumnName = columnHeaderName;
            infoMetaObj.type = this.getType((JsonElement)jsonPrimitive);
            infoMetaObj.numOccurrences = jsonPrimitive.isBoolean() ? "0" : "1";
            this.mInfoMetaMap.put(id, infoMetaObj);
        }
        infoMetaObj.val = new ArrayList<String>();
        if (jsonPrimitive.isBoolean()) {
            infoMetaObj.val.add(jsonPrimitive.toString());
        } else {
            String val = this.replaceBadCharsAndMetaDelimsInValue(parentJsonKey, this.removeDecimalPointIfInteger(jsonPrimitive));
            if (val == null || val.length() == 0) {
                return null;
            }
            infoMetaObj.val.add(val);
        }
        return infoMetaObj;
    }

    private boolean isInteger(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isDouble(String val) {
        try {
            Double.parseDouble(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String removeDecimalPointIfInteger(JsonPrimitive jsonPrimitive) {
        String val = jsonPrimitive.getAsString();
        if (jsonPrimitive.isNumber() && val.endsWith(".0")) {
            val = val.substring(0, val.length() - 2);
        }
        return val;
    }

    protected InfoMetaObject stringToInfoMetaObject(History history, Integer columnNum) {
        String jsonKey = "";
        String columnHeaderName = this.getOriginalColumnMetaData(history).get(columnNum).getColumnName();
        String id = InfoMetaObject.getId(jsonKey, columnHeaderName);
        InfoMetaObject infoMetaObj = this.mInfoMetaMap.get(id);
        if (infoMetaObj == null) {
            infoMetaObj = new InfoMetaObject();
            infoMetaObj.jsonKey = jsonKey;
            infoMetaObj.parentColumnName = columnHeaderName;
            infoMetaObj.type = this.getTypeFromColumnMetaData(history, columnNum);
            infoMetaObj.numOccurrences = this.getNumOccurrencesFromColumnMetaData(history, columnNum);
            infoMetaObj.description = this.getDescFromColumnMetaData(history, columnNum);
            this.mInfoMetaMap.put(id, infoMetaObj);
        }
        infoMetaObj.val = new ArrayList<String>();
        infoMetaObj.val.add(this.replaceBadCharsAndMetaDelimsInValue(columnHeaderName, (String)history.get(columnNum.intValue())));
        return infoMetaObj;
    }

    private List<ColumnMetaData> getOriginalColumnMetaData(History history) {
        if (this.mOriginalColumnMetaData == null) {
            this.mOriginalColumnMetaData = history.getMetaData().getColumns();
        }
        return this.mOriginalColumnMetaData;
    }

    private String getNumOccurrencesFromColumnMetaData(History history, Integer columnNum) {
        String numOccur = ".";
        if (history.getMetaData() != null && history.getMetaData().getColumns() != null && history.getMetaData().getColumns().size() > columnNum && ((numOccur = ((ColumnMetaData)history.getMetaData().getColumns().get(columnNum)).getCount()) == null || numOccur.length() == 0)) {
            numOccur = ".";
        }
        return numOccur;
    }

    private String getDescFromColumnMetaData(History history, Integer columnNum) {
        String desc = "";
        if (history.getMetaData() != null && history.getMetaData().getColumns() != null && history.getMetaData().getColumns().size() > columnNum) {
            desc = ((ColumnMetaData)history.getMetaData().getColumns().get(columnNum)).getDescription();
        }
        return desc;
    }

    private InfoMetaObject.KeyValType getTypeFromColumnMetaData(ColumnMetaData.Type columnType) {
        if (columnType.equals((Object)ColumnMetaData.Type.Boolean)) {
            return InfoMetaObject.KeyValType.Flag;
        }
        if (columnType.equals((Object)ColumnMetaData.Type.Float)) {
            return InfoMetaObject.KeyValType.Float;
        }
        if (columnType.equals((Object)ColumnMetaData.Type.Integer)) {
            return InfoMetaObject.KeyValType.Integer;
        }
        return InfoMetaObject.KeyValType.String;
    }

    private InfoMetaObject.KeyValType getTypeFromColumnMetaData(History history, Integer columnNum) {
        ColumnMetaData.Type columnType = ColumnMetaData.Type.String;
        if (history.getMetaData() != null && history.getMetaData().getColumns() != null && history.getMetaData().getColumns().size() > columnNum) {
            columnType = ((ColumnMetaData)history.getMetaData().getColumns().get(columnNum)).getType();
        }
        return this.getTypeFromColumnMetaData(columnType);
    }

    protected String replaceBadCharsAndMetaDelimsInValue(String key, String value) {
        value = this.removeQuotes(value);
        String delim = this.getDelimiterInMetadataHeader(key);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (delim != null && value.indexOf(delim, i) == i) {
                s.append(",");
                i += delim.length() - 1;
                continue;
            }
            if (this.isASpecialChar(c)) {
                if (CharacterEncodingMethod.SIMPLE.equals((Object)this.characterEncodingMethod)) {
                    s.append(this.replaceCharSimple(c));
                    continue;
                }
                if (CharacterEncodingMethod.URL_BASIC.equals((Object)this.characterEncodingMethod)) {
                    s.append(this.replaceCharUrlBasic(c));
                    continue;
                }
                s.append(this.replaceCharUrlExtended(c));
                continue;
            }
            s.append(c);
        }
        return s.toString();
    }

    private boolean isASpecialChar(char c) {
        return c == ',' || c == '=' || c == ';' || c == ' ' || c == ':' || c == '%' || c == '\r' || c == '\n' || c == '\t';
    }

    private String replaceCharSimple(char c) {
        if (c == ',') {
            return "|";
        }
        if (c == ';') {
            return "|";
        }
        if (c == ' ') {
            return "_";
        }
        if (c == '=') {
            return ":";
        }
        return c + "";
    }

    private String replaceCharUrlBasic(char c) {
        if (c == ',') {
            return "%2C";
        }
        if (c == '=') {
            return "%3D";
        }
        if (c == ';') {
            return "%3B";
        }
        return c + "";
    }

    private String replaceCharUrlExtended(char c) {
        if (c == ',') {
            return "%2C";
        }
        if (c == '=') {
            return "%3D";
        }
        if (c == ';') {
            return "%3B";
        }
        if (c == ':') {
            return "%3A";
        }
        if (c == '%') {
            return "%25";
        }
        if (c == '\r') {
            return "%0D";
        }
        if (c == '\n') {
            return "%0A";
        }
        if (c == '\t') {
            return "%09";
        }
        return c + "";
    }

    private String removeQuotes(String value) {
        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private String getDelimiterInMetadataHeader(String key) {
        if (key == null || key.length() == 0 || this.mBiorHeaderMap == null || this.mBiorHeaderMap.get(key) == null || this.mBiorHeaderMap.get(key).get(AddMetadataLines.BiorMetaControlledVocabulary.DELIMITER.toString()) == null) {
            return null;
        }
        return this.mBiorHeaderMap.get(key).get(AddMetadataLines.BiorMetaControlledVocabulary.DELIMITER.toString());
    }

    public static enum CharacterEncodingMethod {
        SIMPLE,
        URL_BASIC,
        URL_EXTENDED;

    }
}

