/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VEP;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.mayo.bior.pipeline.VEP.SiftPolyphenScore;
import edu.mayo.bior.pipeline.VEP.VepCsqSeqOntComparator;
import edu.mayo.bior.pipeline.VEP.VepCsqSiftPolyphenComparator;
import java.util.Comparator;

public class VepCsqComparator
implements Comparator<JsonObject> {
    private VepCsqSeqOntComparator mSeqOntComparator = new VepCsqSeqOntComparator();
    private VepCsqSiftPolyphenComparator mSiftPolyphenComparator = new VepCsqSiftPolyphenComparator();

    @Override
    public int compare(JsonObject csq1, JsonObject csq2) {
        int comparison = this.compareSeqOnt(csq1, csq2);
        if (comparison != 0) {
            return comparison;
        }
        return this.compareSiftPolTerms(csq1, csq2);
    }

    protected int compareSiftPolTerms(JsonObject csq1, JsonObject csq2) {
        SiftPolyphenScore score1 = this.getSiftPolyphenScore(csq1);
        SiftPolyphenScore score2 = this.getSiftPolyphenScore(csq2);
        return this.mSiftPolyphenComparator.compare(score1, score2);
    }

    protected SiftPolyphenScore getSiftPolyphenScore(JsonObject csq) {
        SiftPolyphenScore score = new SiftPolyphenScore(this.getString(csq.get("SIFT_TERM"), ""), this.getDouble(csq.get("SIFT_Score"), 1.0), this.getString(csq.get("PolyPhen_TERM"), ""), this.getDouble(csq.get("PolyPhen_Score"), 0.0), this.getString(csq.get("Feature"), ""));
        return score;
    }

    protected String getString(JsonElement elem, String defaultVal) {
        if (elem == null) {
            return defaultVal;
        }
        return elem.getAsString();
    }

    protected Double getDouble(JsonElement elem, Double defaultVal) {
        if (elem == null) {
            return defaultVal;
        }
        return elem.getAsDouble();
    }

    protected int compareSeqOnt(JsonObject csq1, JsonObject csq2) {
        JsonElement seqOnt1 = csq1.get("Consequence");
        JsonElement seqOnt2 = csq2.get("Consequence");
        if (seqOnt1 == null && seqOnt2 == null) {
            return 0;
        }
        if (seqOnt1 != null && seqOnt2 == null) {
            return -1;
        }
        if (seqOnt1 == null && seqOnt2 != null) {
            return 1;
        }
        return this.mSeqOntComparator.compare(seqOnt1.getAsString(), seqOnt2.getAsString());
    }
}

