/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;

public class CommandUtil {
    public static File handleFile(CommandLine cl, String option, Collection<FileAttributes> attrs) throws Exception {
        if (cl.hasOption(option)) {
            File file = new File(cl.getOptionValue(option));
            if (attrs.contains((Object)FileAttributes.EXISTS) && !file.exists()) {
                throw new FileNotFoundException(String.format("%s does not exist", file.getAbsolutePath()));
            }
            if (!file.isFile()) {
                throw new IOException(String.format("%s is not a file", file.getAbsolutePath()));
            }
            if (attrs.contains((Object)FileAttributes.READABLE) && !file.canRead()) {
                throw new Exception(String.format("%s permissions issue (not readable)", file.getAbsolutePath()));
            }
            if (attrs.contains((Object)FileAttributes.WRITEABLE) && !file.canWrite()) {
                throw new Exception(String.format("%s permissions issue (not writeable)", file.getAbsolutePath()));
            }
            if (attrs.contains((Object)FileAttributes.EXECUTEABLE) && !file.canExecute()) {
                throw new Exception(String.format("%s permissions issue (not executeable)", file.getAbsolutePath()));
            }
            return file;
        }
        throw new RuntimeException(String.format("Missing option: %s", option));
    }

    public static File handleDirectory(CommandLine cl, String option, Collection<DirectoryAttributes> attrs) throws Exception {
        if (cl.hasOption(option)) {
            File dir = new File(cl.getOptionValue(option));
            if (attrs.contains((Object)DirectoryAttributes.EXISTS) && !dir.exists()) {
                throw new FileNotFoundException(String.format("%s does not exist", dir.getAbsolutePath()));
            }
            if (!dir.isDirectory()) {
                throw new IOException(String.format("%s is not a directory", dir.getAbsolutePath()));
            }
            if (attrs.contains((Object)DirectoryAttributes.READABLE) && !dir.canRead()) {
                throw new Exception(String.format("%s permissions issue (not readable)", dir.getAbsolutePath()));
            }
            if (attrs.contains((Object)DirectoryAttributes.WRITEABLE) && !dir.canWrite()) {
                throw new Exception(String.format("%s permissions issue (not writeable)", dir.getAbsolutePath()));
            }
            if (attrs.contains((Object)DirectoryAttributes.EXECUTEABLE) && !dir.canExecute()) {
                throw new Exception(String.format("%s permissions issue (not executeable)", dir.getAbsolutePath()));
            }
            return dir;
        }
        throw new RuntimeException(String.format("Missing option: %s", option));
    }

    public static int handleInteger(CommandLine cl, String option, Integer min, Integer max) throws Exception {
        if (cl.hasOption(option)) {
            int integer;
            String value = cl.getOptionValue(option);
            try {
                integer = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new Exception(String.format("Option '%s' must be an integer. %s was supplied.", option, value));
            }
            if (min != null && integer < min) {
                throw new Exception(String.format("Option '%s' must be %d or higher. %d was supplied.", option, min, integer));
            }
            if (max != null && integer > max) {
                throw new Exception(String.format("Option '%s' must be %d or lower. %d was supplied.", option, max, integer));
            }
            return integer;
        }
        throw new RuntimeException(String.format("Missing option '%s'", option));
    }

    public static long handleLong(CommandLine cl, String option, Long min, Long max) throws Exception {
        if (cl.hasOption(option)) {
            long longValue;
            String value = cl.getOptionValue(option);
            try {
                longValue = Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                throw new Exception(String.format("Option '%s' must be an integer. %s was supplied.", option, value));
            }
            if (min != null && longValue < min) {
                throw new Exception(String.format("Option '%s' must be %d or higher. %d was supplied.", option, min, longValue));
            }
            if (max != null && longValue > max) {
                throw new Exception(String.format("Option '%s' must be %d or lower. %d was supplied.", option, max, longValue));
            }
            return longValue;
        }
        throw new RuntimeException(String.format("Missing option '%s'", option));
    }

    static enum DirectoryAttributes {
        EXISTS,
        READABLE,
        WRITEABLE,
        EXECUTEABLE;

    }

    static enum FileAttributes {
        EXISTS,
        READABLE,
        WRITEABLE,
        EXECUTEABLE;

    }
}

