/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepExecuteException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.BuildInfoKey;
import edu.mayo.bior.buildcatalog.BuildStepKey;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.pipeline.createcatalog.TjsonToCatalog;
import edu.mayo.exec.Command;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class MakeJsonStep
implements BuildCatalogStepInterface {
    private static Logger sLogger = Logger.getLogger(MakeJsonStep.class);
    private BuildInfo mBuildInfo;
    private StepLogger mStepLogger;
    private int mCmdExitCode;
    private String mCmdStdout;
    private String mCmdStderr;
    private static final String STEP_DISPLAY_NAME = BuildStepKey.MAKE_JSON.getDisplayName();

    public MakeJsonStep(BuildInfo buildInfo, StepLogger stepLogger) {
        this.mBuildInfo = buildInfo;
        this.mStepLogger = stepLogger;
    }

    private void checkInput() throws BuildCatalogStepInputException {
        File scriptFile = this.mBuildInfo.getMakeJsonScriptPathFile();
        if (!scriptFile.exists()) {
            throw new BuildCatalogStepInputException(String.format("Error: could not find %s script '%s'.", STEP_DISPLAY_NAME, this.mBuildInfo.getMakeJsonScriptPath()));
        }
        if (!scriptFile.canExecute()) {
            throw new BuildCatalogStepInputException(String.format("Error: %s script '%s' is not executable.", STEP_DISPLAY_NAME, this.mBuildInfo.getMakeJsonScriptPath()));
        }
    }

    @Override
    public void execute() throws BuildCatalogStepInputException, BuildCatalogStepExecuteException {
        this.checkInput();
        Command cmd = null;
        try {
            String[] cmdArgs = this.createMakeJsonCommand(this.mBuildInfo);
            Map<String, String> envVars = this.getEnvironmentMap(this.mBuildInfo);
            cmd = new Command(cmdArgs, envVars, true);
            String msg = String.format("Executing script '%s' with args: '%s'", this.mBuildInfo.getMakeJsonScriptPath(), this.mBuildInfo.getMakeJsonArgs());
            this.mStepLogger.logAndSummary(msg);
            sLogger.info((Object)msg);
            cmd.execute();
        }
        catch (Exception e) {
            throw new BuildCatalogStepExecuteException(String.format("Problem executing the script during the %s step", STEP_DISPLAY_NAME), e);
        }
        this.mCmdExitCode = cmd.getExitCode();
        this.mCmdStdout = cmd.getStdout();
        this.mCmdStderr = cmd.getStderr();
        String msg = String.format("%s step:%n", STEP_DISPLAY_NAME);
        this.mStepLogger.log(msg);
        sLogger.info((Object)msg);
        String warningLineBreak = this.mCmdExitCode == 0 ? "" : "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
        msg = String.format("%sExit code: %d%n%s", warningLineBreak, this.mCmdExitCode, warningLineBreak);
        this.mStepLogger.log(msg);
        sLogger.info((Object)msg);
        msg = String.format("STDOUT:%n%s%n", this.mCmdStdout);
        this.mStepLogger.log(msg);
        sLogger.info((Object)msg);
        msg = String.format("STDERR:%n%s%n", this.mCmdStderr);
        this.mStepLogger.log(msg);
        sLogger.info((Object)msg);
        this.checkOutput();
    }

    private Map<String, String> getEnvironmentMap(BuildInfo buildInfo) throws IOException {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.putAll(System.getenv());
        envVars.putAll(buildInfo.getMap());
        String path = buildInfo.getVal(BuildInfoKey.PATH);
        if (path != null && path.trim().length() > 0) {
            path = path + ":" + System.getenv().get("PATH");
            envVars.put(BuildInfoKey.PATH.name(), path);
        }
        return envVars;
    }

    private boolean isGiven(String val) {
        return val != null && val.trim().length() > 0;
    }

    private void checkOutput() throws BuildCatalogStepExecuteException {
        File outputFile;
        if (this.mCmdExitCode != 0) {
            String msg = String.format("Output of '%s' was non-zero: %d%nSTDOUT:%n%s%nSTDERR:%n%s%n", this.mBuildInfo.getMakeJsonScriptPath(), this.mCmdExitCode, this.mCmdStdout, this.mCmdStderr);
            throw new BuildCatalogStepExecuteException(msg);
        }
        if (this.mCmdStderr.length() > 0) {
            String msg = String.format("Warning: Saw this output to stderr but exit code was 0. Continuing.%n%s", this.mCmdStderr);
            System.out.println(msg);
        }
        if (!(outputFile = new File(this.mBuildInfo.getMakeJsonOutputFilePath())).exists()) {
            throw new BuildCatalogStepExecuteException(String.format("Error: output file path does not exist: '%s'", outputFile.getPath()));
        }
        if (outputFile.length() == 0L) {
            throw new BuildCatalogStepExecuteException(String.format("Error: output file was empty: '%s'", outputFile.getPath()));
        }
        this.verifyLastColIsJson(outputFile);
    }

    private void verifyLastColIsJson(File outputFile) throws BuildCatalogStepExecuteException {
        BufferedReader fin = null;
        try {
            String line;
            fin = TjsonToCatalog.getBufferedReader(outputFile);
            long lineNum = 1L;
            while ((line = fin.readLine()) != null && lineNum <= 100L) {
                boolean isJson;
                if (line.startsWith("#")) continue;
                String[] cols = line.split("\t");
                String lastCol = cols[cols.length - 1];
                boolean bl = isJson = lastCol.startsWith("{") && lastCol.endsWith("}");
                if (!isJson) {
                    throw new BuildCatalogStepExecuteException(String.format("Error: each line in the %s output must end with a JSON object", STEP_DISPLAY_NAME));
                }
                ++lineNum;
            }
        }
        catch (IOException e) {
            String errMsg = String.format("Issue checking if the output file '%s' has JSON in the last column", outputFile.getPath());
            throw new BuildCatalogStepExecuteException(errMsg, e);
        }
        finally {
            IOUtils.closeQuietly((Reader)fin);
        }
    }

    private String[] createMakeJsonCommand(BuildInfo buildInfo) throws IOException {
        return new String[]{"/bin/sh", "-c", buildInfo.getMakeJsonScriptPath() + "  " + buildInfo.getMakeJsonArgs()};
    }

    int getScriptExitCode() {
        return this.mCmdExitCode;
    }

    String getScriptStderr() {
        return this.mCmdStderr;
    }

    String getScriptStdout() {
        return this.mCmdStdout;
    }
}

