/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli.util;

import edu.mayo.cli.util.CLIConstants;
import edu.mayo.cli.util.CellRenderer;
import edu.mayo.cli.util.SimpleCellRenderer;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Properties;

public class TableFormatter {
    public static final String PRP_HGAP = "PRP_HGAP";
    private static final CellRenderer DEFAULT_RENDERER = new SimpleCellRenderer();
    private static final char UNDERLINE = '-';
    private int mPad = 2;

    public TableFormatter(Properties props) {
        if (props.containsKey(PRP_HGAP)) {
            this.mPad = Integer.parseInt(props.getProperty(PRP_HGAP));
        }
    }

    public void printTable(Formatter formatter, Object[][] data) {
        this.printTable(formatter, null, data, null);
    }

    public void printTable(Formatter formatter, String[] header, Object[][] data) {
        this.printTable(formatter, header, data, null);
    }

    public void printTable(Formatter formatter, String[] header, Object[][] data, CellRenderer[] renderers) {
        int numCols = header != null ? header.length : data[0].length;
        if (renderers == null) {
            renderers = new CellRenderer[numCols];
        }
        for (int i = 0; i < renderers.length; ++i) {
            if (renderers[i] != null) continue;
            renderers[i] = DEFAULT_RENDERER;
        }
        int numRows = data.length;
        int[] maxColWidths = new int[numCols];
        for (int colIdx = 0; colIdx < numCols; ++colIdx) {
            Object[] colData = new Object[numRows];
            for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
                colData[rowIdx] = data[rowIdx][colIdx];
            }
            int max = this.getMaxWidth(colData, renderers[colIdx]);
            if (header != null && max < header[colIdx].length()) {
                max = header[colIdx].length();
            }
            maxColWidths[colIdx] = max;
        }
        StringBuilder sb = new StringBuilder();
        for (int colIdx = 0; colIdx < maxColWidths.length; ++colIdx) {
            if (colIdx > 0) {
                for (int i = 0; i < this.mPad; ++i) {
                    sb.append(" ");
                }
            }
            sb.append("%");
            sb.append(colIdx + 1);
            sb.append("$");
            sb.append("-");
            sb.append(maxColWidths[colIdx]);
            sb.append("s");
        }
        sb.append(CLIConstants.NEW_LINE);
        String f = sb.toString();
        if (header != null) {
            formatter.format(f, header);
            formatter.format(f, this.getHeaderUnderline(header));
        }
        for (Object[] rowData : data) {
            Object[] rowStrs = new String[rowData.length];
            for (int colIdx = 0; colIdx < rowStrs.length; ++colIdx) {
                CellRenderer r = renderers[colIdx];
                rowStrs[colIdx] = r.render(rowData[colIdx]);
            }
            formatter.format(f, rowStrs);
        }
    }

    private String[] getHeaderUnderline(String[] header) {
        String[] underlines = new String[header.length];
        for (int i = 0; i < header.length; ++i) {
            char[] charArr = new char[header[i].length()];
            Arrays.fill(charArr, '-');
            underlines[i] = new String(charArr);
        }
        return underlines;
    }

    private int getMaxWidth(Object[] oArr, CellRenderer r) {
        int max = 0;
        for (Object o : oArr) {
            String s = r.render(o);
            if (s.length() <= max) continue;
            max = s.length();
        }
        return max;
    }
}

