/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createcatalog;

import com.google.code.externalsorting.ExternalSort;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.catalog.HumanBuildAssembly;
import edu.mayo.bior.pipeline.createcatalog.BgzipWriterString;
import edu.mayo.bior.pipeline.createcatalog.TabixCmd;
import edu.mayo.bior.pipeline.createcatalog.TjsonToCatalogNoJsonParsingPipe;
import edu.mayo.bior.pipeline.createcatalog.TjsonToCatalogPipe;
import edu.mayo.pipes.JSON.tabix.BgzipWriter;
import edu.mayo.pipes.MergePipe;
import edu.mayo.pipes.String2HistoryPipe;
import edu.mayo.pipes.UNIX.CatAnythingPipe;
import edu.mayo.pipes.WritePipe;
import edu.mayo.pipes.util.GenomicObjectUtils;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.minidev.json.JSONArray;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TjsonToCatalog {
    private static final Logger sLogger = Logger.getLogger(TjsonToCatalog.class);
    protected String[] mUserChromList = new String[0];
    protected String[] mHumanChromList = new String[0];
    private final JsonPath mJsonPathChrom = JsonPath.compile((String)"_landmark", (Predicate[])new Predicate[0]);
    private final JsonPath mJsonPathMinBp = JsonPath.compile((String)"_minBP", (Predicate[])new Predicate[0]);
    private final JsonPath mJsonPathMaxBp = JsonPath.compile((String)"_maxBP", (Predicate[])new Predicate[0]);
    private final JsonPath mJsonPathRef = JsonPath.compile((String)"_refAllele", (Predicate[])new Predicate[0]);
    private final JsonPath mJsonPathAlts = JsonPath.compile((String)"_altAlleles", (Predicate[])new Predicate[0]);
    public static long REPORT_EVERY_X_LINES = 100000L;
    public static long LINE_TO_START_AT = 0L;

    private Predicate getJsonPredicate() {
        return new Predicate(){

            public boolean apply(Predicate.PredicateContext ctx) {
                return true;
            }
        };
    }

    public void createCatalog(String inputFile, String bgzipCatalogOutFile, boolean isSort, String chromSortOrderFilePath, int jsonCol, boolean isJsonOnly, String tempDirectory, HumanBuildAssembly buildAssembly, boolean isModifyChrom) throws IOException, InterruptedException {
        sLogger.info((Object)("Create catalog\n    inputFile: " + inputFile + "\n    bgzipCatalogOutFile: " + bgzipCatalogOutFile + "\n    chromSortOrderFilePath: " + chromSortOrderFilePath + "\n    isSort: " + isSort + "\n    jsonCol: " + jsonCol + "\n    isJsonOnly: " + isJsonOnly + "\n    tempDirectory: " + tempDirectory + "\n    buildAssembly: " + (Object)((Object)buildAssembly) + "\n    isModifyChrom: " + isModifyChrom));
        if (isSort) {
            sLogger.info((Object)"Sort file: write to a temp file first, split that into multiple files which are then sorted and merged back into one, then bgzip the result and add tabix index if it is not just a JSON-only catalog");
            File tempDir = tempDirectory == null ? null : new File(tempDirectory);
            File tempFile = File.createTempFile("myTempFileToSort", ".tmp", tempDir);
            tempFile.deleteOnExit();
            this.writeCatalogLines_jsonParsing(inputFile, tempFile.getCanonicalPath(), false, jsonCol, isJsonOnly, isModifyChrom);
            this.sortByChrom(tempFile, chromSortOrderFilePath, buildAssembly);
            this.writeBgzipFile(tempFile.getCanonicalPath(), bgzipCatalogOutFile);
        } else {
            sLogger.info((Object)"Write directly to the bgzip catalog file and apply tabix index after (if not a JSON_only catalog)");
            sLogger.info((Object)"No sort will be performed on the catalog.");
            this.writeCatalogLines_jsonParsing(inputFile, bgzipCatalogOutFile, true, jsonCol, isJsonOnly, isModifyChrom);
        }
        boolean isCreateTabixIndex = !isJsonOnly;
        sLogger.info((Object)("isCreateTabixIndex: " + isCreateTabixIndex));
        if (isCreateTabixIndex) {
            TabixCmd.createTabixIndex(bgzipCatalogOutFile);
        }
        sLogger.info((Object)"Done building catalog");
    }

    protected void writeCatalogLines_jsonParsing(String inputFile, String outputFile, boolean isBgzipOut, int jsonCol, boolean isJsonOnly, boolean isModifyChrom) {
        sLogger.info((Object)("Writing catalog format to a temp file (JSON PARSING): " + outputFile));
        boolean isGzip = inputFile.endsWith(".gz") || inputFile.endsWith(".bgz") || TjsonToCatalog.isFileGzip(new File(inputFile));
        String inputFileType = isGzip ? "gzip" : "text";
        BgzipWriter outputWriter = isBgzipOut ? new BgzipWriter(outputFile) : new Pipeline(new Pipe[]{new MergePipe("\t"), new WritePipe(outputFile, false, true)});
        Pipeline pipeline = new Pipeline(new Pipe[]{new CatAnythingPipe(inputFileType), new String2HistoryPipe("\t"), new TjsonToCatalogPipe(jsonCol, isJsonOnly, isModifyChrom), outputWriter});
        pipeline.setStarts(Arrays.asList(inputFile));
        long numLinesWritten = LINE_TO_START_AT;
        while (pipeline.hasNext()) {
            pipeline.next();
            if (++numLinesWritten % REPORT_EVERY_X_LINES != 0L) continue;
            sLogger.info((Object)("Num lines written to catalog format: " + numLinesWritten));
        }
    }

    protected void writeCatalogLines_textParsingOnly(String inputFile, String outputFile, boolean isBgzipOut, int jsonCol, boolean isJsonOnly, boolean isModifyChrom) {
        sLogger.info((Object)("Writing catalog format to a temp file (NO JSON PARSING): " + outputFile));
        boolean isGzip = inputFile.endsWith(".gz") || inputFile.endsWith(".bgz") || TjsonToCatalog.isFileGzip(new File(inputFile));
        String inputFileType = isGzip ? "gzip" : "text";
        BgzipWriterString outputWriter = isBgzipOut ? new BgzipWriterString(outputFile) : new Pipeline(new Pipe[]{new WritePipe(outputFile, false, true)});
        Pipeline pipeline = new Pipeline(new Pipe[]{new CatAnythingPipe(inputFileType), new TjsonToCatalogNoJsonParsingPipe(jsonCol, isJsonOnly, isModifyChrom), outputWriter});
        pipeline.setStarts(Arrays.asList(inputFile));
        long numLinesWritten = LINE_TO_START_AT;
        while (pipeline.hasNext()) {
            pipeline.next();
            if (++numLinesWritten % REPORT_EVERY_X_LINES != 0L) continue;
            sLogger.info((Object)("Num lines written to catalog format: " + numLinesWritten));
        }
    }

    public static FileType getFileType(File file) {
        if (TjsonToCatalog.isFileGzip(file)) {
            if (TjsonToCatalog.isFileBgzip(file)) {
                return FileType.BGZIP;
            }
            return FileType.GZIP;
        }
        return FileType.TEXT;
    }

    public static boolean isFileBgzip(File inputFile) {
        if (!TjsonToCatalog.isFileGzip(inputFile)) {
            return false;
        }
        try {
            BlockCompressedInputStream zipInput = new BlockCompressedInputStream(inputFile);
            zipInput.readLine();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFileGzip(File f) {
        int magic = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
            raf.close();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        return magic == 35615;
    }

    public static BufferedReader getBufferedReader(File file) throws IOException {
        BufferedReader fin = null;
        FileType type = TjsonToCatalog.getFileType(file);
        fin = FileType.BGZIP.equals((Object)type) ? new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream(file))) : (FileType.GZIP.equals((Object)type) ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file)))) : new BufferedReader(new FileReader(file)));
        return fin;
    }

    protected void writeBgzipFile(String inputFile, String bgzipOutputFile) {
        sLogger.info((Object)"Write input file to a bgzip catalog");
        String inputFileType = inputFile.endsWith(".gz") || inputFile.endsWith(".bgz") ? "gzip" : "text";
        Pipeline pipeline = new Pipeline(new Pipe[]{new CatAnythingPipe(inputFileType), new String2HistoryPipe("\t"), new BgzipWriter(bgzipOutputFile)});
        pipeline.setStarts(Arrays.asList(inputFile));
        while (pipeline.hasNext()) {
            pipeline.next();
        }
    }

    public void sortByChrom(File tempInputFile, String chromSortOrderTextFile, HumanBuildAssembly buildAssembly) throws IOException {
        sLogger.info((Object)"Load user and human chromosome files");
        this.loadUserChromList(chromSortOrderTextFile);
        this.loadHumanChromList(buildAssembly);
        Comparator<String> lineComparator = this.getLineComparator();
        File tempDir = tempInputFile.getParentFile();
        sLogger.info((Object)"Break the input file up into multiples and sort, then merge them");
        sLogger.info((Object)("Input file: " + tempInputFile.getCanonicalPath() + "   " + tempInputFile.length() + " bytes"));
        boolean isDistinct_pruneDuplicateLines = false;
        boolean isUseGzipForTempFiles = true;
        int numHeaderLines = 0;
        List sortedPartialFiles = ExternalSort.sortInBatch((File)tempInputFile, lineComparator, (int)1024, (Charset)Charset.defaultCharset(), (File)tempDir, (boolean)isDistinct_pruneDuplicateLines, (int)numHeaderLines, (boolean)isUseGzipForTempFiles);
        sLogger.info((Object)("Sorted temp files: " + sortedPartialFiles.size()));
        for (File f : sortedPartialFiles) {
            sLogger.info((Object)("  " + f.getCanonicalPath() + "   " + f.length() + " bytes"));
        }
        this.deleteAllFilesOnExit(sortedPartialFiles);
        sLogger.info((Object)"Merge all sorted files back into one");
        ExternalSort.mergeSortedFiles((List)sortedPartialFiles, (File)tempInputFile, lineComparator, (Charset)Charset.defaultCharset(), (boolean)isDistinct_pruneDuplicateLines, (boolean)false, (boolean)isUseGzipForTempFiles);
        sLogger.info((Object)("Merged file: " + tempInputFile.getCanonicalPath() + "   " + tempInputFile.length() + " bytes"));
    }

    private void deleteAllFilesOnExit(List<File> filesToDelete) {
        for (File f : filesToDelete) {
            f.deleteOnExit();
        }
    }

    protected int compareLines(String line1, String line2) {
        try {
            String alts2;
            String ref2;
            Integer maxBP2;
            Integer minBP2;
            int score2;
            String[] colsLine1 = line1.split("\t");
            String[] colsLine2 = line2.split("\t");
            if (line1.startsWith("#") || line2.startsWith("#")) {
                Integer iLine1 = new Integer(this.getHeaderScore(line1));
                Integer iLine2 = new Integer(this.getHeaderScore(line2));
                return iLine1.compareTo(iLine2);
            }
            int jsonCol = this.getJsonCol(colsLine1);
            if (jsonCol == -1) {
                return line1.compareToIgnoreCase(line2);
            }
            String json1 = colsLine1[jsonCol];
            String json2 = colsLine2[jsonCol];
            String chr1Lower = this.getChr(json1);
            String chr2Lower = this.getChr(json2);
            int score1 = this.getChromScore(chr1Lower);
            if (score1 != (score2 = this.getChromScore(chr2Lower))) {
                return score1 - score2;
            }
            int chrStrScore = chr1Lower.compareToIgnoreCase(chr2Lower);
            if (chrStrScore != 0) {
                return chrStrScore;
            }
            Integer minBP1 = this.getMinBp(json1);
            int minBpScore = minBP1.compareTo(minBP2 = this.getMinBp(json2));
            if (minBpScore != 0) {
                return minBpScore;
            }
            Integer maxBP1 = this.getMaxBp(json1);
            int maxBpScore = maxBP1.compareTo(maxBP2 = this.getMaxBp(json2));
            if (maxBpScore != 0) {
                return maxBpScore;
            }
            String ref1 = this.getRef(json1);
            int refScore = ref1.compareTo(ref2 = this.getRef(json2));
            if (refScore != 0) {
                return refScore;
            }
            String alts1 = this.altsToString(json1);
            int altsScore = alts1.compareTo(alts2 = this.altsToString(json2));
            if (altsScore != 0) {
                return altsScore;
            }
            return line1.compareToIgnoreCase(line2);
        }
        catch (InvalidPathException e) {
            return line1.compareTo(line2);
        }
        catch (Exception e) {
            System.err.println("Error comparing two lines:");
            System.err.println("  1) " + line1);
            System.err.println("  2) " + line2);
            return line1.compareTo(line2);
        }
    }

    private String getChr(String json) {
        try {
            return ((String)this.mJsonPathChrom.read(json)).toLowerCase();
        }
        catch (Exception e) {
            return ".";
        }
    }

    private Integer getMinBp(String json) {
        try {
            return (Integer)this.mJsonPathMinBp.read(json);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private Integer getMaxBp(String json) {
        try {
            return (Integer)this.mJsonPathMaxBp.read(json);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String getRef(String json) {
        try {
            return ((String)this.mJsonPathRef.read(json)).toUpperCase();
        }
        catch (Exception e) {
            return ".";
        }
    }

    private String altsToString(String json) {
        try {
            JSONArray altsArray = (JSONArray)this.mJsonPathAlts.read(json);
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < altsArray.size(); ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(altsArray.get(i));
            }
            return str.toString().toUpperCase();
        }
        catch (Exception e) {
            return ".";
        }
    }

    private int getJsonCol(String[] ctgRow) {
        int TYPICAL_JSON_COL = 3;
        boolean ALT_JSON_COL = false;
        if (ctgRow.length >= 4 && ctgRow[3].startsWith("{") && ctgRow[3].endsWith("}")) {
            return 3;
        }
        if (ctgRow.length >= 1 && ctgRow[0].startsWith("{") && ctgRow[0].endsWith("}")) {
            return 0;
        }
        return -1;
    }

    protected int getHeaderScore(String line) {
        if (line.startsWith("##")) {
            return 0;
        }
        if (line.startsWith("#")) {
            return 1;
        }
        return 2;
    }

    protected int getChromScore(String chromIn) {
        String chrom = GenomicObjectUtils.computechr((String)chromIn);
        String chromLower = chrom.toLowerCase();
        int score = 0;
        score = this.isInList(chrom, this.mUserChromList) ? this.idxInList(chrom, this.mUserChromList) : (this.isInList(chrom, this.mHumanChromList) ? 1000 + this.idxInList(chrom, this.mHumanChromList) : (this.isInteger(chrom) ? 2000 + Integer.parseInt(chrom) : (StringUtils.isAlphanumeric((String)chrom) && !chromLower.equals("unknown") ? 3000 : (chromLower.contains("random") ? (this.isStartsWithInteger(chrom) ? 4000 + this.getIntegerPrefix(chrom) : 5000) : (!chromLower.equals("unknown") && (chromLower.contains("unknown") || chromLower.startsWith("un_")) ? 6000 : (this.isStartsWithInteger(chrom) ? 7000 + this.getIntegerPrefix(chrom) : (!chromLower.equals("unknown") ? 8000 : 9000)))))));
        return score;
    }

    protected boolean isStartsWithInteger(String s) {
        Integer i = this.getIntegerPrefix(s);
        return i != null;
    }

    protected Integer getIntegerPrefix(String s) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < s.length() && Character.isDigit(s.charAt(i)); ++i) {
            str.append(s.charAt(i));
        }
        if (str.length() == 0) {
            return null;
        }
        return Integer.parseInt(str.toString());
    }

    protected boolean isInteger(String chrom) {
        try {
            Integer.parseInt(chrom);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected int idxInList(String chrom, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            String chromInList = GenomicObjectUtils.computechr((String)list[i]);
            if (!chrom.equalsIgnoreCase(chromInList)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isInList(String chrom, String[] list) {
        return this.idxInList(chrom, list) != -1;
    }

    protected String[] loadUserChromList(String chromosomeListFile) throws IOException {
        File chromListFile;
        if (chromosomeListFile != null && (chromListFile = new File(chromosomeListFile)).exists()) {
            this.mUserChromList = FileUtils.readLines((File)chromListFile).toArray(new String[0]);
        }
        return this.mUserChromList;
    }

    protected String[] loadHumanChromList(HumanBuildAssembly buildAssembly) throws IOException {
        String fileRelativePath = "humanChromosomesSortedByName.GRCh37.txt";
        if (buildAssembly != null && buildAssembly.equals((Object)HumanBuildAssembly.GRCh38)) {
            fileRelativePath = "humanChromosomesSortedByName.GRCh38.txt";
        }
        File file = new File(this.getClass().getClassLoader().getResource(fileRelativePath).getPath());
        this.mHumanChromList = FileUtils.readLines((File)file).toArray(new String[0]);
        return this.mHumanChromList;
    }

    protected Comparator<String> getLineComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String line1, String line2) {
                return TjsonToCatalog.this.compareLines(line1, line2);
            }
        };
    }

    public static enum FileType {
        TEXT,
        GZIP,
        BGZIP;

    }
}

