/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.FormatUtils;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import java.util.Arrays;
import java.util.List;

public class DbsnpFormatter
implements Formatter {
    private static final String[] JSON_DRILL_PATHS = new String[]{"ID", "INFO.dbSNPBuildID", "INFO.SSR", "INFO.SAO"};
    private static final JsonPath PATH_RSID = JsonPath.compile((String)JSON_DRILL_PATHS[0], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_BUILD = JsonPath.compile((String)JSON_DRILL_PATHS[1], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_SSR = JsonPath.compile((String)JSON_DRILL_PATHS[2], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_SAO = JsonPath.compile((String)JSON_DRILL_PATHS[3], (Predicate[])new Predicate[0]);

    @Override
    public JsonColumn getJSONColumn() {
        return JsonColumn.DBSNP_ALL;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("rsID", "dbSNP.build", "dbSNP.SuspectRegion", "dbSNP.SNP_Allele_Origin");
    }

    @Override
    public List<String> getJsonDrillPaths() {
        return Arrays.asList(JSON_DRILL_PATHS);
    }

    @Override
    public List<String> format(String json) {
        return Arrays.asList(FormatUtils.drill(PATH_RSID, json), FormatUtils.drill(PATH_BUILD, json), FormatUtils.drill(PATH_SSR, json), FormatUtils.drill(PATH_SAO, json));
    }

    private String translateSSR(String ssrCode) {
        int code;
        try {
            code = Integer.parseInt(ssrCode);
        }
        catch (NumberFormatException e) {
            return ssrCode;
        }
        switch (code) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "Paralog";
            }
            case 2: {
                return "byEST";
            }
            case 3: {
                return "Para_EST";
            }
            case 4: {
                return "oldAlign";
            }
            case 5: {
                return "other";
            }
        }
        return ssrCode;
    }

    private String translateSAO(String saoCode) {
        int code;
        try {
            code = Integer.parseInt(saoCode);
        }
        catch (NumberFormatException e) {
            return saoCode;
        }
        switch (code) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "Germline";
            }
            case 2: {
                return "Somatic";
            }
            case 3: {
                return "Both";
            }
        }
        return saoCode;
    }
}

