/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.SNPEff;

import edu.mayo.bior.pipeline.SNPEff.SNPEffectHolder;
import java.util.List;

public class SNPEffHelper {
    public static SNPEffectHolder getMostSignificantEffect(List<SNPEffectHolder> effects) {
        SNPEffectHolder mostSignificantEffect = null;
        for (SNPEffectHolder effect : effects) {
            if (mostSignificantEffect != null && !effect.isHigherImpactThan(mostSignificantEffect)) continue;
            mostSignificantEffect = effect;
        }
        return mostSignificantEffect;
    }

    public static enum EffectFunctionalClass {
        NONE(0),
        SILENT(1),
        MISSENSE(2),
        NONSENSE(3);

        private final int priority;

        private EffectFunctionalClass(int priority) {
            this.priority = priority;
        }

        public boolean isHigherPriorityThan(EffectFunctionalClass other) {
            return this.priority > other.priority;
        }
    }

    public static enum EffectImpact {
        MODIFIER(0),
        LOW(1),
        MODERATE(2),
        HIGH(3);

        private final int severityRating;

        private EffectImpact(int severityRating) {
            this.severityRating = severityRating;
        }

        public boolean isHigherImpactThan(EffectImpact other) {
            return this.severityRating > other.severityRating;
        }

        public boolean isSameImpactAs(EffectImpact other) {
            return this.severityRating == other.severityRating;
        }
    }

    public static enum InfoFieldKey {
        EFFECT_KEY("SNPEFF_EFFECT"),
        IMPACT_KEY("SNPEFF_IMPACT"),
        FUNCTIONAL_CLASS_KEY("SNPEFF_FUNCTIONAL_CLASS"),
        CODON_CHANGE_KEY("SNPEFF_CODON_CHANGE"),
        AMINO_ACID_CHANGE_KEY("SNPEFF_AMINO_ACID_CHANGE"),
        GENE_NAME_KEY("SNPEFF_GENE_NAME"),
        GENE_BIOTYPE_KEY("SNPEFF_GENE_BIOTYPE"),
        CODING("SNPEFF_CODING"),
        TRANSCRIPT_ID_KEY("SNPEFF_TRANSCRIPT_ID"),
        EXON_ID_KEY("SNPEFF_EXON_ID");

        private final String keyName;

        private InfoFieldKey(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyName() {
            return this.keyName;
        }
    }
}

