/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.JSON.DrillPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class DrillCommand
implements CommandPlugin {
    private static final char OPTION_KEEP_JSON = 'k';
    private static final char OPTION_PATH = 'p';
    private static final char OPTION_DRILL_COLUMN = 'c';
    private static final char OPTION_ARRAY_DELIMITER = 'd';
    private static final char OPTION_ARRAY_SKIP_NULLS = 's';
    private String delimiter = DrillPipe.ARRAY_DELIMITER_DEFAULT;
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        boolean keepJSON = this.isKeepJson(line);
        int jsonCol = this.getDrillColumn(line);
        String[] drillPaths = this.getDrillPaths(line);
        String arrayDelimiter = this.getArrayDelimiter(line);
        Metadata metadata = new Metadata(jsonCol, this.operation, keepJSON, arrayDelimiter, drillPaths);
        HistoryInPipe preLogic = new HistoryInPipe(metadata);
        DrillPipe logic = new DrillPipe(keepJSON, drillPaths, jsonCol, arrayDelimiter, this.isSkipJsonArrayNullsAndDots(line));
        HistoryOutPipe postLogic = new HistoryOutPipe();
        this.mPipeline.execute(preLogic, logic, postLogic);
    }

    private Integer getDrillColumn(CommandLine line) {
        Integer col = -1;
        if (line.hasOption('c')) {
            col = new Integer(line.getOptionValue('c'));
        }
        return col;
    }

    private String[] getDrillPaths(CommandLine line) {
        ArrayList<String> paths = new ArrayList<String>();
        if (line.hasOption('p')) {
            for (String value : line.getOptionValues('p')) {
                paths.add(value);
            }
        }
        return paths.toArray(new String[paths.size()]);
    }

    private boolean isKeepJson(CommandLine line) {
        return line.hasOption('k');
    }

    private String getArrayDelimiter(CommandLine line) {
        String delim = DrillPipe.ARRAY_DELIMITER_DEFAULT;
        if (line.hasOption('d')) {
            delim = line.getOptionValue('d');
        }
        return delim;
    }

    private boolean isSkipJsonArrayNullsAndDots(CommandLine line) {
        return line.hasOption('s');
    }
}

