/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.stats;

import edu.mayo.bior.catalog.stats.CatalogColumnStats;
import edu.mayo.bior.catalog.stats.CatalogStats;
import edu.mayo.bior.catalog.stats.ValueSampling;
import edu.mayo.pipes.history.ColumnMetaData;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class StatsPrinter {
    public static void printStats(PrintWriter w, CatalogStats catalogStats, String column, ColumnMetaData metaData) {
        StatsPrinter.printMetaDataHeader(w, metaData);
        w.println();
        StatsPrinter.printColumnCharacterStats(w, catalogStats, column);
        w.println();
        StatsPrinter.printColumnValueStats(w, catalogStats, column);
    }

    private static NumberFormat getPercentFormat() {
        NumberFormat defaultFormat = NumberFormat.getPercentInstance();
        defaultFormat.setMinimumFractionDigits(1);
        return defaultFormat;
    }

    private static void printColumnValueStats(PrintWriter w, CatalogStats catalogStats, String column) {
        w.println("# VALUE STATS (sorted by descending frequency)");
        w.println();
        NumberFormat defaultFormat = StatsPrinter.getPercentFormat();
        CatalogColumnStats colStats = catalogStats.getColumnStats(column);
        Comparator<ValueSampling> frequencyComparator = new Comparator<ValueSampling>(){

            @Override
            public int compare(ValueSampling o1, ValueSampling o2) {
                int comparison = Long.valueOf(o2.getFrequency()).compareTo(o1.getFrequency());
                if (comparison == 0) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return comparison;
            }
        };
        ArrayList<ValueSampling> valueSamplings = new ArrayList<ValueSampling>();
        valueSamplings.addAll(colStats.getValueSamplings());
        Collections.sort(valueSamplings, frequencyComparator);
        String format = "\t%1$-12s %2$-8s %3$s";
        w.println(String.format("\t%1$-12s %2$-8s %3$s", "VALUE_COUNT", "VALUE_%", "VALUE"));
        for (ValueSampling valueSampling : valueSamplings) {
            String valCount = valueSampling.getFrequency() + "";
            String valPercent = defaultFormat.format((double)valueSampling.getFrequency() / (double)colStats.getNumEntries());
            w.println(String.format("\t%1$-12s %2$-8s %3$s", valCount, valPercent, valueSampling.getValue()));
        }
    }

    private static void printColumnCharacterStats(PrintWriter w, CatalogStats catalogStats, String column) {
        w.println("# CHARACTER STATS");
        w.println();
        NumberFormat defaultFormat = StatsPrinter.getPercentFormat();
        CatalogColumnStats colStats = catalogStats.getColumnStats(column);
        if (catalogStats.getStoppedReadingAfterChunk()) {
            w.println(String.format("\tTotal Lines read:         %s (stopped reading after chunk due to large catalog size)", catalogStats.getTotalDataLineCount()));
        } else {
            w.println(String.format("\tTotal Lines in file:      %s", catalogStats.getTotalDataLineCount()));
        }
        w.println(String.format("\tNum lines sampled:        %s", catalogStats.getNumLinesSampled()));
        w.println(String.format("\tLines that had column:    %s (%s)", colStats.getNumEntries(), defaultFormat.format((double)colStats.getNumEntries() / (double)catalogStats.getNumLinesSampled())));
        w.println(String.format("\tTotal column value chars: %s", colStats.getNumCharacters()));
        w.println("");
        String format = "\t%1$15s %2$15s %3$15s %4$15s %5$15s";
        ArrayList<String> alphanumeric = new ArrayList<String>();
        ArrayList<String> nonalphanumeric = new ArrayList<String>();
        long[] asciiStatsTotal = colStats.getTotalAsciiStats().counts;
        long[] asciiStatsLine = colStats.getLineAsciiStats().counts;
        for (int i = 0; i < asciiStatsTotal.length; ++i) {
            char c = (char)i;
            long totalCount = asciiStatsTotal[i];
            if (totalCount <= 0L) continue;
            long lineCount = asciiStatsLine[i];
            double totalCountPercent = (double)totalCount / (double)colStats.getNumCharacters();
            double lineCountPercent = (double)lineCount / (double)colStats.getNumEntries();
            String s = String.format("\t%1$15s %2$15s %3$15s %4$15s %5$15s", StatsPrinter.getDisplayValue(c), lineCount, defaultFormat.format(lineCountPercent), totalCount, defaultFormat.format(totalCountPercent));
            if (Character.isLetterOrDigit(c)) {
                alphanumeric.add(s);
                continue;
            }
            nonalphanumeric.add(s);
        }
        w.println("\tNON-Alphanumeric");
        w.println(String.format("\t%1$15s %2$15s %3$15s %4$15s %5$15s", "CHARACTER", "LINE_COUNT", "LINE_%", "CHAR_COUNT", "CHAR_%"));
        for (String s : nonalphanumeric) {
            w.println(s);
        }
        w.println("");
        w.println("\tAlphanumeric");
        w.println(String.format("\t%1$15s %2$15s %3$15s %4$15s %5$15s", "CHARACTER", "LINE_COUNT", "LINE_%", "CHAR_COUNT", "CHAR_%"));
        for (String s : alphanumeric) {
            w.println(s);
        }
    }

    private static String getDisplayValue(char c) {
        if (Character.isISOControl(c)) {
            return StatsPrinter.getControlCharacterDesc(c);
        }
        if (Character.isWhitespace(c)) {
            return "<space>";
        }
        return String.valueOf(c);
    }

    private static String getControlCharacterDesc(char controlChar) {
        switch (controlChar) {
            case '\u0000': {
                return "null";
            }
            case '\u0001': {
                return "start of header";
            }
            case '\u0002': {
                return "start of text";
            }
            case '\u0003': {
                return "end of text";
            }
            case '\u0004': {
                return "end of transmission";
            }
            case '\u0005': {
                return "enquiry";
            }
            case '\u0006': {
                return "acknowledge";
            }
            case '\u0007': {
                return "bell";
            }
            case '\b': {
                return "backspace";
            }
            case '\t': {
                return "horizontal tab";
            }
            case '\n': {
                return "line feed";
            }
            case '\u000b': {
                return "vertical tab";
            }
            case '\f': {
                return "form feed";
            }
            case '\r': {
                return "enter / carriage return";
            }
            case '\u000e': {
                return "shift out";
            }
            case '\u000f': {
                return "shift in";
            }
            case '\u0010': {
                return "data link escape";
            }
            case '\u0011': {
                return "device control 1";
            }
            case '\u0012': {
                return "device control 2";
            }
            case '\u0013': {
                return "device control 3";
            }
            case '\u0014': {
                return "device control 4";
            }
            case '\u0015': {
                return "negative acknowledge";
            }
            case '\u0016': {
                return "synchronize";
            }
            case '\u0017': {
                return "end of trans. block";
            }
            case '\u0018': {
                return "cancel";
            }
            case '\u0019': {
                return "end of medium";
            }
            case '\u001a': {
                return "substitute";
            }
            case '\u001b': {
                return "escape";
            }
            case '\u001c': {
                return "file separator";
            }
            case '\u001d': {
                return "group separator";
            }
            case '\u001e': {
                return "record separator";
            }
            case '\u001f': {
                return "unit separator";
            }
            case '\u007f': {
                return "delete";
            }
        }
        return "UNKNOWN control character ASCII code " + controlChar;
    }

    private static void printMetaDataHeader(PrintWriter w, ColumnMetaData md) {
        w.println("# COLUMN METADATA");
        w.println();
        String format = "\t%1$-12s %2$s";
        w.println(String.format("\t%1$-12s %2$s", "COLUMN", md.getColumnName()));
        w.println(String.format("\t%1$-12s %2$s", "TYPE", md.getType()));
        w.println(String.format("\t%1$-12s %2$s", "COUNT", md.getCount()));
        w.println(String.format("\t%1$-12s %2$s", "DESCRIPTION", md.getDescription()));
    }
}

