/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.markdown.transformer.comparison;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.mayo.bior.catalog.markdown.transformer.MarkdownTransformer;
import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogColumnChangesImpl;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogContentChangesImpl;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogDiffStatistics;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogRowUpdateImpl;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogTableImpl;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogTop5ColumnUpdateImpl;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogVolumeImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ComparisonStatsImpl
implements MarkdownTransformer {
    static final String NOT_AVAILABLE_MESG = "Information is not available";
    private List<MarkdownTransformer> transformers = new ArrayList<MarkdownTransformer>();

    public ComparisonStatsImpl(File comparisonJsonFile) throws IOException {
        CatalogDiffStatistics stats = null;
        if (comparisonJsonFile != null) {
            String comparisonJson = FileUtils.readFileToString((File)comparisonJsonFile);
            stats = this.parseComparisonStatsJson(comparisonJson);
        }
        this.transformers.add(new CatalogTableImpl(stats));
        this.transformers.add(new CatalogVolumeImpl(stats));
        this.transformers.add(new CatalogRowUpdateImpl(stats));
        this.transformers.add(new CatalogTop5ColumnUpdateImpl(stats));
        this.transformers.add(new CatalogColumnChangesImpl(stats));
        this.transformers.add(new CatalogContentChangesImpl(stats));
    }

    @Override
    public String transform(String markdown) throws TransformException {
        for (MarkdownTransformer markdownTransformer : this.transformers) {
            markdown = markdownTransformer.transform(markdown);
        }
        return markdown;
    }

    private CatalogDiffStatistics parseComparisonStatsJson(String json) {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        return (CatalogDiffStatistics)gson.fromJson(json, CatalogDiffStatistics.class);
    }
}

