/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.fasta2ctg;

import edu.mayo.bior.pipeline.createcatalog.TabixCmd;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FastaToCatalog {
    public static void printUsage() {
        System.out.println("Converts a ref assembly fasta file into a BioR catalog");
        System.out.println("USAGE:");
        System.out.println("  _bior_fasta_to_catalog  <RefFastaInput>  <NumBasePairsPerLine>  <CatalogOutFile>");
        System.out.println("  WHERE:");
        System.out.println("    RefFastaInput is a plain-text fasta file in the format:");
        System.out.println("      >chr1");
        System.out.println("      NNNNNNNNNACTGCTAAACCTTTTAGGAAGAGAGAGAAAACCCCCGGGGG");
        System.out.println("      CTGAAAGGTACTGCTAAACCTTTTAGGAAGAGAGAGAAAACCCCCGGGGG");
        System.out.println("      >chr2");
        System.out.println("      ...");
        System.out.println("    NumBasePairsPerLine is the number of base-pairs to add to each line in the catalog.  For example, if you want 10 base-pairs per line:");
        System.out.println("      1  1  10  NNNNNNNNNA");
        System.out.println("      1  11 20  CTGCTAAACC");
        System.out.println("      ...");
        System.out.println("    CatalogOutFile is the new catalog to create, with extension .tsv.bgz");
        System.out.println("      A tabix index will be created for this catalog");
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            FastaToCatalog.printUsage();
            System.exit(0);
        }
        try {
            new FastaToCatalog().fastaToCatalog(args[0], Integer.parseInt(args[1]), args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fastaToCatalog(String fastaRefAssemblyPath, int numBasePairsPerLine, String ctgOutPath) throws Exception {
        if (!ctgOutPath.endsWith(".tsv.bgz")) {
            throw new Exception("Catalog output file shoudl end in .tsv.bgz");
        }
        BufferedReader fin = null;
        fin = fastaRefAssemblyPath.endsWith(".gz") || fastaRefAssemblyPath.endsWith(".bgz") ? new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream(new File(ctgOutPath)))) : new BufferedReader(new FileReader(new File(fastaRefAssemblyPath)));
        BlockCompressedOutputStream fout = new BlockCompressedOutputStream(new File(ctgOutPath));
        String line = null;
        String chrom = "";
        long pos = 1L;
        StringBuilder str = new StringBuilder();
        while ((line = fin.readLine()) != null) {
            if (line.startsWith(";")) continue;
            if (line.startsWith(">")) {
                if (chrom != null && chrom.length() > 0) {
                    pos += (long)this.writeOut(fout, chrom, pos, str, numBasePairsPerLine, true);
                }
                pos = 1L;
                chrom = line.replace(">", "").replace("chr", "");
                str = new StringBuilder();
                continue;
            }
            str.append(line);
            pos += (long)this.writeOut(fout, chrom, pos, str, numBasePairsPerLine, false);
        }
        if (str.length() > 0) {
            pos += (long)this.writeOut(fout, chrom, pos, str, numBasePairsPerLine, true);
        }
        fin.close();
        fout.close();
        TabixCmd.createTabixIndex(ctgOutPath);
    }

    private int writeOut(BlockCompressedOutputStream fout, String chrom, long pos, StringBuilder str, int numBPsPerLine, boolean isForce) throws IOException {
        int numBPsWritten = 0;
        while (isForce ? str.length() > 0 : str.length() >= numBPsPerLine) {
            int numBPsToWrite = str.length() > numBPsPerLine ? numBPsPerLine : str.length();
            long end = pos - 1L + (long)numBPsToWrite;
            String line = chrom + "\t" + pos + "\t" + end + "\t" + str.substring(0, numBPsToWrite).toUpperCase() + "\n";
            fout.write(line.getBytes());
            str.delete(0, numBPsToWrite);
            numBPsWritten += numBPsToWrite;
            pos = end + 1L;
        }
        return numBPsWritten;
    }
}

