/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.index.DynamicIndexCreator;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.index.TribbleIndexCreator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.PositionalOutputStream;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

abstract class IndexingVariantContextWriter
implements VariantContextWriter {
    private final String name;
    private final File location;
    private final SAMSequenceDictionary refDict;
    private OutputStream outputStream;
    private LocationAware locationSource = null;
    private IndexCreator indexer = null;
    private static final String SequenceDictionaryPropertyPredicate = "DICT:";

    private IndexingVariantContextWriter(String string, File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary) {
        this.name = string;
        this.location = file;
        this.outputStream = outputStream;
        this.refDict = sAMSequenceDictionary;
    }

    protected IndexingVariantContextWriter(String string, File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, boolean bl) {
        this(string, file, outputStream, sAMSequenceDictionary);
        if (bl) {
            this.initIndexingWriter(new DynamicIndexCreator(file, IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME));
        }
    }

    protected IndexingVariantContextWriter(String string, File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, boolean bl, IndexCreator indexCreator) {
        this(string, file, outputStream, sAMSequenceDictionary);
        if (bl) {
            this.initIndexingWriter(indexCreator);
        }
    }

    private void initIndexingWriter(IndexCreator indexCreator) {
        this.indexer = indexCreator;
        if (this.outputStream instanceof LocationAware) {
            this.locationSource = (LocationAware)((Object)this.outputStream);
        } else {
            PositionalOutputStream positionalOutputStream = new PositionalOutputStream(this.outputStream);
            this.locationSource = positionalOutputStream;
            this.outputStream = positionalOutputStream;
        }
    }

    @Override
    public boolean checkError() {
        return this.getOutputStream() instanceof PrintStream && ((PrintStream)PrintStream.class.cast(this.getOutputStream())).checkError();
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getStreamName() {
        return this.name;
    }

    @Override
    public abstract void writeHeader(VCFHeader var1);

    @Override
    public void close() {
        try {
            this.outputStream.close();
            if (this.indexer != null) {
                if (this.indexer instanceof TribbleIndexCreator) {
                    IndexingVariantContextWriter.setIndexSequenceDictionary((TribbleIndexCreator)this.indexer, this.refDict);
                }
                Index index = this.indexer.finalizeIndex(this.locationSource.getPosition());
                index.writeBasedOnFeatureFile(this.location);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Unable to close index for " + this.getStreamName(), iOException);
        }
    }

    public SAMSequenceDictionary getRefDict() {
        return this.refDict;
    }

    @Override
    public void add(VariantContext variantContext) {
        if (this.indexer != null) {
            this.indexer.addFeature(variantContext, this.locationSource.getPosition());
        }
    }

    protected static final String writerName(File file, OutputStream outputStream) {
        return file == null ? outputStream.toString() : file.getAbsolutePath();
    }

    private static void setIndexSequenceDictionary(TribbleIndexCreator tribbleIndexCreator, SAMSequenceDictionary sAMSequenceDictionary) {
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            String string = SequenceDictionaryPropertyPredicate + sAMSequenceRecord.getSequenceName();
            String string2 = String.valueOf(sAMSequenceRecord.getSequenceLength());
            tribbleIndexCreator.addProperty(string, string2);
        }
    }
}

