/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.CustomGzipOutputStream;
import htsjdk.samtools.util.IterableOnceIterator;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class IOUtil {
    @Deprecated
    public static final int STANDARD_BUFFER_SIZE = Defaults.NON_ZERO_BUFFER_SIZE;
    public static final long ONE_GB = 0x40000000L;
    public static final long TWO_GBS = 0x80000000L;
    public static final long FIVE_GBS = 0x140000000L;
    public static final String[] VCF_EXTENSIONS = new String[]{".vcf", ".vcf.gz", ".bcf"};
    public static final String INTERVAL_LIST_FILE_EXTENSION = ".interval_list";
    public static final String SAM_FILE_EXTENSION = ".sam";
    public static final String DICT_FILE_EXTENSION = ".dict";
    private static int compressionLevel = Defaults.COMPRESSION_LEVEL;

    public static void setCompressionLevel(int n) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + n);
        }
        compressionLevel = n;
    }

    public static int getCompressionLevel() {
        return compressionLevel;
    }

    public static BufferedInputStream toBufferedStream(InputStream inputStream) {
        if (inputStream instanceof BufferedInputStream) {
            return (BufferedInputStream)inputStream;
        }
        return new BufferedInputStream(inputStream, Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static void transferByStream(InputStream inputStream, OutputStream outputStream, long l) {
        byte[] byArray = new byte[Defaults.NON_ZERO_BUFFER_SIZE];
        try {
            int n;
            for (long i = l; i > 0L; i -= (long)n) {
                n = inputStream.read(byArray, 0, (int)Math.min((long)byArray.length, i));
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    public static OutputStream maybeBufferOutputStream(OutputStream outputStream) {
        return IOUtil.maybeBufferOutputStream(outputStream, Defaults.BUFFER_SIZE);
    }

    public static OutputStream maybeBufferOutputStream(OutputStream outputStream, int n) {
        if (n > 0) {
            return new BufferedOutputStream(outputStream, n);
        }
        return outputStream;
    }

    public static SeekableStream maybeBufferedSeekableStream(SeekableStream seekableStream, int n) {
        return n > 0 ? new SeekableBufferedStream(seekableStream, n) : seekableStream;
    }

    public static SeekableStream maybeBufferedSeekableStream(SeekableStream seekableStream) {
        return IOUtil.maybeBufferedSeekableStream(seekableStream, Defaults.BUFFER_SIZE);
    }

    public static SeekableStream maybeBufferedSeekableStream(File file) {
        try {
            return IOUtil.maybeBufferedSeekableStream(new SeekableFileStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeIOException(fileNotFoundException);
        }
    }

    public static SeekableStream maybeBufferedSeekableStream(URL uRL) {
        return IOUtil.maybeBufferedSeekableStream(new SeekableHTTPStream(uRL));
    }

    public static InputStream maybeBufferInputStream(InputStream inputStream) {
        return IOUtil.maybeBufferInputStream(inputStream, Defaults.BUFFER_SIZE);
    }

    public static InputStream maybeBufferInputStream(InputStream inputStream, int n) {
        if (n > 0) {
            return new BufferedInputStream(inputStream, n);
        }
        return inputStream;
    }

    public static Reader maybeBufferReader(Reader reader, int n) {
        if (n > 0) {
            reader = new BufferedReader(reader, n);
        }
        return reader;
    }

    public static Reader maybeBufferReader(Reader reader) {
        return IOUtil.maybeBufferReader(reader, Defaults.BUFFER_SIZE);
    }

    public static Writer maybeBufferWriter(Writer writer, int n) {
        if (n > 0) {
            writer = new BufferedWriter(writer, n);
        }
        return writer;
    }

    public static Writer maybeBufferWriter(Writer writer) {
        return IOUtil.maybeBufferWriter(writer, Defaults.BUFFER_SIZE);
    }

    public static void deleteFiles(File ... fileArray) {
        for (File file : fileArray) {
            if (file.delete()) continue;
            System.err.println("Could not delete file " + file);
        }
    }

    public static void deleteFiles(Iterable<File> iterable) {
        for (File file : iterable) {
            if (file.delete()) continue;
            System.err.println("Could not delete file " + file);
        }
    }

    public static boolean isRegularPath(File file) {
        return !file.exists() || file.isFile();
    }

    public static File newTempFile(String string, String string2, File[] fileArray, long l) throws IOException {
        File file = null;
        for (int i = 0; i < fileArray.length; ++i) {
            if (i != fileArray.length - 1 && fileArray[i].getUsableSpace() <= l) continue;
            file = File.createTempFile(string, string2, fileArray[i]);
            file.deleteOnExit();
            break;
        }
        return file;
    }

    public static File newTempFile(String string, String string2, File[] fileArray) throws IOException {
        return IOUtil.newTempFile(string, string2, fileArray, 0x140000000L);
    }

    public static File getDefaultTmpDir() {
        String string = System.getProperty("user.name");
        String string2 = System.getProperty("java.io.tmpdir");
        if (string2.endsWith(File.separatorChar + string)) {
            return new File(string2);
        }
        return new File(string2, string);
    }

    public static String basename(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n > 0 && n > string.lastIndexOf(File.separator)) {
            return string.substring(0, n);
        }
        return string;
    }

    public static void assertInputIsValid(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot check validity of null input.");
        }
        if (!IOUtil.isUrl(string)) {
            IOUtil.assertFileIsReadable(new File(string));
        }
    }

    public static boolean isUrl(String string) {
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static void assertFileIsReadable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            throw new SAMException("Cannot read non-existent file: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new SAMException("Cannot read file because it is a directory: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new SAMException("File exists but is not readable: " + file.getAbsolutePath());
        }
    }

    public static void assertFilesAreReadable(List<File> list) {
        for (File file : list) {
            IOUtil.assertFileIsReadable(file);
        }
    }

    public static void assertInputsAreValid(List<String> list) {
        for (String string : list) {
            IOUtil.assertInputIsValid(string);
        }
    }

    public static void assertFileIsWritable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            File file2 = file.getAbsoluteFile().getParentFile();
            if (!file2.exists()) {
                throw new SAMException("Cannot write file: " + file.getAbsolutePath() + ". " + "Neither file nor parent directory exist.");
            }
            if (!file2.isDirectory()) {
                throw new SAMException("Cannot write file: " + file.getAbsolutePath() + ". " + "File does not exist and parent is not a directory.");
            }
            if (!file2.canWrite()) {
                throw new SAMException("Cannot write file: " + file.getAbsolutePath() + ". " + "File does not exist and parent directory is not writable..");
            }
        } else {
            if (file.isDirectory()) {
                throw new SAMException("Cannot write file because it is a directory: " + file.getAbsolutePath());
            }
            if (!file.canWrite()) {
                throw new SAMException("File exists but is not writable: " + file.getAbsolutePath());
            }
        }
    }

    public static void assertFilesAreWritable(List<File> list) {
        for (File file : list) {
            IOUtil.assertFileIsWritable(file);
        }
    }

    public static void assertDirectoryIsWritable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            throw new SAMException("Directory does not exist: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new SAMException("Cannot write to directory because it is not a directory: " + file.getAbsolutePath());
        }
        if (!file.canWrite()) {
            throw new SAMException("Directory exists but is not writable: " + file.getAbsolutePath());
        }
    }

    public static void assertDirectoryIsReadable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            throw new SAMException("Directory does not exist: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new SAMException("Cannot read from directory because it is not a directory: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new SAMException("Directory exists but is not readable: " + file.getAbsolutePath());
        }
    }

    public static void assertFilesEqual(File file, File file2) {
        try {
            int n;
            if (file.length() != file2.length()) {
                throw new SAMException("Files " + file + " and " + file2 + " are different lengths.");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            byte[] byArray = new byte[0x100000];
            byte[] byArray2 = new byte[0x100000];
            while ((n = fileInputStream.read(byArray)) != -1) {
                int n2 = fileInputStream2.read(byArray2);
                if (n != n2) {
                    throw new SAMException("Unexpected EOF comparing files that are supposed to be the same length.");
                }
                if (Arrays.equals(byArray, byArray2)) continue;
                throw new SAMException("Files " + file + " and " + file2 + " differ.");
            }
            fileInputStream.close();
            fileInputStream2.close();
        }
        catch (IOException iOException) {
            throw new SAMException("Exception comparing files " + file + " and " + file2, iOException);
        }
    }

    public static void assertFileSizeNonZero(File file) {
        if (file.length() == 0L) {
            throw new SAMException(file.getAbsolutePath() + " has length 0");
        }
    }

    public static InputStream openFileForReading(File file) {
        try {
            if (file.getName().endsWith(".gz") || file.getName().endsWith(".bfq")) {
                return IOUtil.openGzipFileForReading(file);
            }
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new SAMException("Error opening file: " + file.getName(), iOException);
        }
    }

    public static InputStream openGzipFileForReading(File file) {
        try {
            return new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new SAMException("Error opening file: " + file.getName(), iOException);
        }
    }

    public static OutputStream openFileForWriting(File file) {
        return IOUtil.openFileForWriting(file, false);
    }

    public static OutputStream openFileForWriting(File file, boolean bl) {
        try {
            if (file.getName().endsWith(".gz") || file.getName().endsWith(".bfq")) {
                return IOUtil.openGzipFileForWriting(file, bl);
            }
            return new FileOutputStream(file, bl);
        }
        catch (IOException iOException) {
            throw new SAMException("Error opening file for writing: " + file.getName(), iOException);
        }
    }

    public static BufferedWriter openFileForBufferedWriting(File file, boolean bl) {
        return new BufferedWriter(new OutputStreamWriter(IOUtil.openFileForWriting(file, bl)), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static BufferedWriter openFileForBufferedWriting(File file) {
        return IOUtil.openFileForBufferedWriting(file, false);
    }

    public static BufferedWriter openFileForBufferedUtf8Writing(File file) {
        return new BufferedWriter(new OutputStreamWriter(IOUtil.openFileForWriting(file), Charset.forName("UTF-8")), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static BufferedReader openFileForBufferedUtf8Reading(File file) {
        return new BufferedReader(new InputStreamReader(IOUtil.openFileForReading(file), Charset.forName("UTF-8")));
    }

    public static OutputStream openGzipFileForWriting(File file, boolean bl) {
        try {
            if (Defaults.BUFFER_SIZE > 0) {
                return new CustomGzipOutputStream((OutputStream)new FileOutputStream(file, bl), Defaults.BUFFER_SIZE, compressionLevel);
            }
            return new CustomGzipOutputStream((OutputStream)new FileOutputStream(file, bl), compressionLevel);
        }
        catch (IOException iOException) {
            throw new SAMException("Error opening file for writing: " + file.getName(), iOException);
        }
    }

    public static OutputStream openFileForMd5CalculatingWriting(File file) {
        return new Md5CalculatingOutputStream(IOUtil.openFileForWriting(file), new File(file.getAbsolutePath() + ".md5"));
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) {
        try {
            byte[] byArray = new byte[Defaults.NON_ZERO_BUFFER_SIZE];
            int n = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new SAMException("Exception copying stream", iOException);
        }
    }

    public static void copyFile(File file, File file2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            IOUtil.copyStream(fileInputStream, fileOutputStream);
            ((OutputStream)fileOutputStream).close();
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            throw new SAMException("Error copying " + file + " to " + file2, iOException);
        }
    }

    public static File[] getFilesMatchingRegexp(File file, String string) {
        Pattern pattern = Pattern.compile(string);
        return IOUtil.getFilesMatchingRegexp(file, pattern);
    }

    public static File[] getFilesMatchingRegexp(File file, final Pattern pattern) {
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return pattern.matcher(string).matches();
            }
        });
    }

    public static boolean deleteDirectoryTree(File file) {
        boolean bl = true;
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                bl = bl && IOUtil.deleteDirectoryTree(file2);
            }
        }
        bl = bl && file.delete();
        return bl;
    }

    public static long sizeOfTree(File file) {
        long l = file.length();
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                l += IOUtil.sizeOfTree(file2);
            }
        }
        return l;
    }

    public static void copyDirectoryTree(File file, File file2) {
        if (file.isDirectory()) {
            file2.mkdir();
            for (File file3 : file.listFiles()) {
                File file4 = new File(file2.getPath(), file3.getName());
                if (file3.isDirectory()) {
                    IOUtil.copyDirectoryTree(file3, file4);
                    continue;
                }
                IOUtil.copyFile(file3, file4);
            }
        }
    }

    public static File createTempDir(String string, String string2) {
        try {
            File file = File.createTempFile(string, string2);
            if (!file.delete()) {
                throw new SAMException("Could not delete temporary file " + file);
            }
            if (!file.mkdir()) {
                throw new SAMException("Could not create temporary directory " + file);
            }
            return file;
        }
        catch (IOException iOException) {
            throw new SAMException("Exception creating temporary directory.", iOException);
        }
    }

    public static BufferedReader openFileForBufferedReading(File file) {
        return new BufferedReader(new InputStreamReader(IOUtil.openFileForReading(file)), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static String makeFileNameSafe(String string) {
        return string.trim().replaceAll("[\\s!\"#$%&'()*/:;<=>?@\\[\\]\\\\^`{|}~]", "_");
    }

    public static String fileSuffix(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n > 0 && n > string.lastIndexOf(File.separator)) {
            return string.substring(n);
        }
        return null;
    }

    public static String getFullCanonicalPath(File file) {
        try {
            File file2 = file.getCanonicalFile();
            String string = "";
            while (file2 != null && !file2.getName().equals("")) {
                string = "/" + file2.getName() + string;
                if ((file2 = file2.getParentFile()) == null) continue;
                file2 = file2.getCanonicalFile();
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error getting full canonical path for " + file + ": " + iOException.getMessage(), iOException);
        }
    }

    public static String readFully(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), Defaults.NON_ZERO_BUFFER_SIZE);
            StringBuilder stringBuilder = new StringBuilder(512);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error reading stream", iOException);
        }
    }

    public static IterableOnceIterator<String> readLines(File file) {
        try {
            final BufferedReader bufferedReader = IOUtil.openFileForBufferedReading(file);
            return new IterableOnceIterator<String>(){
                private String next;
                {
                    this.next = bufferedReader.readLine();
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public String next() {
                    try {
                        String string = this.next;
                        this.next = bufferedReader.readLine();
                        if (this.next == null) {
                            bufferedReader.close();
                        }
                        return string;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeIOException(iOException);
                    }
                }

                @Override
                public void close() throws IOException {
                    CloserUtil.close(bufferedReader);
                }
            };
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    public static List<String> slurpLines(File file) throws FileNotFoundException {
        return IOUtil.slurpLines(new FileInputStream(file));
    }

    public static List<String> slurpLines(InputStream inputStream) throws FileNotFoundException {
        return IOUtil.tokenSlurp(inputStream, Charset.defaultCharset(), "\r\n|[\n\r\u2028\u2029\u0085]");
    }

    public static String slurp(File file) throws FileNotFoundException {
        return IOUtil.slurp(new FileInputStream(file));
    }

    public static String slurp(InputStream inputStream) {
        return IOUtil.slurp(inputStream, Charset.defaultCharset());
    }

    public static String slurp(InputStream inputStream, Charset charset) {
        List<String> list = IOUtil.tokenSlurp(inputStream, charset, "\\A");
        return list.isEmpty() ? "" : CollectionUtil.getSoleElement(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> tokenSlurp(InputStream inputStream, Charset charset, String string) {
        try {
            Scanner scanner = new Scanner(inputStream, charset.toString()).useDelimiter(string);
            LinkedList<String> linkedList = new LinkedList<String>();
            while (scanner.hasNext()) {
                linkedList.add(scanner.next());
            }
            LinkedList<String> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            CloserUtil.close(inputStream);
        }
    }

    public static List<File> unrollFiles(Collection<File> collection, String ... stringArray) {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Must provide at least one extension.");
        }
        Stack<File> stack = new Stack<File>();
        ArrayList<File> arrayList = new ArrayList<File>();
        stack.addAll(collection);
        while (!stack.empty()) {
            File file = (File)stack.pop();
            String string = file.getName();
            boolean bl = false;
            for (String string2 : stringArray) {
                if (bl || !string.endsWith(string2)) continue;
                arrayList.add(file);
                bl = true;
            }
            if (bl) continue;
            IOUtil.assertFileIsReadable(file);
            for (String string3 : IOUtil.readLines(file)) {
                if (string3.trim().isEmpty()) continue;
                stack.push(new File(string3.trim()));
            }
        }
        Collections.reverse(arrayList);
        return arrayList;
    }
}

