/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.reference.FastaSequenceFile;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;

public class ReferenceSequenceFileFactory {
    public static final Set<String> FASTA_EXTENSIONS = new HashSet<String>(){
        {
            this.add(".fasta");
            this.add(".fasta.gz");
            this.add(".fa");
            this.add(".fa.gz");
            this.add(".fna");
            this.add(".fna.gz");
            this.add(".txt");
            this.add(".txt.gz");
        }
    };

    public static ReferenceSequenceFile getReferenceSequenceFile(File file) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean bl) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, bl, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean bl, boolean bl2) {
        String string = file.getName();
        for (String string2 : FASTA_EXTENSIONS) {
            if (!string.endsWith(string2)) continue;
            if (bl && bl2 && IndexedFastaSequenceFile.canCreateIndexedFastaReader(file)) {
                try {
                    return new IndexedFastaSequenceFile(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IllegalStateException("Should never happen, because existence of files has been checked.", fileNotFoundException);
                }
            }
            return new FastaSequenceFile(file, bl);
        }
        throw new IllegalArgumentException("File is not a supported reference file type: " + file.getAbsolutePath());
    }
}

