/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.cram.common.IntHashMap;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;

public class DataReaderFactory {
    private static final boolean collectStats = false;

    public AbstractReader buildReader(AbstractReader abstractReader, BitInputStream bitInputStream, Map<Integer, InputStream> map, CompressionHeader compressionHeader, int n) throws IllegalArgumentException, IllegalAccessException {
        abstractReader.captureReadNames = compressionHeader.readNamesIncluded;
        abstractReader.refId = n;
        abstractReader.APDelta = compressionHeader.APDelta;
        for (Field field : abstractReader.getClass().getFields()) {
            Object object;
            Object object2;
            Annotation annotation;
            if (field.isAnnotationPresent(DataSeries.class)) {
                annotation = field.getAnnotation(DataSeries.class);
                object2 = annotation.key();
                object = annotation.type();
                if (compressionHeader.encodingMap.get(object2) == null) {
                    System.err.println("Encoding not found for key: " + (Object)object2);
                }
                field.set(abstractReader, this.createReader((DataSeriesType)((Object)object), compressionHeader.encodingMap.get(object2), bitInputStream, map));
            }
            if (!field.isAnnotationPresent(DataSeriesMap.class) || !"TAG".equals(object2 = (annotation = field.getAnnotation(DataSeriesMap.class)).name())) continue;
            object = new IntHashMap();
            for (Integer n2 : compressionHeader.tMap.keySet()) {
                EncodingParams encodingParams = compressionHeader.tMap.get(n2);
                DataReader dataReader = this.createReader(DataSeriesType.BYTE_ARRAY, encodingParams, bitInputStream, map);
                ((IntHashMap)object).put(n2, dataReader);
            }
            field.set(abstractReader, object);
        }
        abstractReader.tagIdDictionary = compressionHeader.dictionary;
        return abstractReader;
    }

    private <T> DataReader<T> createReader(DataSeriesType dataSeriesType, EncodingParams encodingParams, BitInputStream bitInputStream, Map<Integer, InputStream> map) {
        if (encodingParams.id == EncodingID.NULL) {
            return DataReaderFactory.buildNullReader(dataSeriesType);
        }
        EncodingFactory encodingFactory = new EncodingFactory();
        Encoding encoding = encodingFactory.createEncoding(dataSeriesType, encodingParams.id);
        if (encoding == null) {
            throw new RuntimeException("Encoding not found for value type " + dataSeriesType.name() + ", id=" + (Object)((Object)encodingParams.id));
        }
        encoding.fromByteArray(encodingParams.params);
        return new DefaultDataReader(encoding.buildCodec(map, null), bitInputStream);
    }

    private static <T> DataReader<T> buildNullReader(DataSeriesType dataSeriesType) {
        switch (dataSeriesType) {
            case BYTE: {
                return new SingleValueReader<Byte>((byte)0);
            }
            case INT: {
                return new SingleValueReader<Integer>(0);
            }
            case LONG: {
                return new SingleValueReader<Long>(0L);
            }
            case BYTE_ARRAY: {
                return new SingleValueReader<byte[]>(new byte[0]);
            }
        }
        throw new RuntimeException("Unknown data type: " + dataSeriesType.name());
    }

    public Map<String, DataReaderWithStats> getStats(CramRecordReader cramRecordReader) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, DataReaderWithStats> treeMap = new TreeMap<String, DataReaderWithStats>();
        return treeMap;
    }

    public static class DataReaderWithStats<T>
    implements DataReader<T> {
        public long nanos = 0L;
        final DataReader<T> delegate;

        public DataReaderWithStats(DataReader<T> dataReader) {
            this.delegate = dataReader;
        }

        @Override
        public T readData() throws IOException {
            long l = System.nanoTime();
            T t = this.delegate.readData();
            this.nanos += System.nanoTime() - l;
            return t;
        }

        @Override
        public T readDataArray(int n) throws IOException {
            long l = System.nanoTime();
            T t = this.delegate.readDataArray(n);
            this.nanos += System.nanoTime() - l;
            return t;
        }
    }

    private static class SingleValueReader<T>
    implements DataReader<T> {
        private final T value;

        public SingleValueReader(T t) {
            this.value = t;
        }

        @Override
        public T readData() throws IOException {
            return this.value;
        }

        @Override
        public T readDataArray(int n) {
            return this.value;
        }
    }

    private static class DefaultDataReader<T>
    implements DataReader<T> {
        private final BitCodec<T> codec;
        private final BitInputStream bitInputStream;

        public DefaultDataReader(BitCodec<T> bitCodec, BitInputStream bitInputStream) {
            this.codec = bitCodec;
            this.bitInputStream = bitInputStream;
        }

        @Override
        public T readData() throws IOException {
            return this.codec.read(this.bitInputStream);
        }

        @Override
        public T readDataArray(int n) throws IOException {
            return this.codec.read(this.bitInputStream, n);
        }
    }
}

