/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman.codec;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.huffman.codec.CanonicalHuffmanIntegerCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public class HuffmanIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID ENCODING_ID = EncodingID.HUFFMAN;
    private int[] bitLengths;
    private int[] values;
    private final ByteBuffer buf = ByteBuffer.allocate(10240);

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    @Override
    public byte[] toByteArray() {
        this.buf.clear();
        ITF8.writeUnsignedITF8(this.values.length, this.buf);
        for (int n : this.values) {
            ITF8.writeUnsignedITF8(n, this.buf);
        }
        ITF8.writeUnsignedITF8(this.bitLengths.length, this.buf);
        for (int n : this.bitLengths) {
            ITF8.writeUnsignedITF8(n, this.buf);
        }
        this.buf.flip();
        byte[] byArray = new byte[this.buf.limit()];
        this.buf.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        int n;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n2 = ITF8.readUnsignedITF8(byteBuffer);
        this.values = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.values[n] = ITF8.readUnsignedITF8(byteBuffer);
        }
        n2 = ITF8.readUnsignedITF8(byteBuffer);
        this.bitLengths = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.bitLengths[n] = ITF8.readUnsignedITF8(byteBuffer);
        }
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new CanonicalHuffmanIntegerCodec(this.values, this.bitLengths);
    }

    public static EncodingParams toParam(int[] nArray, int[] nArray2) {
        HuffmanIntegerEncoding huffmanIntegerEncoding = new HuffmanIntegerEncoding();
        huffmanIntegerEncoding.values = nArray;
        huffmanIntegerEncoding.bitLengths = nArray2;
        return new EncodingParams(ENCODING_ID, huffmanIntegerEncoding.toByteArray());
    }

    public boolean equals(Object object) {
        if (object instanceof HuffmanIntegerEncoding) {
            HuffmanIntegerEncoding huffmanIntegerEncoding = (HuffmanIntegerEncoding)object;
            return Arrays.equals(this.bitLengths, huffmanIntegerEncoding.bitLengths) && Arrays.equals(this.values, huffmanIntegerEncoding.values);
        }
        return false;
    }
}

