/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BetaIntegerCodec;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class BetaIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID ENCODING_ID = EncodingID.BETA;
    private int offset;
    private int bitLimit;

    public BetaIntegerEncoding() {
    }

    public BetaIntegerEncoding(int n, int n2) {
        this.offset = n;
        this.bitLimit = n2;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int n, int n2) {
        BetaIntegerEncoding betaIntegerEncoding = new BetaIntegerEncoding();
        betaIntegerEncoding.offset = n;
        betaIntegerEncoding.bitLimit = n2;
        return new EncodingParams(ENCODING_ID, betaIntegerEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, byteBuffer);
        ITF8.writeUnsignedITF8(this.bitLimit, byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.offset = ITF8.readUnsignedITF8(byteBuffer);
        this.bitLimit = ITF8.readUnsignedITF8(byteBuffer);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new BetaIntegerCodec(this.offset, this.bitLimit);
    }
}

