/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import java.io.File;
import java.io.InputStream;

class Indexer
implements Runnable {
    private final File index;
    private final InputStream stream;

    Indexer(File file, InputStream inputStream) {
        this.index = file;
        this.stream = inputStream;
    }

    @Override
    public void run() {
        SamReader samReader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).enable(SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS).disable(SamReaderFactory.Option.VALIDATE_CRC_CHECKSUMS).open(SamInputResource.of(this.stream));
        BAMIndexer bAMIndexer = new BAMIndexer(this.index, samReader.getFileHeader());
        for (SAMRecord sAMRecord : samReader) {
            bAMIndexer.processAlignment(sAMRecord);
        }
        bAMIndexer.finish();
        CloserUtil.close(samReader);
    }
}

