/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.ConstantMemoryDownsamplingIterator;
import htsjdk.samtools.HighAccuracyDownsamplingIterator;
import htsjdk.samtools.SAMRecord;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class ChainedDownsamplingIterator
extends HighAccuracyDownsamplingIterator {
    public static final int MIN_ACCURATE_INPUT_READS = 50000;

    ChainedDownsamplingIterator(Iterator<SAMRecord> iterator, double d, int n) {
        super(new ConstantMemoryDownsamplingIterator(iterator, ChainedDownsamplingIterator.adjustProportion(d), n), d, n);
        long l = ((ConstantMemoryDownsamplingIterator)this.getUnderlyingIterator()).getDiscardedCount();
        this.recordDiscardRecords(l);
    }

    private static double adjustProportion(double d) {
        double d2 = 3.3 * Math.sqrt(d / 50000.0);
        return Math.min(1.0, d + d2);
    }

    @Override
    protected void readFromUnderlyingIterator(List<SAMRecord> list, Set<String> set, int n) {
        ((ConstantMemoryDownsamplingIterator)this.getUnderlyingIterator()).resetStatistics();
        super.readFromUnderlyingIterator(list, set, n);
    }

    @Override
    protected int calculateTemplatesToKeep(int n, double d) {
        ConstantMemoryDownsamplingIterator constantMemoryDownsamplingIterator = (ConstantMemoryDownsamplingIterator)this.getUnderlyingIterator();
        double d2 = constantMemoryDownsamplingIterator.getAcceptedFraction();
        double d3 = Math.max(0.0, Math.min(1.0, d / d2));
        int n2 = super.calculateTemplatesToKeep(n, d3);
        this.recordDiscardRecords(constantMemoryDownsamplingIterator.getDiscardedCount());
        return n2;
    }
}

