/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.math.Conv;
import flanagan.math.Fmath;

public class LinearInterpolation {
    private int nPoints = 0;
    private int nPointsOriginal = 0;
    private double[] y = null;
    private double[] x = null;
    private double yy = Double.NaN;
    private double dydx = Double.NaN;
    private int[] newAndOldIndices;
    private double xMin = Double.NaN;
    private double xMax = Double.NaN;
    private double range = Double.NaN;
    private boolean checkPoints = false;
    private static boolean supress = false;
    private static boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public LinearInterpolation(double[] x, double[] y) {
        this.nPointsOriginal = this.nPoints = x.length;
        if (this.nPoints != y.length) {
            throw new IllegalArgumentException("Arrays x and y are of different length " + this.nPoints + " " + y.length);
        }
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        this.x = new double[this.nPoints];
        this.y = new double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
        }
        this.orderPoints();
        this.checkForIdenticalPoints();
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        LinearInterpolation.potentialRoundingError = potentialRoundingError;
    }

    public static void averageIdenticalAbscissae() {
        averageIdenticalAbscissae = true;
    }

    public void orderPoints() {
        double[] dummy = new double[this.nPoints];
        this.newAndOldIndices = new int[this.nPoints];
        Fmath.selectionSort(this.x, dummy, this.newAndOldIndices);
        Fmath.selectionSort(this.x, this.y, this.x, this.y);
        this.xMin = Fmath.minimum(this.x);
        this.xMax = Fmath.maximum(this.x);
        this.range = this.xMax - this.xMin;
    }

    public double getXmax() {
        return this.xMax;
    }

    public double getXmin() {
        return this.xMin;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin, this.xMax};
        return limits;
    }

    public void displayLimits() {
        System.out.println("\nThe limits of the abscissae (x-values) are " + this.xMin + " and " + this.xMax + "\n");
    }

    public void checkForIdenticalPoints() {
        int nP = this.nPoints;
        boolean test1 = true;
        int ii = 0;
        while (test1) {
            boolean test2 = true;
            int jj = ii + 1;
            while (test2) {
                if (this.x[ii] == this.x[jj]) {
                    int i;
                    double[] yy;
                    if (this.y[ii] == this.y[jj]) {
                        if (!supress) {
                            System.out.print("LinearInterpolation: Two identical points, " + this.x[ii] + ", " + this.y[ii]);
                            System.out.println(", in data array at indices " + this.newAndOldIndices[ii] + " and " + this.newAndOldIndices[jj] + ", latter point removed");
                        }
                        double[] xx = new double[this.nPoints - 1];
                        yy = new double[this.nPoints - 1];
                        int[] naoi = new int[this.nPoints - 1];
                        for (i = 0; i < jj; ++i) {
                            xx[i] = this.x[i];
                            yy[i] = this.y[i];
                            naoi[i] = this.newAndOldIndices[i];
                        }
                        for (i = jj; i < this.nPoints - 1; ++i) {
                            xx[i] = this.x[i + 1];
                            yy[i] = this.y[i + 1];
                            naoi[i] = this.newAndOldIndices[i + 1];
                        }
                        --this.nPoints;
                        this.x = Conv.copy(xx);
                        this.y = Conv.copy(yy);
                        this.newAndOldIndices = Conv.copy(naoi);
                    } else if (averageIdenticalAbscissae) {
                        if (!supress) {
                            System.out.print("LinearInterpolation: Two identical points on the absicca (x-axis) with different ordinate (y-axis) values, " + this.x[ii] + ": " + this.y[ii] + ", " + this.y[jj]);
                            System.out.println(", average of the ordinates taken");
                        }
                        this.y[ii] = (this.y[ii] + this.y[jj]) / 2.0;
                        double[] xx = new double[this.nPoints - 1];
                        yy = new double[this.nPoints - 1];
                        int[] naoi = new int[this.nPoints - 1];
                        for (i = 0; i < jj; ++i) {
                            xx[i] = this.x[i];
                            yy[i] = this.y[i];
                            naoi[i] = this.newAndOldIndices[i];
                        }
                        for (i = jj; i < this.nPoints - 1; ++i) {
                            xx[i] = this.x[i + 1];
                            yy[i] = this.y[i + 1];
                            naoi[i] = this.newAndOldIndices[i + 1];
                        }
                        --this.nPoints;
                        this.x = Conv.copy(xx);
                        this.y = Conv.copy(yy);
                        this.newAndOldIndices = Conv.copy(naoi);
                    } else {
                        double sepn = this.range * 5.0E-4;
                        if (!supress) {
                            System.out.print("LinearInterpolation: Two identical points on the absicca (x-axis) with different ordinate (y-axis) values, " + this.x[ii] + ": " + this.y[ii] + ", " + this.y[jj]);
                        }
                        boolean check = false;
                        if (ii == 0) {
                            if (this.x[2] - this.x[1] <= sepn) {
                                sepn = (this.x[2] - this.x[1]) / 2.0;
                            }
                            check = this.y[0] > this.y[1] ? (this.y[1] > this.y[2] ? this.stay(ii, jj, sepn) : this.swap(ii, jj, sepn)) : (this.y[2] <= this.y[1] ? this.swap(ii, jj, sepn) : this.stay(ii, jj, sepn));
                        }
                        if (jj == this.nPoints - 1) {
                            if (this.x[nP - 2] - this.x[nP - 3] <= sepn) {
                                sepn = (this.x[nP - 2] - this.x[nP - 3]) / 2.0;
                            }
                            check = this.y[ii] <= this.y[jj] ? (this.y[ii - 1] <= this.y[ii] ? this.stay(ii, jj, sepn) : this.swap(ii, jj, sepn)) : (this.y[ii - 1] <= this.y[ii] ? this.swap(ii, jj, sepn) : this.stay(ii, jj, sepn));
                        }
                        if (ii != 0 && jj != this.nPoints - 1) {
                            if (this.x[ii] - this.x[ii - 1] <= sepn) {
                                sepn = (this.x[ii] - this.x[ii - 1]) / 2.0;
                            }
                            if (this.x[jj + 1] - this.x[jj] <= sepn) {
                                sepn = (this.x[jj + 1] - this.x[jj]) / 2.0;
                            }
                            if (this.y[ii] > this.y[ii - 1]) {
                                if (this.y[jj] > this.y[ii]) {
                                    check = this.y[jj] > this.y[jj + 1] ? (this.y[ii - 1] <= this.y[jj + 1] ? this.stay(ii, jj, sepn) : this.swap(ii, jj, sepn)) : this.stay(ii, jj, sepn);
                                } else if (this.y[jj + 1] > this.y[jj]) {
                                    if (this.y[jj + 1] > this.y[ii - 1] && this.y[jj + 1] > this.y[ii - 1]) {
                                        check = this.stay(ii, jj, sepn);
                                    }
                                } else {
                                    check = this.swap(ii, jj, sepn);
                                }
                            } else if (this.y[jj] > this.y[ii]) {
                                if (this.y[jj + 1] > this.y[jj]) {
                                    check = this.stay(ii, jj, sepn);
                                }
                            } else {
                                check = this.y[jj + 1] > this.y[ii - 1] ? this.stay(ii, jj, sepn) : this.swap(ii, jj, sepn);
                            }
                        }
                        if (!check) {
                            check = this.stay(ii, jj, sepn);
                        }
                        if (!supress) {
                            System.out.println(", the two abscissae have been separated by a distance " + sepn);
                        }
                        ++jj;
                    }
                    if (this.nPoints - 1 == ii) {
                        test2 = false;
                    }
                } else {
                    ++jj;
                }
                if (jj < this.nPoints) continue;
                test2 = false;
            }
            if (++ii < this.nPoints - 1) continue;
            test1 = false;
        }
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("Removal of duplicate points has reduced the number of points to less than the required minimum of three data points");
        }
        this.checkPoints = true;
    }

    private boolean swap(int ii, int jj, double sepn) {
        int n = ii;
        this.x[n] = this.x[n] + sepn;
        int n2 = jj;
        this.x[n2] = this.x[n2] - sepn;
        double hold = this.x[ii];
        this.x[ii] = this.x[jj];
        this.x[jj] = hold;
        hold = this.y[ii];
        this.y[ii] = this.y[jj];
        this.y[jj] = hold;
        return true;
    }

    private boolean stay(int ii, int jj, double sepn) {
        int n = ii;
        this.x[n] = this.x[n] - sepn;
        int n2 = jj;
        this.x[n2] = this.x[n2] + sepn;
        return true;
    }

    public static void supress() {
        supress = true;
    }

    public static void unsupress() {
        supress = false;
    }

    public double interpolate(double xx) {
        int i;
        if (xx < this.x[0]) {
            if (roundingCheck && Math.abs(this.x[0] - xx) <= Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.x[0])))) * potentialRoundingError) {
                xx = this.x[0];
            } else {
                throw new IllegalArgumentException("x (" + xx + ") is outside the range of data points (" + this.x[0] + " to " + this.x[this.nPoints - 1] + ")");
            }
        }
        if (xx > this.x[this.nPoints - 1]) {
            if (roundingCheck && Math.abs(xx - this.x[this.nPoints - 1]) <= Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.x[this.nPoints - 1])))) * potentialRoundingError) {
                xx = this.x[this.nPoints - 1];
            } else {
                throw new IllegalArgumentException("x (" + xx + ") is outside the range of data points (" + this.x[0] + " to " + this.x[this.nPoints - 1] + ")");
            }
        }
        boolean flag = true;
        for (i = 0; i < this.nPoints; ++i) {
            if (xx == this.x[i]) {
                this.yy = this.y[i];
                flag = false;
            }
            if (!flag) break;
        }
        if (flag) {
            for (i = 1; i < this.nPoints; ++i) {
                if (xx < this.x[i]) {
                    this.yy = this.y[i] - (this.y[i] - this.y[i - 1]) * (this.x[i] - xx) / (this.x[i] - this.x[i - 1]);
                    flag = false;
                }
                if (!flag) break;
            }
        }
        return this.yy;
    }
}

