/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.CubicSplineShort;

public class BiCubicSplineShort {
    private int nPoints = 0;
    private int mPoints = 0;
    private double[][] y = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private CubicSplineShort[] csn = null;
    private CubicSplineShort csm = null;

    public BiCubicSplineShort(double[] x1, double[] x2, double[][] y) {
        int i;
        this.nPoints = x1.length;
        this.mPoints = x2.length;
        this.csm = new CubicSplineShort(this.nPoints);
        this.csn = CubicSplineShort.oneDarray(this.nPoints, this.mPoints);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        for (i = 0; i < this.nPoints; ++i) {
            this.x1[i] = x1[i];
        }
        for (int j = 0; j < this.mPoints; ++j) {
            this.x2[j] = x2[j];
        }
        for (i = 0; i < this.nPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                this.y[i][j] = y[i][j];
            }
        }
        double[] yTempn = new double[this.mPoints];
        for (int i2 = 0; i2 < this.nPoints; ++i2) {
            for (int j = 0; j < this.mPoints; ++j) {
                yTempn[j] = y[i2][j];
            }
            this.csn[i2].resetData(x2, yTempn);
            this.csn[i2].calcDeriv();
        }
    }

    public double interpolate(double xx1, double xx2) {
        double[] yTempm = new double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            yTempm[i] = this.csn[i].interpolate(xx2);
        }
        this.csm.resetData(this.x1, yTempm);
        return this.csm.interpolate(xx1);
    }
}

